/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class Roundtrip {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/features.html#xmldecl-standalone";
    private static final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    private XmlPullParser parser;
    private XmlSerializer serializer;

    private Roundtrip(XmlPullParser xmlPullParser, XmlSerializer xmlSerializer) {
        this.parser = xmlPullParser;
        this.serializer = xmlSerializer;
    }

    private void writeStartTag() throws XmlPullParserException, IOException {
        int n;
        if (!this.parser.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
            for (n = this.parser.getNamespaceCount(this.parser.getDepth() - 1); n <= this.parser.getNamespaceCount(this.parser.getDepth()) - 1; ++n) {
                this.serializer.setPrefix(this.parser.getNamespacePrefix(n), this.parser.getNamespaceUri(n));
            }
        }
        this.serializer.startTag(this.parser.getNamespace(), this.parser.getName());
        for (n = 0; n < this.parser.getAttributeCount(); ++n) {
            this.serializer.attribute(this.parser.getAttributeNamespace(n), this.parser.getAttributeName(n), this.parser.getAttributeValue(n));
        }
    }

    private void writeToken(int n) throws XmlPullParserException, IOException {
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)this.parser.getProperty(PROPERTY_XMLDECL_STANDALONE);
                this.serializer.startDocument(this.parser.getInputEncoding(), bl);
                break;
            }
            case 1: {
                this.serializer.endDocument();
                break;
            }
            case 2: {
                this.writeStartTag();
                break;
            }
            case 3: {
                this.serializer.endTag(this.parser.getNamespace(), this.parser.getName());
                break;
            }
            case 7: {
                String string = this.parser.getText();
                this.serializer.ignorableWhitespace(string);
                break;
            }
            case 4: {
                this.serializer.text(this.parser.getText());
                break;
            }
            case 6: {
                this.serializer.entityRef(this.parser.getName());
                break;
            }
            case 5: {
                this.serializer.cdsect(this.parser.getText());
                break;
            }
            case 8: {
                this.serializer.processingInstruction(this.parser.getText());
                break;
            }
            case 9: {
                this.serializer.comment(this.parser.getText());
                break;
            }
            case 10: {
                this.serializer.docdecl(this.parser.getText());
            }
        }
    }

    private void roundTrip() throws XmlPullParserException, IOException {
        this.parser.nextToken();
        this.writeToken(0);
        while (this.parser.getEventType() != 1) {
            this.writeToken(this.parser.getEventType());
            this.parser.nextToken();
        }
        this.writeToken(1);
    }

    private static void roundTrip(Reader reader, Writer writer, String string) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput(reader);
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput(writer);
        if (string != null) {
            xmlSerializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, string);
        }
        new Roundtrip(xmlPullParser, xmlSerializer).roundTrip();
    }

    private static void roundTrip(XmlPullParserFactory xmlPullParserFactory, String string) throws XmlPullParserException, IOException {
        Roundtrip.roundTrip(xmlPullParserFactory, string, null);
    }

    private static void roundTrip(XmlPullParserFactory xmlPullParserFactory, String string, String string2) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput(new URL(string).openStream(), null);
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput(System.out, null);
        if (string2 != null) {
            xmlSerializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, string2);
        }
        new Roundtrip(xmlPullParser, xmlSerializer).roundTrip();
    }

    public static void main(String[] stringArray) throws Exception {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        for (int i = 0; i < 1; ++i) {
            Roundtrip.roundTrip(xmlPullParserFactory, stringArray[i], "  ");
        }
    }
}

