/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    private static final Double NaN = new Double(Double.NaN);

    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 1) {
            return NumberFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("number() requires one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            if (object == Boolean.TRUE) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                Double d = new Double(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(Double.NaN);
            }
        }
        if (object instanceof List || object instanceof Iterator) {
            String string = StringFunction.evaluate(object, navigator);
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (navigator.isElement(object) || navigator.isAttribute(object)) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        return new Double(Double.NaN);
    }

    public static boolean isNaN(double d) {
        return NumberFunction.isNaN(new Double(d));
    }

    public static boolean isNaN(Double d) {
        return d.equals(NaN);
    }
}

