/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.FilterExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Predicate;
import org.xmlpull.v1.builder.xpath.jaxen.expr.PredicateSet;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Predicated;

public class DefaultFilterExpr
extends DefaultExpr
implements FilterExpr,
Predicated {
    private Expr expr;
    private PredicateSet predicates;

    public DefaultFilterExpr() {
        this.predicates = new PredicateSet();
    }

    public DefaultFilterExpr(Expr expr) {
        this.expr = expr;
        this.predicates = new PredicateSet();
    }

    @Override
    public void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    @Override
    public List getPredicates() {
        return this.predicates.getPredicates();
    }

    @Override
    public PredicateSet getPredicateSet() {
        return this.predicates;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public String toString() {
        return "[(DefaultFilterExpr): expr: " + this.expr + " predicates: " + this.predicates + " ]";
    }

    @Override
    public String getText() {
        String string = "";
        if (this.expr != null) {
            string = this.expr.getText();
        }
        string = string + this.predicates.getText();
        return string;
    }

    @Override
    public Expr simplify() {
        this.predicates.simplify();
        if (this.expr != null) {
            this.expr = this.expr.simplify();
        }
        if (this.predicates.getPredicates().size() == 0) {
            return this.getExpr();
        }
        return this;
    }

    @Override
    public boolean asBoolean(Context context) throws JaxenException {
        Serializable serializable;
        ArrayList arrayList = null;
        if (this.expr != null) {
            arrayList = this.expr.evaluate(context);
        } else {
            serializable = new ArrayList(1);
            ((ArrayList)serializable).addAll(context.getNodeSet());
            arrayList = serializable;
        }
        if (arrayList instanceof Boolean) {
            serializable = (Boolean)((Object)arrayList);
            return (Boolean)serializable;
        }
        if (arrayList instanceof List) {
            return this.getPredicateSet().evaluateAsBoolean(arrayList, context.getContextSupport());
        }
        return false;
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        Object object = this.getExpr().evaluate(context);
        if (object instanceof List) {
            List list = this.getPredicateSet().evaluatePredicates((List)object, context.getContextSupport());
            object = list;
        }
        return object;
    }
}

