/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlCharacters;
import org.xmlpull.v1.builder.XmlComment;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.XmlSerializable;
import org.xmlpull.v1.builder.impl.XmlDocumentImpl;
import org.xmlpull.v1.builder.impl.XmlElementImpl;
import org.xmlpull.v1.builder.impl.XmlNamespaceImpl;

public class XmlInfosetBuilderImpl
extends XmlInfosetBuilder {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    private static final String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";

    @Override
    public XmlDocument newDocument(String string, Boolean bl, String string2) {
        return new XmlDocumentImpl(string, bl, string2);
    }

    @Override
    public XmlElement newFragment(String string) {
        return new XmlElementImpl((XmlNamespace)null, string);
    }

    @Override
    public XmlElement newFragment(String string, String string2) {
        return new XmlElementImpl(string, string2);
    }

    @Override
    public XmlElement newFragment(XmlNamespace xmlNamespace, String string) {
        return new XmlElementImpl(xmlNamespace, string);
    }

    @Override
    public XmlNamespace newNamespace(String string) {
        return new XmlNamespaceImpl(null, string);
    }

    @Override
    public XmlNamespace newNamespace(String string, String string2) {
        return new XmlNamespaceImpl(string, string2);
    }

    @Override
    public XmlDocument parse(XmlPullParser xmlPullParser) {
        XmlDocument xmlDocument = this.parseDocumentStart(xmlPullParser);
        XmlElement xmlElement = this.parseFragment(xmlPullParser);
        xmlDocument.setDocumentElement(xmlElement);
        return xmlDocument;
    }

    @Override
    public Object parseItem(XmlPullParser xmlPullParser) {
        try {
            int n = xmlPullParser.getEventType();
            if (n == 2) {
                return this.parseStartTag(xmlPullParser);
            }
            if (n == 4) {
                return xmlPullParser.getText();
            }
            if (n == 0) {
                return this.parseDocumentStart(xmlPullParser);
            }
            throw new XmlBuilderException("currently unsupported event type " + XmlPullParser.TYPES[n] + xmlPullParser.getPositionDescription());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML item", xmlPullParserException);
        }
    }

    private XmlDocument parseDocumentStart(XmlPullParser xmlPullParser) {
        XmlDocumentImpl xmlDocumentImpl = null;
        try {
            if (xmlPullParser.getEventType() != 0) {
                throw new XmlBuilderException("parser must be positioned on beginning of document and not " + xmlPullParser.getPositionDescription());
            }
            xmlPullParser.next();
            String string = (String)xmlPullParser.getProperty(PROPERTY_XMLDECL_VERSION);
            Boolean bl = (Boolean)xmlPullParser.getProperty(PROPERTY_XMLDECL_STANDALONE);
            String string2 = xmlPullParser.getInputEncoding();
            xmlDocumentImpl = new XmlDocumentImpl(string, bl, string2);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML document prolog", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not read XML document prolog", iOException);
        }
        return xmlDocumentImpl;
    }

    @Override
    public XmlElement parseFragment(XmlPullParser xmlPullParser) {
        try {
            int n = xmlPullParser.getDepth();
            int n2 = xmlPullParser.getEventType();
            if (n2 != 2) {
                throw new XmlBuilderException("expected parser to be on start tag and not " + XmlPullParser.TYPES[n2] + xmlPullParser.getPositionDescription());
            }
            XmlElement xmlElement = this.parseStartTag(xmlPullParser);
            while (true) {
                XmlContainer xmlContainer;
                if ((n2 = xmlPullParser.next()) == 2) {
                    xmlContainer = this.parseStartTag(xmlPullParser);
                    xmlElement.addElement((XmlElement)xmlContainer);
                    xmlElement = xmlContainer;
                    continue;
                }
                if (n2 == 3) {
                    xmlContainer = xmlElement.getParent();
                    if (xmlContainer == null) {
                        if (xmlPullParser.getDepth() != n) {
                            throw new XmlBuilderException("unbalanced input" + xmlPullParser.getPositionDescription());
                        }
                        return xmlElement;
                    }
                    xmlElement = xmlContainer;
                    continue;
                }
                if (n2 != 4) continue;
                xmlElement.addChild(xmlPullParser.getText());
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not build tree from XML", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not read XML tree content", iOException);
        }
    }

    @Override
    public XmlElement parseStartTag(XmlPullParser xmlPullParser) {
        try {
            int n;
            if (xmlPullParser.getEventType() != 2) {
                throw new XmlBuilderException("parser must be on START_TAG and not " + xmlPullParser.getPositionDescription());
            }
            String string = xmlPullParser.getPrefix();
            XmlNamespaceImpl xmlNamespaceImpl = new XmlNamespaceImpl(string, xmlPullParser.getNamespace());
            XmlElementImpl xmlElementImpl = new XmlElementImpl(xmlNamespaceImpl, xmlPullParser.getName());
            for (n = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1); n < xmlPullParser.getNamespaceCount(xmlPullParser.getDepth()); ++n) {
                String string2 = xmlPullParser.getNamespacePrefix(n);
                xmlElementImpl.declareNamespace(string2 == null ? "" : string2, xmlPullParser.getNamespaceUri(n));
            }
            for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
                xmlElementImpl.addAttribute(xmlPullParser.getAttributeType(n), xmlPullParser.getAttributePrefix(n), xmlPullParser.getAttributeNamespace(n), xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeValue(n), !xmlPullParser.isAttributeDefault(n));
            }
            return xmlElementImpl;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML start tag", xmlPullParserException);
        }
    }

    @Override
    public XmlDocument parseLocation(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XmlBuilderException("could not parse URL " + string, malformedURLException);
        }
        try {
            return this.parseInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not open connection to URL " + string, iOException);
        }
    }

    @Override
    public void serialize(Object object, XmlSerializer xmlSerializer) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.serialize(iterator.next(), xmlSerializer);
            }
        } else if (object instanceof XmlContainer) {
            this.serializeContainer((XmlContainer)object, xmlSerializer);
        } else {
            this.serializeItem(object, xmlSerializer);
        }
    }

    private void serializeContainer(XmlContainer xmlContainer, XmlSerializer xmlSerializer) {
        if (xmlContainer instanceof XmlSerializable) {
            try {
                ((XmlSerializable)((Object)xmlContainer)).serialize(xmlSerializer);
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("could not serialize node " + xmlContainer + ": " + iOException, iOException);
            }
        } else if (xmlContainer instanceof XmlDocument) {
            this.serializeDocument((XmlDocument)xmlContainer, xmlSerializer);
        } else if (xmlContainer instanceof XmlElement) {
            this.serializeFragment((XmlElement)xmlContainer, xmlSerializer);
        } else {
            throw new IllegalArgumentException("could not serialzie unknown XML container " + xmlContainer.getClass());
        }
    }

    @Override
    public void serializeItem(Object clazz, XmlSerializer xmlSerializer) {
        block8: {
            try {
                if (clazz instanceof XmlSerializable) {
                    try {
                        ((XmlSerializable)((Object)clazz)).serialize(xmlSerializer);
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new XmlBuilderException("could not serialize item " + clazz + ": " + iOException, iOException);
                    }
                }
                if (clazz instanceof String) {
                    xmlSerializer.text(((Object)clazz).toString());
                    break block8;
                }
                if (clazz instanceof XmlCharacters) {
                    xmlSerializer.text(((XmlCharacters)((Object)clazz)).getText());
                    break block8;
                }
                if (clazz instanceof XmlComment) {
                    xmlSerializer.comment(((XmlComment)((Object)clazz)).getContent());
                    break block8;
                }
                throw new IllegalArgumentException("could not serialize " + (clazz != null ? clazz.getClass() : clazz));
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("serializing XML start tag failed", iOException);
            }
        }
    }

    @Override
    public void serializeStartTag(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        try {
            Object object;
            Object object2;
            String string;
            XmlNamespace xmlNamespace = xmlElement.getNamespace();
            String string2 = string = xmlNamespace != null ? xmlNamespace.getPrefix() : "";
            if (string == null) {
                string = "";
            }
            String string3 = null;
            if (xmlElement.hasNamespaceDeclarations()) {
                object2 = xmlElement.namespaces();
                while (object2.hasNext()) {
                    object = (XmlNamespace)object2.next();
                    String string4 = object.getPrefix();
                    if (!string.equals(string4)) {
                        xmlSerializer.setPrefix(string4, object.getNamespaceName());
                        continue;
                    }
                    string3 = object.getNamespaceName();
                }
            }
            if (string3 != null) {
                xmlSerializer.setPrefix(string, string3);
            } else if (xmlNamespace != null) {
                object2 = xmlNamespace.getNamespaceName();
                if (object2 == null) {
                    object2 = "";
                }
                object = null;
                if (((String)object2).length() > 0) {
                    xmlSerializer.getPrefix((String)object2, false);
                }
                if (object == null) {
                    object = "";
                }
                if (object != string && !((String)object).equals(string)) {
                    xmlSerializer.setPrefix(string, (String)object2);
                }
            }
            xmlSerializer.startTag(xmlElement.getNamespaceName(), xmlElement.getName());
            if (xmlElement.hasAttributes()) {
                object2 = xmlElement.attributes();
                while (object2.hasNext()) {
                    object = (XmlAttribute)object2.next();
                    if (object instanceof XmlSerializable) {
                        ((XmlSerializable)object).serialize(xmlSerializer);
                        continue;
                    }
                    xmlSerializer.attribute(object.getNamespaceName(), object.getName(), object.getValue());
                }
            }
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML start tag failed", iOException);
        }
    }

    @Override
    public void serializeEndTag(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        try {
            xmlSerializer.endTag(xmlElement.getNamespaceName(), xmlElement.getName());
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML end tag failed", iOException);
        }
    }

    private void serializeDocument(XmlDocument xmlDocument, XmlSerializer xmlSerializer) {
        try {
            xmlSerializer.startDocument(xmlDocument.getCharacterEncodingScheme(), xmlDocument.isStandalone());
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML document start failed", iOException);
        }
        if (xmlDocument.getDocumentElement() == null) {
            throw new XmlBuilderException("could not serialize document without root element " + xmlDocument + ": ");
        }
        this.serializeFragment(xmlDocument.getDocumentElement(), xmlSerializer);
        try {
            xmlSerializer.endDocument();
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML document end failed", iOException);
        }
    }

    private void serializeFragment(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        this.serializeStartTag(xmlElement, xmlSerializer);
        if (xmlElement.hasChildren()) {
            Iterator iterator = xmlElement.children();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof XmlSerializable) {
                    try {
                        ((XmlSerializable)e).serialize(xmlSerializer);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new XmlBuilderException("could not serialize item " + e + ": " + iOException, iOException);
                    }
                }
                if (e instanceof XmlElement) {
                    this.serializeFragment((XmlElement)e, xmlSerializer);
                    continue;
                }
                this.serializeItem(e, xmlSerializer);
            }
        }
        this.serializeEndTag(xmlElement, xmlSerializer);
    }
}

