/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class XMLIndexEngine
extends DataEngine {
    private Book _book;
    private static final String TAG_INDEX = "index";
    private static final String TAG_INDEXITEM = "indexitem";
    private static final String TAG_INDEXENTRY = "indexentry";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        Object dataObject = null;
        try {
            dataObject = this.createDataObject(view, basePath, r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataObject;
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        this._book = null;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree keyTree = new TopicTree(this._book, basePath);
        TopicTreeNode parent = keyTree.getRoot();
        Parser parser = ParserFactory.createParser(reader, basePath);
        XMLNode xmlRoot = parser.getRoot();
        this._handleIndex(view, xmlRoot.getFirstChild(), parent);
        return keyTree;
    }

    private void _handleIndex(View view, XMLNode xmlNode, TopicTreeNode node) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_INDEX)) {
            throw new XMLParseException("Toplevel tag is not Index: " + xmlNode.getTokenValue());
        }
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            this._handleIndexItem(view, xmlNode, node, false);
        }
    }

    private void _handleIndexItem(View view, XMLNode xmlNode, TopicTreeNode parent, boolean child) throws XMLParseException {
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_INDEXITEM)) {
            throw new XMLParseException("Tag is not Indexitem: " + xmlNode.getTokenValue());
        }
        String tokenId = xmlNode.getTokenProperty(PROP_ID);
        SimpleTopic topic = new SimpleTopic(xmlNode.getTokenProperty(PROP_TEXT));
        if (tokenId != null) {
            IndirectTarget target = new IndirectTarget(this._book, tokenId);
            topic.setTarget(target);
        }
        KeywordTopicTreeNode newNode = new KeywordTopicTreeNode(view, topic);
        parent.addChild(newNode);
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_INDEXITEM)) {
                this._handleIndexItem(view, xmlNode, newNode, true);
                continue;
            }
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_INDEXENTRY)) {
                this._handleIndexEntry(view, xmlNode, newNode);
                continue;
            }
            throw new XMLParseException("Unknown node in indexitem: " + xmlNode.getTokenValue());
        }
    }

    private void _handleIndexEntry(View view, XMLNode xmlNode, KeywordTopicTreeNode parent) throws XMLParseException {
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_INDEXENTRY)) {
            throw new XMLParseException("Tag is not Indexentry: " + xmlNode.getTokenValue());
        }
        String tokenId = xmlNode.getTokenProperty(PROP_ID);
        SimpleTopic topic = new SimpleTopic(xmlNode.getTokenProperty(PROP_TEXT));
        if (tokenId != null) {
            IndirectTarget target = new IndirectTarget(this._book, tokenId);
            topic.setTarget(target);
        }
        KeywordTopicTreeNode newNode = new KeywordTopicTreeNode(view, topic);
        parent.addEntry(newNode);
    }
}

