/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.IOException;
import java.net.URL;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.HHCEngine;

public class HHKEngine
extends HHCEngine {
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        return super.createDataObject(view, basePath, url, encoding);
    }

    @Override
    protected void readObject(View view, TopicTreeNode parent) throws IOException {
        String token;
        String paramName = null;
        String paramValue = null;
        SimpleTopic objectTopic = null;
        SimpleTopic currentKeywordEntry = null;
        KeywordTopicTreeNode node = null;
        while (!(token = this.readToken()).equals(">")) {
            if (!token.equals("type=") || (token = this.readToken()).equalsIgnoreCase("text/sitemap")) continue;
            return;
        }
        while (true) {
            if (!(token = this.readToken()).equals("<")) {
                continue;
            }
            token = this.readToken();
            if (token.equalsIgnoreCase("/object")) break;
            if (!token.equalsIgnoreCase("param")) continue;
            paramName = null;
            paramValue = null;
            token = this.readToken();
            while (!token.equals(">")) {
                if (token.equalsIgnoreCase("name=")) {
                    paramName = this.readToken();
                } else if (token.equalsIgnoreCase("value=")) {
                    paramValue = this.readToken();
                }
                token = this.readToken();
            }
            if (paramName == null || paramValue == null) continue;
            if (paramName.equalsIgnoreCase("name")) {
                if (objectTopic == null) {
                    objectTopic = new SimpleTopic(paramValue);
                    node = new KeywordTopicTreeNode(view, objectTopic);
                    continue;
                }
                currentKeywordEntry = new SimpleTopic(paramValue);
                node.addEntry(currentKeywordEntry);
                continue;
            }
            if (paramName.equalsIgnoreCase("local")) {
                SimpleURLTarget currentTarget = new SimpleURLTarget(this._view, paramValue);
                if (currentKeywordEntry != null) {
                    currentKeywordEntry.setTarget(currentTarget);
                    continue;
                }
                if (objectTopic == null) continue;
                objectTopic.setTarget(currentTarget);
                continue;
            }
            if (paramName.equalsIgnoreCase("keyword")) {
                currentKeywordEntry = new SimpleTopic(paramValue);
                node.addEntry(currentKeywordEntry);
                continue;
            }
            if (!paramName.equalsIgnoreCase("section title")) continue;
            currentKeywordEntry = new SimpleTopic(paramValue);
            node.addEntry(currentKeywordEntry);
        }
        if (node != null) {
            parent.addChild(node);
        }
    }
}

