/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;

public class Canonicalizer {
    @CodeSharingSafe(value="MutableStaticField")
    private static final char _sSeparator = System.getProperty("file.separator").charAt(0);
    private static final String _CONFIG_URL_REGEX = "\\{%.*\\}";
    private static final Logger _LOGGER = Logger.getLogger(Canonicalizer.class.getName(), "oracle.help.share.resource.LoggerBundle");

    private Canonicalizer() {
    }

    public static String fixPathname(String pathname) {
        char lastChar = pathname.charAt(pathname.length() - 1);
        if (lastChar == '/' || lastChar == _sSeparator) {
            return pathname;
        }
        pathname = pathname + _sSeparator;
        return pathname;
    }

    public static String fixSeparators(String url) {
        if (url != null) {
            int length = url.length();
            char[] chars = new char[length];
            url.getChars(0, length, chars, 0);
            for (int i = 0; i < length; ++i) {
                if (chars[i] != '\\') continue;
                chars[i] = 47;
            }
            return new String(chars);
        }
        return "";
    }

    public static String appendFileToPath(String abspath, String relpath) {
        char firstChar;
        char lastChar;
        String abs = Canonicalizer.fixSeparators(abspath);
        String rel = Canonicalizer.fixSeparators(relpath);
        if (abs.length() > 0 && (lastChar = abs.charAt(abs.length() - 1)) != '/') {
            abs = abs + '/';
        }
        if (rel.length() > 0 && (firstChar = rel.charAt(0)) == '/') {
            rel = rel.substring(1);
        }
        return abs + rel;
    }

    public static URL getAbsoluteURL(String baseURL, String urlName) throws MalformedURLException {
        URL url = null;
        if (urlName != null) {
            try {
                url = new URL(urlName);
            }
            catch (MalformedURLException e1) {
                if (baseURL != null) {
                    try {
                        url = new URL(Canonicalizer.appendFileToPath(baseURL, urlName));
                    }
                    catch (MalformedURLException e2) {
                        throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + e2.getMessage());
                    }
                }
                throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + e1.getMessage());
            }
        } else {
            throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve NULL URL ");
        }
        return url;
    }

    public static String resolveConfigURLLocation(String location) {
        String resolvedLocation = location;
        try {
            Pattern pattern = Pattern.compile(_CONFIG_URL_REGEX);
            Matcher matcher = pattern.matcher(location);
            while (matcher.find()) {
                String matchToken = matcher.group();
                String propertyValue = System.getProperty(matchToken = matchToken.substring(2, matchToken.length() - 1));
                if (propertyValue == null) continue;
                resolvedLocation = resolvedLocation.replaceFirst(_CONFIG_URL_REGEX, Matcher.quoteReplacement(propertyValue));
            }
            resolvedLocation = Canonicalizer.fixSeparators(resolvedLocation);
        }
        catch (Throwable t) {
            _LOGGER.log(Level.WARNING, "Unexpected exception encountered when processing file location", t);
            resolvedLocation = location;
        }
        return resolvedLocation;
    }
}

