/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.help.common.search.BooleanExpression;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public abstract class QueryHandler {
    public List executeQuery(String[] words, boolean allWords, boolean caseSensitive, Set selectedSources) throws SearchException {
        if (words != null && words.length > 0) {
            int operator = allWords ? 1 : 2;
            SearchExpression expression = new StringExpression(words[0], caseSensitive);
            for (int i = 1; i < words.length; ++i) {
                StringExpression part = new StringExpression(words[i], caseSensitive);
                expression = new BooleanExpression(expression, part, operator, caseSensitive);
            }
            return this.executeQuery(expression, selectedSources);
        }
        return Collections.EMPTY_LIST;
    }

    public abstract List executeQuery(SearchExpression var1, Set var2) throws SearchException;

    public abstract void stopSearch();

    public abstract boolean supportsCaseSensitiveSearches();

    public abstract Set getSupportedSources();
}

