/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.util.IndexedListListener;
import oracle.help.common.util.java.StaticLocaleContext;

public class KeywordModel {
    private ListenerManager _listenerManager = null;
    private Locale _locale;
    private ArrayList _keyViews = new ArrayList();
    private ArrayList _listItems = new ArrayList();
    private int _itemCount = 0;
    private Collator _localColl;
    private int _insertionCompareValue = -1;
    private boolean _leftToRight;
    private String _subItemSeparator;

    public KeywordModel(Locale loc, String wordSeperator) {
        this(null, loc, wordSeperator);
    }

    public KeywordModel(View[] initialViews, String wordSeperator) {
        this(initialViews, StaticLocaleContext.getLocale(), wordSeperator);
    }

    public KeywordModel(View[] initialViews, Locale loc, String wordSeperator) {
        this._locale = loc;
        this._localColl = Collator.getInstance(loc);
        this._subItemSeparator = wordSeperator;
        this._leftToRight = true;
        if (initialViews != null) {
            for (int iter = 0; iter < initialViews.length; ++iter) {
                if (this._keyViews.contains(initialViews[iter])) continue;
                this._keyViews.add(initialViews[iter]);
            }
        }
        if (this._keyViews.size() > 0) {
            View[] uniqueViews = new View[this._keyViews.size()];
            this._keyViews.toArray(uniqueViews);
            this._mergeKeywordIndices(uniqueViews, true);
        }
    }

    public void addIndexedListListener(IndexedListListener toAdd) {
        ListenerManager lManager = this.getListenerManager();
        lManager.addListener((EventListener)toAdd);
    }

    public void removeIndexedListListener(IndexedListListener toRemove) {
        ListenerManager lManager = this.getListenerManager();
        lManager.removeListener((EventListener)toRemove);
    }

    protected ListenerManager getListenerManager() {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        return this._listenerManager;
    }

    public void addView(View aView) {
        if (aView != null && !this._keyViews.contains(aView)) {
            this._keyViews.add(aView);
            View[] viewArr = new View[]{aView};
            this._mergeKeywordIndices(viewArr, true);
        }
    }

    public void removeView(View aView) {
        if (aView != null && this._keyViews.contains(aView)) {
            this._keyViews.remove(aView);
            View[] viewArr = new View[]{aView};
            this._mergeKeywordIndices(viewArr, false);
        }
    }

    public KeywordIndexItem getKeywordIndexItemForIndex(int index) {
        KeywordIndexItem resultItem = null;
        if (index < this._listItems.size()) {
            resultItem = (KeywordIndexItem)this._listItems.get(index);
        }
        return resultItem;
    }

    public String getSortingLabelForIndex(int index) {
        String resultLabel = null;
        if (index < this._listItems.size()) {
            KeywordIndexItem theInfo = (KeywordIndexItem)this._listItems.get(index);
            resultLabel = theInfo.sortingLabel;
        }
        return resultLabel;
    }

    private void _mergeKeywordIndices(View[] views, boolean add) {
        if (views != null) {
            for (int iter = 0; iter < views.length; ++iter) {
                if (add) {
                    this._addViewItems(views[iter]);
                    continue;
                }
                this._removeViewItems(views[iter]);
            }
        }
    }

    private void _addViewItems(View view) {
        if (view != null) {
            ArrayList items;
            TopicTree theTree = this._getTopicTree(view);
            if (theTree != null && (items = theTree.getRoot().getChildren()) != null) {
                for (int iter = 0; iter < items.size(); ++iter) {
                    this._addNodeItems((TopicTreeNode)items.get(iter), view, null);
                }
            }
            this._fireCurrentEvent();
        }
    }

    private void _removeViewItems(View view) {
        int iter = 0;
        if (view != null) {
            for (iter = this._listItems.size() - 1; iter >= 0; --iter) {
                KeywordIndexItem anInfo = (KeywordIndexItem)this._listItems.get(iter);
                anInfo.removeNode(view);
                if (anInfo.getNodeCount() != 0) continue;
                this._listItems.remove(iter);
                this._fireRemoveEvent(iter);
            }
            this._fireCurrentEvent();
        }
    }

    private void _addNodeItems(TopicTreeNode node, View view, String prefix) {
        this._fixNodeWithSeparators(node);
        Topic nodeTopic = node.getTopic();
        String displayLabel = nodeTopic.getLabel();
        boolean shouldIndent = false;
        String sortingLabel = displayLabel;
        if (prefix != null) {
            shouldIndent = true;
            sortingLabel = this._leftToRight ? prefix + this._subItemSeparator + " " + sortingLabel : sortingLabel + " " + this._subItemSeparator + prefix;
        }
        String convertedLabel = this._convertForCollate(sortingLabel);
        int insertPoint = this._findInsertionPoint(convertedLabel) + 1;
        if (this._insertionCompareValue == 0 && this._listItems.size() > 0) {
            KeywordIndexItem duplicateItem = (KeywordIndexItem)this._listItems.get(insertPoint - 1);
            duplicateItem.addNode(node);
        } else {
            KeywordIndexItem newListItem = new KeywordIndexItem(displayLabel, sortingLabel, convertedLabel, shouldIndent);
            newListItem.addNode(node);
            this._listItems.add(insertPoint, newListItem);
        }
        this._fireAddEvent(insertPoint);
        ArrayList children = node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (prefix == null) {
                    String newPrefix = sortingLabel;
                    this._addNodeItems((TopicTreeNode)children.get(i), view, newPrefix);
                    continue;
                }
                this._addNodeItems((TopicTreeNode)children.get(i), view, prefix);
            }
        }
    }

    private void _fixNodeWithSeparators(TopicTreeNode originalNode) {
        Topic originalTopic = originalNode.getTopic();
        Target originalTarget = originalTopic.getTarget();
        String displayLabel = originalTopic.getLabel();
        int sepIndex = displayLabel.indexOf(this._subItemSeparator);
        if (sepIndex != -1) {
            KeywordTopicTreeNode origKeyNode;
            ArrayList entries;
            String parentLabel = null;
            String childLabel = null;
            if (this._leftToRight) {
                parentLabel = displayLabel.substring(0, sepIndex);
                childLabel = displayLabel.substring(sepIndex + 1);
            } else {
                sepIndex = displayLabel.lastIndexOf(this._subItemSeparator);
                parentLabel = displayLabel.substring(sepIndex + 1);
                childLabel = displayLabel.substring(0, sepIndex);
            }
            SimpleTopic parentTopic = new SimpleTopic(parentLabel);
            SimpleTopic childTopic = new SimpleTopic(childLabel, originalTarget);
            originalNode.setTopic(parentTopic);
            KeywordTopicTreeNode childNode = new KeywordTopicTreeNode(originalNode.getView(), childTopic, originalNode);
            if (originalNode instanceof KeywordTopicTreeNode && (entries = (origKeyNode = (KeywordTopicTreeNode)originalNode).getEntries()) != null) {
                for (int iter = 0; iter < entries.size(); ++iter) {
                    childNode.addEntry((KeywordTopicTreeNode)entries.get(iter));
                }
                origKeyNode.removeAllEntries();
            }
            originalNode.addChild(childNode);
        }
    }

    public int findClosestKeywordIndexItem(String label) {
        if (this._listItems.size() == 0) {
            return -1;
        }
        String convertedLabel = this._convertForCollate(label);
        int closePoint = this._findInsertionPoint(convertedLabel);
        if (closePoint == -1) {
            closePoint = 0;
        } else {
            KeywordIndexItem anInfo = (KeywordIndexItem)this._listItems.get(closePoint);
            if (this._localColl.compare(anInfo.convertedLabel.toLowerCase(), convertedLabel.toLowerCase()) != 0 && closePoint + 1 < this._listItems.size()) {
                anInfo = (KeywordIndexItem)this._listItems.get(closePoint + 1);
                if (this._leftToRight) {
                    if (anInfo.sortingLabel.toLowerCase().startsWith(label.toLowerCase())) {
                        ++closePoint;
                    }
                } else if (anInfo.sortingLabel.toLowerCase().endsWith(label.toLowerCase())) {
                    ++closePoint;
                }
            }
        }
        return closePoint;
    }

    public List getIndexItems() {
        return this._listItems;
    }

    public List getIndexItems(int start, int blockSize) {
        KeywordIndexItem firstNode;
        List topics = this.getIndexItems();
        if (start > topics.size()) {
            start = 0;
        }
        int end = start + blockSize < topics.size() ? start + blockSize : topics.size();
        ArrayList<KeywordIndexItem> ret = new ArrayList<KeywordIndexItem>();
        Iterator returnNodes = topics.subList(start, end).iterator();
        int i = start;
        while (returnNodes.hasNext()) {
            KeywordIndexItem kli = (KeywordIndexItem)returnNodes.next();
            kli.setTopicId(i++);
            ret.add(kli);
        }
        if (start > 0 && (firstNode = (KeywordIndexItem)ret.get(0)).getIndent()) {
            int befLoc = start - 1;
            KeywordIndexItem priorNode = null;
            do {
                priorNode = this.getKeywordIndexItemForIndex(befLoc--);
            } while (befLoc > 0 && priorNode != null && priorNode.getIndent());
            if (priorNode != null) {
                ret.add(0, priorNode);
            }
        }
        return ret;
    }

    public List getIndexItems(int start, int blockSize, List topics) {
        if (start > topics.size()) {
            start = 0;
        }
        int end = start + blockSize < topics.size() ? start + blockSize : topics.size();
        return topics.subList(start, end);
    }

    public String getNodeTitle(int id) {
        KeywordIndexItem kli = this.getKeywordIndexItemForIndex(id);
        if (kli != null) {
            return kli.getText();
        }
        return null;
    }

    public List getEntries(int id) {
        KeywordIndexItem kli = this.getKeywordIndexItemForIndex(id);
        if (kli != null) {
            return kli.getEntries();
        }
        return null;
    }

    public int getSize() {
        return this._listItems.size();
    }

    private void _fireAddEvent(int location) {
        ListenerManager lManager = this.getListenerManager();
        Enumeration listeners = lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                IndexedListListener l = (IndexedListListener)listeners.nextElement();
                l.queueItemAdded(location);
            }
        }
    }

    private void _fireRemoveEvent(int location) {
        ListenerManager lManager = this.getListenerManager();
        Enumeration listeners = lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                IndexedListListener l = (IndexedListListener)listeners.nextElement();
                l.queueItemRemoved(location);
            }
        }
    }

    private void _fireCurrentEvent() {
        ListenerManager lManager = this.getListenerManager();
        Enumeration listeners = lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                IndexedListListener l = (IndexedListListener)listeners.nextElement();
                l.fireCurrentEvent();
            }
        }
    }

    private int _findInsertionPoint(String convertedLabel) {
        if (convertedLabel == null) {
            return -1;
        }
        int first = 0;
        int last = this._listItems.size() - 1;
        while (first <= last) {
            int middle = (first + last) / 2;
            KeywordIndexItem middleItem = (KeywordIndexItem)this._listItems.get(middle);
            this._insertionCompareValue = this._localColl.compare(convertedLabel, middleItem.convertedLabel);
            if (this._insertionCompareValue == 0) {
                return middle;
            }
            if (this._insertionCompareValue < 0) {
                last = middle - 1;
                continue;
            }
            first = middle + 1;
        }
        return last;
    }

    private String _convertForCollate(String aString) {
        int origLength = aString.length();
        char[] quoteSpace = new char[]{'\'', ' ', '\''};
        StringBuffer newString = new StringBuffer(origLength + 1);
        for (int iter = 0; iter < origLength; ++iter) {
            char aChar = aString.charAt(iter);
            if (Character.isWhitespace(aChar)) {
                quoteSpace[1] = aChar;
                newString.append(quoteSpace);
                continue;
            }
            newString.append(aChar);
        }
        if (this._leftToRight) {
            newString.append(this._subItemSeparator);
        } else {
            newString.insert(0, this._subItemSeparator);
        }
        return newString.toString();
    }

    private TopicTree _getTopicTree(View aView) {
        TopicTree theTree = null;
        if (aView != null) {
            try {
                theTree = (TopicTree)aView.getViewData();
            }
            catch (Exception e) {
                System.err.println("View passed to KeywordModel does not contain data in TopicTree format.");
                e.printStackTrace();
                theTree = null;
            }
        }
        return theTree;
    }
}

