/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.NullArgumentException;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;

public class ProfileModel
extends AbstractListModel
implements ComboBoxModel {
    private List profiles;
    private CodingStyleProfile selection;
    private Comparator comparator = new ProfileComparator();
    private Comparator nameComparator = new ProfileNameComparator();
    private final ProfileRepository repository = ProfileRepository.getProfileRepository();

    public ProfileModel() {
        this.profiles = new ArrayList();
        List<CodingStyleProfile> list = this.repository.getProfiles();
        for (CodingStyleProfile profile : list) {
            if (profile.getName() == null) continue;
            CodingStyleProfile copy = new CodingStyleProfile();
            profile.copyTo((Object)copy);
            this.profiles.add(copy);
        }
        Collections.sort(this.profiles, this.comparator);
    }

    public ProfileModel(PropertyStorage prefs) {
    }

    @Override
    public int getSize() {
        return this.profiles.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selection;
    }

    @Override
    public Object getElementAt(int index) {
        return this.profiles.get(index);
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null");
        }
        return Collections.binarySearch(this.profiles, name, this.nameComparator) >= 0;
    }

    public CodingStyleProfile getProfile(String name) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null");
        }
        int index = Collections.binarySearch(this.profiles, name, this.nameComparator);
        return index >= 0 ? (CodingStyleProfile)((Object)this.profiles.get(index)) : null;
    }

    public void add(CodingStyleProfile profile) {
        if (profile.getName() == null) {
            throw new IllegalArgumentException("Profile must have a name");
        }
        int index = Collections.binarySearch(this.profiles, profile, this.comparator);
        if (index < 0) {
            index = -index - 1;
            this.profiles.add(index, profile);
            this.fireIntervalAdded(this, index, index);
        } else {
            this.profiles.set(index, profile);
            profile.setDirty(true);
            this.fireContentsChanged(this, index, index);
        }
    }

    public void remove(CodingStyleProfile profile) {
        if (profile.getName() == null) {
            return;
        }
        int index = Collections.binarySearch(this.profiles, profile, this.comparator);
        if (index >= 0) {
            if (this.selection.equals((Object)profile)) {
                this.setSelectedItem(index > 0 ? this.profiles.get(index - 1) : this.profiles.get(1));
            }
            this.profiles.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public boolean isDefaultProfile(CodingStyleProfile profile) {
        return this.repository.getDefaultProfile(profile.getName()) != null;
    }

    public boolean canRestore(CodingStyleProfile profile) {
        CodingStyleProfile defaultProfile = this.repository.getDefaultProfile(profile.getName());
        if (defaultProfile != null) {
            return ModelUtil.areDifferent((Object)((Object)defaultProfile), (Object)((Object)profile));
        }
        return false;
    }

    public void restore(CodingStyleProfile profile) {
        assert (this.isDefaultProfile(profile));
        String name = profile.getName();
        if (name == null) {
            throw new IllegalArgumentException("Profile must have a name");
        }
        CodingStyleProfile defaultProfile = this.repository.getDefaultProfile(name);
        defaultProfile.copyTo((Object)profile);
        profile.setModified(false);
        profile.setDirty(true);
        int index = Collections.binarySearch(this.profiles, name, this.nameComparator);
        this.fireContentsChanged(this, index, index);
    }

    public CodingStyleProfile copy(CodingStyleProfile profile, String name) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null");
        }
        CodingStyleProfile copy = new CodingStyleProfile();
        profile.copyTo((Object)copy);
        copy.setName(name);
        int index = Collections.binarySearch(this.profiles, name, this.nameComparator);
        if (index < 0) {
            index = -index - 1;
            this.profiles.add(index, copy);
            this.fireIntervalAdded(this, index, index);
        } else {
            CodingStyleProfile oldProfile = (CodingStyleProfile)((Object)this.profiles.get(index));
            this.profiles.set(index, copy);
            if (!name.equals(oldProfile.getName())) {
                this.repository.removeProfile(oldProfile);
            }
            this.fireContentsChanged(this, index, index);
        }
        this.save(copy);
        return copy;
    }

    public void save() {
        HashSet<String> marked = new HashSet<String>();
        for (CodingStyleProfile profile : this.profiles) {
            marked.add(profile.getName());
            if (this.repository.contains(profile.getName()) && !profile.isDirty()) continue;
            this.save(profile);
        }
        for (CodingStyleProfile profile : this.repository.getProfiles()) {
            if (marked.contains(profile.getName())) continue;
            this.repository.removeProfile(profile);
        }
    }

    public void revert() {
        HashSet marked = new HashSet();
        ArrayList<CodingStyleProfile> toRemove = new ArrayList<CodingStyleProfile>();
        for (CodingStyleProfile profile : this.profiles) {
            if (!this.repository.contains(profile.getName())) {
                toRemove.add(profile);
                continue;
            }
            if (!profile.isDirty()) continue;
            this.revert(profile);
        }
        for (CodingStyleProfile profile : toRemove) {
            this.remove(profile);
        }
        for (CodingStyleProfile profile : this.repository.getProfiles()) {
            if (marked.contains(profile.getName())) continue;
            this.add(profile);
        }
    }

    public void setModified(CodingStyleProfile profile) {
        int index = this.profiles.indexOf((Object)profile);
        if (index >= 0) {
            profile.setModified(true);
            profile.setDirty(true);
            this.fireContentsChanged(this, index, index);
        }
    }

    public void save(CodingStyleProfile profile) {
        CodingStyleProfile copy = new CodingStyleProfile();
        profile.copyTo((Object)copy);
        this.repository.addProfile(copy);
    }

    public void revert(CodingStyleProfile profile) {
        String name = profile.getName();
        if (name == null) {
            throw new IllegalArgumentException("Profile must have a name");
        }
        CodingStyleProfile original = this.repository.getProfile(name);
        if (original != null) {
            original.copyTo((Object)profile);
            profile.setModified(false);
            profile.setDirty(false);
            int index = Collections.binarySearch(this.profiles, profile.getName(), this.nameComparator);
            this.fireContentsChanged(this, index, index);
        }
    }

    public CodingStyleProfile getDefaultProfile() {
        String name = this.repository.getDefaultProfile().getName();
        return this.getProfile(name);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!(anItem == null && this.getSize() != 0 || this.selection != null && this.selection.equals(anItem))) {
            CodingStyleProfile profile = (CodingStyleProfile)((Object)anItem);
            if (profile != null && !this.contains(profile.getName())) {
                this.add(profile);
            }
            this.selection = profile;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class ProfileNameComparator
    implements Comparator {
        private ProfileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = o1 instanceof CodingStyleProfile ? ((CodingStyleProfile)((Object)o1)).getName() : (String)o1;
            String name2 = o2 instanceof CodingStyleProfile ? ((CodingStyleProfile)((Object)o2)).getName() : (String)o2;
            if (name1 == null && name2 != null) {
                return 1;
            }
            if (name2 == null && name1 != null) {
                return -1;
            }
            if (name1 == null && name2 == null) {
                return 0;
            }
            return name1.compareToIgnoreCase(name2);
        }
    }

    private class ProfileComparator
    implements Comparator {
        private ProfileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((CodingStyleProfile)((Object)o1)).getName();
            String name2 = ((CodingStyleProfile)((Object)o2)).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

