/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.style.profile.CodingStyleProfile;

public final class CodingStyleProfiles
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "CodingStyleProfiles";

    public CodingStyleProfiles() {
        this(HashStructure.newInstance());
    }

    private CodingStyleProfiles(HashStructure hash) {
        super(hash);
    }

    public static CodingStyleProfiles getInstance(PropertyStorage prefs) {
        return new CodingStyleProfiles(CodingStyleProfiles.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public final CodingStyleProfile getProfile(String name) {
        return new CodingStyleProfile(this._hash.getOrCreateHashStructure(name));
    }

    public void putProfile(String name, CodingStyleProfile profile) {
        HashStructure hash = this._hash.getOrCreateHashStructure(name);
        CodingStyleProfile targetProfile = new CodingStyleProfile(hash);
        profile.copyTo((Object)targetProfile);
    }

    public void removeProfile(String name) {
        this._hash.remove(name);
    }

    public Map<String, CodingStyleProfile> getProfileMap() {
        HashMap<String, CodingStyleProfile> map = new HashMap<String, CodingStyleProfile>();
        Iterator keyIter = this._hash.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = keyIter.next().toString();
            HashStructure hash = this._hash.getHashStructure(key);
            CodingStyleProfile profile = new CodingStyleProfile(hash);
            if (profile.getName() == null) {
                profile.setName(key);
            }
            map.put(key, profile);
        }
        return map;
    }

    public void setProfileMap(Map<String, CodingStyleProfile> profileMap) {
        if (profileMap != null) {
            for (String keyObj : profileMap.keySet()) {
                if (keyObj == null) continue;
                String key = keyObj.toString();
                CodingStyleProfile profile = profileMap.get(key);
                HashStructure targetHash = this._hash.getOrCreateHashStructure(key);
                CodingStyleProfile targetProfile = new CodingStyleProfile(targetHash);
                profile.copyTo((Object)targetProfile);
            }
            ArrayList<String> deletedKeys = new ArrayList<String>();
            for (String key : this._hash.keySet()) {
                if (profileMap.containsKey(key)) continue;
                deletedKeys.add(key);
            }
            for (String deletedKey : deletedKeys) {
                this._hash.remove(deletedKey);
            }
        }
    }
}

