/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;

public class CodingStyleProfile
extends HashStructureAdapter
implements CodingStyleOptions,
Copyable,
JavaPreferences {
    public static final String DATA_KEY = "Profile";
    private static final String NAME = "profile.name";
    private static final String FIELD_PREFIX = "field.prefix";
    private static final String FIELD_SUFFIX = "field.suffix";
    private static final String STATIC_FIELD_PREFIX = "static.field.prefix";
    private static final String STATIC_FIELD_SUFFIX = "static.field.suffix";
    private static final String PARAMETER_PREFIX = "parameter.prefix";
    private static final String PARAMETER_SUFFIX = "parameter.suffix";
    private static final String LOCAL_VARIABLE_PREFIX = "local.variable.prefix";
    private static final String LOCAL_VARIABLE_SUFFIX = "local.variable.suffix";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"coding-style-profile");
    private static final String ROOT_TAG = "profile";
    private SourcePreferences preferences;
    private boolean modified;
    private boolean disableEvents;
    private final CopyOnWriteArrayList<CodingStyleOptionsListener> listeners = new CopyOnWriteArrayList();
    public static final String PROPERTY_INDENT_SIZE = "indentSize";
    public static final String PROPERTY_INDENT_REPLACE_WITH_TABS = "indentReplaceWithTabs";
    public static final String PROPERTY_INDENT_TAB_SIZE = "tabSize";
    public static final String PROPERTY_INDENT_CLASS_MEMBERS = "indentClassMembers";
    public static final String PROPERTY_INDENT_CONTROL_BLOCKS = "indentControlBlocks";
    public static final String PROPERTY_INDENT_BLOCK_CHILDREN = "indentBlockChildren";
    public static final String PROPERTY_INDENT_SWITCH_CASES = "indentSwitchCases";
    public static final String PROPERTY_INDENT_TRAILING_COMMENTS = "indentTrailingComments";
    public static final String PROPERTY_BLANKLINES_PRESERVED = "blanklinesPreserved";
    public static final String PROPERTY_BLANKLINES_AFTER_PACKAGE = "blanklinesAfterPackage";
    public static final String PROPERTY_BLANKLINES_AFTER_IMPORTS = "blanklinesAfterImports";
    public static final String PROPERTY_BLANKLINES_BEFORE_DOC_COMMENT = "blanklinesBeforeDocComment";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_CLASS = "blanklinesBeforeFirstClass";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_MEMBER = "blanklinesBeforeFirstMember";
    public static final String PROPERTY_BLANKLINES_AFTER_LAST_MEMBER = "blanklinesAfterLastMember";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIELD = "blanklinesBeforeField";
    public static final String PROPERTY_BLANKLINES_BEFORE_METHOD = "blanklinesBeforeMethod";
    public static final String PROPERTY_BLANKLINES_BEFORE_MEMBER_CLASS = "blanklinesBeforeMemberClass";
    public static final String PROPERTY_BLANKLINES_BEFORE_MODULE_REQUIRES = "blanklinesBeforeModuleRequires";
    public static final String PROPERTY_BLANKLINES_BEFORE_MODULE_EXPORTS = "blanklinesBeforeModuleExports";
    public static final String PROPERTY_BLANKLINES_BEFORE_MODULE_USES = "blanklinesBeforeModuleUses";
    public static final String PROPERTY_BLANKLINES_BEFORE_MODULE_PROVIDES = "blanklinesBeforeModuleProvides";
    public static final String PROPERTY_BLANKLINES_BEFORE_MODULE_OPENS = "blanklinesBeforeModuleOpens";
    public static final String PROPERTY_BLANKLINES_EMPTY_CLASS = "blanklinesEmptyClass";
    public static final String PROPERTY_BLANKLINES_EMPTY_ANONYMOUS = "blanklinesEmptyAnonymous";
    public static final String PROPERTY_BLANKLINES_EMPTY_METHOD = "blanklinesEmptyMethod";
    public static final String PROPERTY_BLANKLINES_EMPTY_BLOCK = "blanklinesEmptyBlock";
    public static final String PROPERTY_BRACE_POSITION_CLASS = "classBracePosition";
    public static final String PROPERTY_BRACE_POSITION_METHOD = "methodBracePosition";
    public static final String PROPERTY_BRACE_POSITION_BLOCK = "blockBracePosition";
    public static final String PROPERTY_BRACE_POSITION_ARRAY = "arrayBracePosition";
    public static final String PROPERTY_BRACE_POSITION_SWITCH_CASE = "switchCaseBracePosition";
    public static final String PROPERTY_BRACE_POSITION_SWITCH = "switchBracePosition";
    public static final String PROPERTY_BRACE_POSITION_FOR = "forBracePosition";
    public static final String PROPERTY_BRACE_POSITION_IF = "ifBracePosition";
    public static final String PROPERTY_BRACE_POSITION_ELSE = "elseBracePosition";
    public static final String PROPERTY_BRACE_POSITION_SYNCHRONIZED = "synchronizedBracePosition";
    public static final String PROPERTY_BRACE_POSITION_TRY = "tryBracePosition";
    public static final String PROPERTY_BRACE_POSITION_CATCH = "catchBracePosition";
    public static final String PROPERTY_BRACE_POSITION_WHILE = "whileBracePosition";
    public static final String PROPERTY_BRACE_POSITION_DO = "doBracePosition";
    public static final String PROPERTY_BRACE_POSITION_FINALLY = "finallyBracePosition";
    public static final String PROPERTY_BRACE_POSITION_ANONYMOUS_CLASS = "anonymousClassBracePosition";
    public static final String PROPERTY_NEWLINE_AFTER_SWITCH_CASE = "newlineAfterSwitchCase";
    public static final String PROPERTY_BRACE_POSITION_STATIC_INITIALIZER = "staticInitializerBracePosition";
    public static final String PROPERTY_NEWLINE_EXTENDS = "newlineExtends";
    public static final String PROPERTY_NEWLINE_IMPLEMENTS = "newlineImplements";
    public static final String PROPERTY_NEWLINE_THROWS = "newlineThrows";
    public static final String PROPERTY_NEWLINE_ELSE = "newlineElse";
    public static final String PROPERTY_NEWLINE_WHILE = "newlineWhile";
    public static final String PROPERTY_NEWLINE_CATCH = "newlineCatch";
    public static final String PROPERTY_NEWLINE_FINALLY = "newlineFinally";
    public static final String PROPERTY_SPACE_BEFORE_COMMA = "spaceBeforeComma";
    public static final String PROPERTY_SPACE_AFTER_COMMA = "spaceAfterComma";
    public static final String PROPERTY_SPACE_BEFORE_SEMICOLON = "spaceBeforeSemicolon";
    public static final String PROPERTY_SPACE_AFTER_SEMICOLON = "spaceAfterSemicolon";
    public static final String PROPERTY_SPACE_BEFORE_QUESTION = "spaceBeforeQuestion";
    public static final String PROPERTY_SPACE_AFTER_QUESTION = "spaceAfterQuestion";
    public static final String PROPERTY_SPACE_BEFORE_COLON = "spaceBeforeColon";
    public static final String PROPERTY_SPACE_AFTER_COLON = "spaceAfterColon";
    public static final String PROPERTY_SPACE_AFTER_TYPECAST = "spaceAfterTypecast";
    public static final String PROPERTY_SPACE_BEFORE_ARGUMENTS = "spaceBeforeArguments";
    public static final String PROPERTY_SPACE_BEFORE_PARAMETERS = "spaceBeforeParameters";
    public static final String PROPERTY_SPACE_AFTER_KEYWORD = "spaceAfterKeyword";
    public static final String PROPERTY_SPACE_AROUND_ASSIGNMENT = "spaceAroundAssignment";
    public static final String PROPERTY_SPACE_AROUND_BINARY_OPERATOR = "spaceAroundBinaryOperator";
    public static final String PROPERTY_SPACE_WITHIN_PARENTHESIS = "spaceWithinParenthesis";
    public static final String PROPERTY_SPACE_WITHIN_BRACKETS = "spaceWithinBrackets";
    public static final String PROPERTY_SPACE_BEFORE_OPEN_BRACE = "spaceBeforeOpenBrace";
    public static final String PROPERTY_SPACE_AROUND_LAMBDA_OPERATOR = "spaceAroundLambdaOperator";
    public static final String PROPERTY_WRAP_LINE_WIDTH = "wrapLineWidth";
    public static final String PROPERTY_WRAP_ALIGN = "wrapAlign";
    public static final String PROPERTY_WRAP_MODIFIERS = "wrapModifiers";
    public static final String PROPERTY_WRAP_EXTENDS = "wrapExtends";
    public static final String PROPERTY_WRAP_THROWS = "wrapThrows";
    public static final String PROPERTY_WRAP_PARAMETER_LIST = "wrapParameterList";
    public static final String PROPERTY_WRAP_DOT_CHAIN = "wrapDotChain";
    public static final String PROPERTY_WRAP_DOT_CHAIN_BEFORE_DOT = "wrapDotChainBeforeDot";
    public static final String PROPERTY_WRAP_FOR_STATEMENT = "wrapForStatement";
    public static final String PROPERTY_WRAP_BINARY_OPERATOR = "wrapBinaryOperator";
    public static final String PROPERTY_WRAP_TERNARY_EXPRESSION = "wrapTernaryExpression";
    public static final String PROPERTY_WRAP_ARRAY_CONSTANT = "wrapArrayConstant";
    public static final String PROPERTY_WRAP_INVOKE_ARGUMENTS = "wrapInvokeArguments";
    public static final String PROPERTY_WRAP_ANONYMOUS_CLASS_ASSIGNMENTS = "wrapAnonymousClassAssignments";
    @Deprecated
    public static final String PROPERTY_WRAP_CLASS_ANNOTATIONS = "wrapClassAnnotations";
    @Deprecated
    public static final String PROPERTY_WRAP_METHOD_ANNOTATIONS = "wrapMethodAnnotations";
    @Deprecated
    public static final String PROPERTY_WRAP_FIELD_ANNOTATIONS = "wrapFieldAnnotations";
    public static final String PROPERTY_WRAP_PARAMETER_ANNOTATIONS = "wrapParameterAnnotations";
    @Deprecated
    public static final String PROPERTY_WRAP_LOCAL_VARIABLE_ANNOTATIONS = "wrapLocalVariableAnnotations";
    public static final String PROPERTY_WRAP_ANNOTATIONS = "wrapAnnotations";
    public static final String PROPERTY_WRAP_MARKER_ANNOTATIONS = "wrapMarkerAnnotations";
    public static final String PROPERTY_WRAP_TYPE_ANNOTATIONS = "wrapTypeAnnotations";
    public static final String PROPERTY_WRAP_BEFORE_OPERATORS = "wrapBeforeOperators";
    public static final String PROPERTY_WRAP_BEFORE_TERNARY_OPERATORS = "wrapBeforeTernaryOperators";
    public static final String PROPERTY_WRAP_IMPLEMENTS = "wrapImplements";
    public static final String PROPERTY_WRAP_ASSERT_OPERATORS = "wrapAssertOperators";
    public static final String PROPERTY_WRAP_STRING_EOL_CONCATENATIONS = "wrapStringEolConcatenations";
    public static final String PROPERTY_GROUP_IMPORTS = "groupImports";
    public static final String PROPERTY_GROUP_PACKAGE_DEPTH = "groupPackageDepth";
    public static final String PROPERTY_IMPORT_INNER_CLASSES = "importInnerClasses";
    public static final String PROPERTY_USE_WIDE_IMPORTS = "useWideImports";
    public static final String PROPERTY_WIDE_IMPORT_THRESHOLD = "wideImportThreshold";
    public static final String IMPORT_NARROW_THRESHOLD_PREVIOUS = "import.narrow_threshold.previous";
    public static final String PROPERTY_USE_WIDE_MEMBER_IMPORTS = "useWideMemberImports";
    public static final String IMPORT_NARROW_THRESHOLD_MEMBER_PREVIOUS = "import.narrow_member_threshold.previous";
    public static final String PROPERTY_CUDDLE_EMPTY_BRACES = "cuddleEmptyBraces";
    public static final String PROPERTY_ALIGN_ANONYMOUS_CLASSES = "alignAnonymousClasses";
    public static final String PROPERTY_ALIGN_VARIABLE_NAMES = "alignVariableNames";
    public static final String PROPERTY_ALIGN_ARRAY_INITIALIZERS = "alignArrayInitializers";
    public static final String PROPERTY_FIELD_PREFIX = "fieldPrefix";
    public static final String PROPERTY_FIELD_SUFFIX = "fieldSuffix";
    public static final String PROPERTY_STATIC_FIELD_PREFIX = "staticFieldPrefix";
    public static final String PROPERTY_STATIC_FIELD_SUFFIX = "staticFieldSuffix";
    public static final String PROPERTY_PARAMETER_PREFIX = "parameterPrefix";
    public static final String PROPERTY_PARAMETER_SUFFIX = "parameterSuffix";
    public static final String PROPERTY_LOCAL_VARIABLE_PREFIX = "localVariablePrefix";
    public static final String PROPERTY_LOCAL_VARIABLE_SUFFIX = "localVariableSuffix";
    public static final String PROPERTY_ALIGN_LAMBDA_BODIES = "alignLambdaBodies";

    public CodingStyleProfile() {
        this(HashStructure.newInstance());
    }

    CodingStyleProfile(HashStructure hash) {
        super(hash);
        this.preferences = new SourcePreferences(hash);
        hash.addStructureChangeListener((StructureChangeListener)new ChangeListener());
    }

    public void addCodingStyleOptionsListener(CodingStyleOptionsListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeCodingStyleOptionsListener(CodingStyleOptionsListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void exportTo(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        io.save(url, (Object)this._hash);
    }

    public static CodingStyleProfile importFrom(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleProfile((HashStructure)io.load(url));
    }

    public static CodingStyleProfile importFrom(Reader reader) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleProfile(io.read(reader, null));
    }

    public boolean isModified() throws TransientMarker {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isDirty() throws TransientMarker {
        return this._hash.isDirty();
    }

    public void setDirty(boolean dirty) {
        this._hash.markDirty(dirty);
    }

    public SourcePreferences getSourcePreferences() {
        return this.preferences;
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String name) {
        this._hash.putString(NAME, name, true);
    }

    public int getIndentSize() {
        return this.preferences.getInt(0);
    }

    public void setIndentSize(int indentSize) {
        this.preferences.setInt(0, indentSize);
    }

    public boolean getIndentReplaceWithTabs() {
        return this.preferences.getBoolean(1);
    }

    public void setIndentReplaceWithTabs(boolean indentReplaceWithTabs) {
        this.preferences.setBoolean(1, indentReplaceWithTabs);
    }

    public int getTabSize() {
        return this.preferences.getInt(2);
    }

    public void setTabSize(int tabSize) {
        this.preferences.setInt(2, tabSize);
    }

    public boolean getIndentClassMembers() {
        return this.preferences.getBoolean(3);
    }

    public void setIndentClassMembers(boolean indentClassMembers) {
        this.preferences.setBoolean(3, indentClassMembers);
    }

    public boolean getIndentControlBlocks() {
        return this.preferences.getBoolean(6);
    }

    public void setIndentControlBlocks(boolean indentControlBlocks) {
        this.preferences.setBoolean(6, indentControlBlocks);
    }

    public boolean getIndentBlockChildren() {
        return this.preferences.getBoolean(5);
    }

    public void setIndentBlockChildren(boolean indentBlockChildren) {
        this.preferences.setBoolean(5, indentBlockChildren);
    }

    public boolean getIndentSwitchCases() {
        return this.preferences.getBoolean(7);
    }

    public void setIndentSwitchCases(boolean indentSwitchCases) {
        this.preferences.setBoolean(7, indentSwitchCases);
    }

    public int getIndentTrailingComments() {
        return this.preferences.getInt(8);
    }

    public void setIndentTrailingComments(int indentTrailingComments) {
        this.preferences.setInt(8, indentTrailingComments);
    }

    public int getBlanklinesPreserved() {
        return this.preferences.getInt(9);
    }

    public void setBlanklinesPreserved(int blanklinesPreserved) {
        this.preferences.setInt(9, blanklinesPreserved);
    }

    public int getBlanklinesAfterPackage() {
        return this.preferences.getInt(10);
    }

    public void setBlanklinesAfterPackage(int blanklinesAfterPackage) {
        this.preferences.setInt(10, blanklinesAfterPackage);
    }

    public int getBlanklinesAfterImports() {
        return this.preferences.getInt(11);
    }

    public void setBlanklinesAfterImports(int blanklinesAfterImports) {
        this.preferences.setInt(11, blanklinesAfterImports);
    }

    public int getBlanklinesBeforeDocComment() {
        return this.preferences.getInt(17);
    }

    public void setBlanklinesBeforeDocComment(int blanklinesBeforeDocComment) {
        this.preferences.setInt(17, blanklinesBeforeDocComment);
    }

    public int getBlanklinesBeforeFirstClass() {
        return this.preferences.getInt(12);
    }

    public void setBlanklinesBeforeFirstClass(int blanklinesBeforeFirstClass) {
        this.preferences.setInt(12, blanklinesBeforeFirstClass);
    }

    public int getBlanklinesBeforeFirstMember() {
        return this.preferences.getInt(13);
    }

    public void setBlanklinesBeforeFirstMember(int blanklinesBeforeFirstMember) {
        this.preferences.setInt(13, blanklinesBeforeFirstMember);
    }

    public int getBlanklinesAfterLastMember() {
        return this.preferences.getInt(15);
    }

    public void setBlanklinesAfterLastMember(int blanklinesAfterLastMember) {
        this.preferences.setInt(15, blanklinesAfterLastMember);
    }

    public int getBlanklinesBeforeField() {
        return this.preferences.getInt(18);
    }

    public void setBlanklinesBeforeField(int blanklinesBeforeField) {
        this.preferences.setInt(18, blanklinesBeforeField);
    }

    public int getBlanklinesBeforeMethod() {
        return this.preferences.getInt(19);
    }

    public void setBlanklinesBeforeMethod(int blanklinesBeforeMethod) {
        this.preferences.setInt(19, blanklinesBeforeMethod);
    }

    public int getBlanklinesBeforeMemberClass() {
        return this.preferences.getInt(20);
    }

    public void setBlanklinesBeforeMemberClass(int blanklinesBeforeMemberClass) {
        this.preferences.setInt(20, blanklinesBeforeMemberClass);
    }

    public int getBlanklinesBeforeModuleRequires() {
        return this.preferences.getInt(21);
    }

    public void setBlanklinesBeforeModuleRequires(int blanklinesBeforeModuleRequires) {
        this.preferences.setInt(21, blanklinesBeforeModuleRequires);
    }

    public int getBlanklinesBeforeModuleExports() {
        return this.preferences.getInt(22);
    }

    public void setBlanklinesBeforeModuleExports(int blanklinesBeforeModuleExports) {
        this.preferences.setInt(22, blanklinesBeforeModuleExports);
    }

    public int getBlanklinesBeforeModuleUses() {
        return this.preferences.getInt(23);
    }

    public void setBlanklinesBeforeModuleUses(int blanklinesBeforeModuleUses) {
        this.preferences.setInt(23, blanklinesBeforeModuleUses);
    }

    public int getBlanklinesBeforeModuleProvides() {
        return this.preferences.getInt(24);
    }

    public void setBlanklinesBeforeModuleProvides(int blanklinesBeforeModuleProvides) {
        this.preferences.setInt(24, blanklinesBeforeModuleProvides);
    }

    public int getBlanklinesBeforeModuleOpens() {
        return this.preferences.getInt(25);
    }

    public void setBlanklinesBeforeModuleOpens(int blanklinesBeforeModuleOpens) {
        this.preferences.setInt(25, blanklinesBeforeModuleOpens);
    }

    public int getBlanklinesEmptyClass() {
        return this.preferences.getInt(26);
    }

    public void setBlanklinesEmptyClass(int blanklinesEmptyClass) {
        this.preferences.setInt(26, blanklinesEmptyClass);
    }

    public int getBlanklinesEmptyAnonymous() {
        return this.preferences.getInt(28);
    }

    public void setBlanklinesEmptyAnonymous(int blanklinesEmptyAnonymous) {
        this.preferences.setInt(28, blanklinesEmptyAnonymous);
    }

    public int getBlanklinesEmptyMethod() {
        return this.preferences.getInt(29);
    }

    public void setBlanklinesEmptyMethod(int blanklinesEmptyMethod) {
        this.preferences.setInt(29, blanklinesEmptyMethod);
    }

    public int getBlanklinesEmptyBlock() {
        return this.preferences.getInt(30);
    }

    public void setBlanklinesEmptyBlock(int blanklinesEmptyBlock) {
        this.preferences.setInt(30, blanklinesEmptyBlock);
    }

    public int getClassBracePosition() {
        return this.preferences.getBoolean(31) ? 1 : 0;
    }

    public void setClassBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(31, !sameLine);
    }

    public int getMethodBracePosition() {
        return this.preferences.getBoolean(33) ? 1 : 0;
    }

    public void setMethodBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(33, !sameLine);
    }

    public int getBlockBracePosition() {
        return this.preferences.getBoolean(34) ? 1 : 0;
    }

    public void setBlockBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(34, !sameLine);
    }

    public int getArrayBracePosition() {
        return this.preferences.getBoolean(35) ? 1 : 0;
    }

    public void setArrayBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(35, !sameLine);
    }

    public int getSwitchCaseBracePosition() {
        return this.preferences.getBoolean(55) ? 1 : 0;
    }

    public void setSwitchCaseBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(55, !sameLine);
    }

    public int getSwitchBracePosition() {
        return this.preferences.getBoolean(44) ? 1 : 0;
    }

    public void setSwitchBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(44, !sameLine);
    }

    public int getForBracePosition() {
        return this.preferences.getBoolean(45) ? 1 : 0;
    }

    public void setForBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(45, !sameLine);
    }

    public int getIfBracePosition() {
        return this.preferences.getBoolean(46) ? 1 : 0;
    }

    public void setIfBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(46, !sameLine);
    }

    public int getElseBracePosition() {
        return this.preferences.getBoolean(47) ? 1 : 0;
    }

    public void setElseBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(47, !sameLine);
    }

    public int getSynchronizedBracePosition() {
        return this.preferences.getBoolean(48) ? 1 : 0;
    }

    public void setSynchronizedBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(48, !sameLine);
    }

    public int getTryBracePosition() {
        return this.preferences.getBoolean(49) ? 1 : 0;
    }

    public void setTryBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(49, !sameLine);
    }

    public int getCatchBracePosition() {
        return this.preferences.getBoolean(50) ? 1 : 0;
    }

    public void setCatchBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(50, !sameLine);
    }

    public int getWhileBracePosition() {
        return this.preferences.getBoolean(52) ? 1 : 0;
    }

    public void setWhileBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(52, !sameLine);
    }

    public int getDoBracePosition() {
        return this.preferences.getBoolean(51) ? 1 : 0;
    }

    public void setDoBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(51, !sameLine);
    }

    public int getFinallyBracePosition() {
        return this.preferences.getBoolean(53) ? 1 : 0;
    }

    public void setFinallyBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(53, !sameLine);
    }

    public int getAnonymousClassBracePosition() {
        return this.preferences.getBoolean(54) ? 1 : 0;
    }

    public void setAnonymousClassBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(54, !sameLine);
    }

    public boolean getNewlineAfterSwitchCase() {
        return this.preferences.getBoolean(36);
    }

    public void setNewlineAfterSwitchCase(boolean newlineAfterSwitchCase) {
        this.preferences.setBoolean(36, newlineAfterSwitchCase);
    }

    public int getStaticInitializerBracePosition() {
        return this.preferences.getBoolean(56) ? 1 : 0;
    }

    public void setStaticInitializerBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(56, !sameLine);
    }

    public boolean getNewlineExtends() {
        return this.preferences.getBoolean(37);
    }

    public void setNewlineExtends(boolean newlineExtends) {
        this.preferences.setBoolean(37, newlineExtends);
    }

    public boolean getNewlineImplements() {
        return this.preferences.getBoolean(38);
    }

    public void setNewlineImplements(boolean newlineImplements) {
        this.preferences.setBoolean(38, newlineImplements);
    }

    public boolean getNewlineThrows() {
        return this.preferences.getBoolean(39);
    }

    public void setNewlineThrows(boolean newlineThrows) {
        this.preferences.setBoolean(39, newlineThrows);
    }

    public boolean getNewlineElse() {
        return this.preferences.getBoolean(40);
    }

    public void setNewlineElse(boolean newlineElse) {
        this.preferences.setBoolean(40, newlineElse);
    }

    public boolean getNewlineWhile() {
        return this.preferences.getBoolean(41);
    }

    public void setNewlineWhile(boolean newlineWhile) {
        this.preferences.setBoolean(41, newlineWhile);
    }

    public boolean getNewlineCatch() {
        return this.preferences.getBoolean(42);
    }

    public void setNewlineCatch(boolean newlineCatch) {
        this.preferences.setBoolean(42, newlineCatch);
    }

    public boolean getNewlineFinally() {
        return this.preferences.getBoolean(43);
    }

    public void setNewlineFinally(boolean newlineFinally) {
        this.preferences.setBoolean(43, newlineFinally);
    }

    public boolean getSpaceBeforeComma() {
        return this.preferences.getBoolean(57);
    }

    public void setSpaceBeforeComma(boolean spaceBeforeComma) {
        this.preferences.setBoolean(57, spaceBeforeComma);
    }

    public boolean getSpaceAfterComma() {
        return this.preferences.getBoolean(58);
    }

    public void setSpaceAfterComma(boolean spaceAfterComma) {
        this.preferences.setBoolean(58, spaceAfterComma);
    }

    public boolean getSpaceBeforeSemicolon() {
        return this.preferences.getBoolean(59);
    }

    public void setSpaceBeforeSemicolon(boolean spaceBeforeSemicolon) {
        this.preferences.setBoolean(59, spaceBeforeSemicolon);
    }

    public boolean getSpaceAfterSemicolon() {
        return this.preferences.getBoolean(60);
    }

    public void setSpaceAfterSemicolon(boolean spaceAfterSemicolon) {
        this.preferences.setBoolean(60, spaceAfterSemicolon);
    }

    public boolean getSpaceBeforeQuestion() {
        return this.preferences.getBoolean(61);
    }

    public void setSpaceBeforeQuestion(boolean spaceBeforeQuestion) {
        this.preferences.setBoolean(61, spaceBeforeQuestion);
    }

    public boolean getSpaceAfterQuestion() {
        return this.preferences.getBoolean(62);
    }

    public void setSpaceAfterQuestion(boolean spaceAfterQuestion) {
        this.preferences.setBoolean(62, spaceAfterQuestion);
    }

    public boolean getSpaceBeforeColon() {
        return this.preferences.getBoolean(63);
    }

    public void setSpaceBeforeColon(boolean spaceBeforeColon) {
        this.preferences.setBoolean(63, spaceBeforeColon);
    }

    public boolean getSpaceAfterColon() {
        return this.preferences.getBoolean(64);
    }

    public void setSpaceAfterColon(boolean spaceAfterColon) {
        this.preferences.setBoolean(64, spaceAfterColon);
    }

    public boolean getSpaceAfterTypecast() {
        return this.preferences.getBoolean(65);
    }

    public void setSpaceAfterTypecast(boolean spaceAfterTypecast) {
        this.preferences.setBoolean(65, spaceAfterTypecast);
    }

    public boolean getSpaceBeforeArguments() {
        return this.preferences.getBoolean(66);
    }

    public void setSpaceBeforeArguments(boolean spaceBeforeArguments) {
        this.preferences.setBoolean(66, spaceBeforeArguments);
    }

    public boolean getSpaceBeforeParameters() {
        return this.preferences.getBoolean(67);
    }

    public void setSpaceBeforeParameters(boolean spaceBeforeParameters) {
        this.preferences.setBoolean(67, spaceBeforeParameters);
    }

    public boolean getSpaceAfterKeyword() {
        return this.preferences.getBoolean(68);
    }

    public void setSpaceAfterKeyword(boolean spaceAfterKeyword) {
        this.preferences.setBoolean(68, spaceAfterKeyword);
    }

    public boolean getSpaceAroundAssignment() {
        return this.preferences.getBoolean(69);
    }

    public void setSpaceAroundAssignment(boolean spaceAroundAssignment) {
        this.preferences.setBoolean(69, spaceAroundAssignment);
    }

    public boolean getSpaceAroundBinaryOperator() {
        return this.preferences.getBoolean(70);
    }

    public void setSpaceAroundBinaryOperator(boolean spaceAroundBinaryOperator) {
        this.preferences.setBoolean(70, spaceAroundBinaryOperator);
    }

    public boolean getSpaceWithinParenthesis() {
        return this.preferences.getBoolean(71);
    }

    public void setSpaceWithinParenthesis(boolean spaceWithinParenthesis) {
        this.preferences.setBoolean(71, spaceWithinParenthesis);
    }

    public boolean getSpaceWithinBrackets() {
        return this.preferences.getBoolean(72);
    }

    public void setSpaceWithinBrackets(boolean spaceWithinBrackets) {
        this.preferences.setBoolean(72, spaceWithinBrackets);
    }

    public boolean getSpaceBeforeOpenBrace() {
        return this.preferences.getBoolean(73);
    }

    public void setSpaceBeforeOpenBrace(boolean spaceBeforeOpenBrace) {
        this.preferences.setBoolean(73, spaceBeforeOpenBrace);
    }

    public boolean getSpaceAroundLambdaOperator() {
        return this.preferences.getBoolean(74);
    }

    public void setSpaceAroundLambdaOperator(boolean spaceAroundLambdaOperator) {
        this.preferences.setBoolean(74, spaceAroundLambdaOperator);
    }

    public int getWrapLineWidth() {
        return this.preferences.getInt(75);
    }

    public void setWrapLineWidth(int wrapLineWidth) {
        this.preferences.setInt(75, wrapLineWidth);
    }

    public boolean getWrapAlign() {
        return this.preferences.getBoolean(76);
    }

    public void setWrapAlign(boolean wrapAlign) {
        this.preferences.setBoolean(76, wrapAlign);
    }

    public int getWrapModifiers() {
        return this.preferences.getInt(77);
    }

    public void setWrapModifiers(int wrapModifiers) {
        this.preferences.setInt(77, wrapModifiers);
    }

    public int getWrapExtends() {
        return this.preferences.getInt(78);
    }

    public void setWrapExtends(int wrapExtends) {
        this.preferences.setInt(78, wrapExtends);
    }

    public int getWrapThrows() {
        return this.preferences.getInt(79);
    }

    public void setWrapThrows(int wrapThrows) {
        this.preferences.setInt(79, wrapThrows);
    }

    public int getWrapParameterList() {
        return this.preferences.getInt(80);
    }

    public void setWrapParameterList(int wrapParameterList) {
        this.preferences.setInt(80, wrapParameterList);
    }

    public int getWrapDotChain() {
        return this.preferences.getInt(81);
    }

    public void setWrapDotChain(int wrapDotChain) {
        this.preferences.setInt(81, wrapDotChain);
    }

    public boolean getWrapDotChainBeforeDot() {
        return this.preferences.getBoolean(101);
    }

    public void setWrapDotChainBeforeDot(boolean wrapDotChainBeforeDot) {
        this.preferences.setBoolean(101, wrapDotChainBeforeDot);
    }

    public int getWrapForStatement() {
        return this.preferences.getInt(82);
    }

    public void setWrapForStatement(int wrapForStatement) {
        this.preferences.setInt(82, wrapForStatement);
    }

    public int getWrapBinaryOperator() {
        return this.preferences.getInt(83);
    }

    public void setWrapBinaryOperator(int wrapBinaryOperator) {
        this.preferences.setInt(83, wrapBinaryOperator);
    }

    public int getWrapTernaryExpression() {
        return this.preferences.getInt(84);
    }

    public void setWrapTernaryExpression(int wrapTernaryExpression) {
        this.preferences.setInt(84, wrapTernaryExpression);
    }

    public int getWrapArrayConstant() {
        return this.preferences.getInt(85);
    }

    public void setWrapArrayConstant(int wrapArrayConstant) {
        this.preferences.setInt(85, wrapArrayConstant);
    }

    public int getWrapInvokeArguments() {
        return this.preferences.getInt(86);
    }

    public void setWrapInvokeArguments(int wrapInvokeArguments) {
        this.preferences.setInt(86, wrapInvokeArguments);
    }

    public int getWrapAnonymousClassAssignments() {
        return this.preferences.getInt(87);
    }

    public void setWrapAnonymousClassAssignments(int wrapAnonymousClassAssignments) {
        this.preferences.setInt(87, wrapAnonymousClassAssignments);
    }

    @Deprecated
    public int getWrapClassAnnotations() {
        return this.preferences.getInt(88);
    }

    @Deprecated
    public void setWrapClassAnnotations(int wrapClassAnnotations) {
        this.preferences.setInt(88, wrapClassAnnotations);
    }

    @Deprecated
    public int getWrapMethodAnnotations() {
        return this.preferences.getInt(89);
    }

    @Deprecated
    public void setWrapMethodAnnotations(int wrapMethodAnnotations) {
        this.preferences.setInt(89, wrapMethodAnnotations);
    }

    @Deprecated
    public int getWrapFieldAnnotations() {
        return this.preferences.getInt(90);
    }

    @Deprecated
    public void setWrapFieldAnnotations(int wrapFieldAnnotations) {
        this.preferences.setInt(90, wrapFieldAnnotations);
    }

    public int getWrapParameterAnnotations() {
        return this.preferences.getInt(91);
    }

    @Deprecated
    public void setWrapParameterAnnotations(int wrapParameterAnnotations) {
        this.preferences.setInt(91, wrapParameterAnnotations);
    }

    @Deprecated
    public int getWrapLocalVariableAnnotations() {
        return this.preferences.getInt(92);
    }

    @Deprecated
    public void setWrapLocalVariableAnnotations(int wrapLocalVariableAnnotations) {
        this.preferences.setInt(92, wrapLocalVariableAnnotations);
    }

    public int getWrapAnnotations() {
        return this.preferences.getInt(93);
    }

    public void setWrapAnnotations(int wrapAnnotations) {
        this.preferences.setInt(93, wrapAnnotations);
    }

    public int getWrapMarkerAnnotations() {
        return this.preferences.getInt(94);
    }

    public void setWrapMarkerAnnotations(int wrapMarkerAnnotations) {
        this.preferences.setInt(94, wrapMarkerAnnotations);
    }

    public int getWrapTypeAnnotations() {
        return this.preferences.getInt(95);
    }

    public void setWrapTypeAnnotations(int wrapTypeAnnotations) {
        this.preferences.setInt(95, wrapTypeAnnotations);
    }

    public boolean getWrapBeforeOperators() {
        return this.preferences.getBoolean(96);
    }

    public void setWrapBeforeOperators(boolean wrapBeforeOperators) {
        this.preferences.setBoolean(96, wrapBeforeOperators);
    }

    public boolean getWrapBeforeTernaryOperators() {
        return this.preferences.getBoolean(97);
    }

    public void setWrapBeforeTernaryOperators(boolean wrapBeforeTernaryOperators) {
        this.preferences.setBoolean(97, wrapBeforeTernaryOperators);
    }

    public int getWrapImplements() {
        return this.preferences.getInt(98);
    }

    public void setWrapImplements(int wrapImplements) {
        this.preferences.setInt(98, wrapImplements);
    }

    public int getWrapAssertOperators() {
        return this.preferences.getInt(99);
    }

    public void setWrapAssertOperators(int wrapAssertOperators) {
        this.preferences.setInt(99, wrapAssertOperators);
    }

    public boolean getWrapStringEolConcatenations() {
        return this.preferences.getBoolean(100);
    }

    public void setWrapStringEolConcatenations(boolean wrapStringEolConcatenations) {
        this.preferences.setBoolean(100, wrapStringEolConcatenations);
    }

    public boolean getGroupImports() {
        return this.preferences.getBoolean(102);
    }

    public void setGroupImports(boolean groupImports) {
        this.preferences.setBoolean(102, groupImports);
    }

    public int getGroupPackageDepth() {
        return this.preferences.getInt(103);
    }

    public void setGroupPackageDepth(int groupPackageDepth) {
        this.preferences.setInt(103, groupPackageDepth);
    }

    public boolean getImportInnerClasses() {
        return this.preferences.getBoolean(104);
    }

    public void setImportInnerClasses(boolean importInnerClasses) {
        this.preferences.setBoolean(104, importInnerClasses);
    }

    public boolean getUseWideImports() {
        return this.preferences.getInt(105) != -1;
    }

    public void setUseWideImports(boolean useWideImports) {
        int previous = this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
        this.preferences.setInt(105, useWideImports ? previous : -1);
    }

    public int getWideImportThreshold() {
        return this.getUseWideImports() ? this.preferences.getInt(105) : this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
    }

    public boolean getUseWideMemberImports() {
        return this.preferences.getInt(106) != -1;
    }

    public void setUseWideMemberImports(boolean useWideMemberImports) {
        int previous = this._hash.getInt(IMPORT_NARROW_THRESHOLD_MEMBER_PREVIOUS, 1);
        this.preferences.setInt(106, useWideMemberImports ? previous : -1);
    }

    public int getWideImportMemberThreshold() {
        return this.getUseWideMemberImports() ? this.preferences.getInt(106) : this._hash.getInt(IMPORT_NARROW_THRESHOLD_MEMBER_PREVIOUS, 1);
    }

    public void setWideImportThreshold(int wideImportThreshold) {
        if (this.getUseWideImports()) {
            this.preferences.setInt(105, wideImportThreshold);
        } else {
            wideImportThreshold = Math.max(wideImportThreshold, 1);
            this._hash.putInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, wideImportThreshold);
        }
    }

    public void setWideImportMemberThreshold(int wideImportMemberThreshold) {
        if (this.getUseWideMemberImports()) {
            this.preferences.setInt(106, wideImportMemberThreshold);
        } else {
            wideImportMemberThreshold = Math.max(wideImportMemberThreshold, 1);
            this._hash.putInt(IMPORT_NARROW_THRESHOLD_MEMBER_PREVIOUS, wideImportMemberThreshold);
        }
    }

    public boolean getCuddleEmptyBraces() {
        return this.preferences.getBoolean(109);
    }

    public void setCuddleEmptyBraces(boolean cuddleEmptyBraces) {
        this.preferences.setBoolean(109, cuddleEmptyBraces);
    }

    public boolean getAlignAnonymousClasses() {
        return this.preferences.getBoolean(110);
    }

    public void setAlignAnonymousClasses(boolean alignAnonymousClasses) {
        this.preferences.setBoolean(110, alignAnonymousClasses);
    }

    public boolean getAlignVariableNames() {
        return this.preferences.getBoolean(111);
    }

    public void setAlignVariableNames(boolean alignVariableNames) {
        this.preferences.setBoolean(111, alignVariableNames);
    }

    public boolean getAlignArrayInitializers() {
        return this.preferences.getBoolean(112);
    }

    public void setAlignArrayInitializers(boolean alignArrayInitializers) {
        this.preferences.setBoolean(112, alignArrayInitializers);
    }

    public String getFieldPrefix() {
        return this._hash.getString(FIELD_PREFIX);
    }

    public void setFieldPrefix(String prefix) {
        this._hash.putString(FIELD_PREFIX, prefix);
    }

    public String getFieldSuffix() {
        return this._hash.getString(FIELD_SUFFIX);
    }

    public void setFieldSuffix(String suffix) {
        this._hash.putString(FIELD_SUFFIX, suffix);
    }

    public String getStaticFieldPrefix() {
        return this._hash.getString(STATIC_FIELD_PREFIX);
    }

    public void setStaticFieldPrefix(String prefix) {
        this._hash.putString(STATIC_FIELD_PREFIX, prefix);
    }

    public String getStaticFieldSuffix() {
        return this._hash.getString(STATIC_FIELD_SUFFIX);
    }

    public void setStaticFieldSuffix(String suffix) {
        this._hash.putString(STATIC_FIELD_SUFFIX, suffix);
    }

    public String getParameterPrefix() {
        return this._hash.getString(PARAMETER_PREFIX);
    }

    public void setParameterPrefix(String prefix) {
        this._hash.putString(PARAMETER_PREFIX, prefix);
    }

    public String getParameterSuffix() {
        return this._hash.getString(PARAMETER_SUFFIX);
    }

    public void setParameterSuffix(String suffix) {
        this._hash.putString(PARAMETER_SUFFIX, suffix);
    }

    public String getLocalVariablePrefix() {
        return this._hash.getString(LOCAL_VARIABLE_PREFIX);
    }

    public void setLocalVariablePrefix(String prefix) {
        this._hash.putString(LOCAL_VARIABLE_PREFIX, prefix);
    }

    public String getLocalVariableSuffix() {
        return this._hash.getString(LOCAL_VARIABLE_SUFFIX);
    }

    public void setLocalVariableSuffix(String suffix) {
        this._hash.putString(LOCAL_VARIABLE_SUFFIX, suffix);
    }

    public boolean getAlignLambdaBodies() {
        return this.preferences.getBoolean(113);
    }

    public void setAlignLambdaBodies(boolean alignLambdaBodies) {
        this.preferences.setBoolean(113, alignLambdaBodies);
    }

    public byte getMemberOrder(int member) {
        return this.preferences.getMemberOrder(member);
    }

    public void setMemberOrder(int member, byte order) {
        this.preferences.setMemberOrder(member, order);
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.preferences.getMemberOrderHashStructure();
    }

    public void setMemberOrderHashStructure(HashStructure hash) {
        String key = PREFERENCES_keys[108];
        if (hash != null) {
            hash.copyTo(this._hash.getOrCreateHashStructure(key));
        } else {
            this._hash.remove(key);
        }
    }

    public char[] getIndentChars(int level) {
        int i;
        if (level == 0 || this.getIndentSize() == 0) {
            return new char[0];
        }
        int numSpaces = level * this.getIndentSize();
        int numTabs = 0;
        if (this.getIndentReplaceWithTabs()) {
            int tabSize = this.getTabSize();
            numTabs = numSpaces / tabSize;
            numSpaces %= tabSize;
        }
        char[] chars = new char[numTabs + numSpaces];
        for (i = 0; i < numTabs; ++i) {
            chars[i] = 9;
        }
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        return chars;
    }

    public String format(String input) {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, input.toCharArray());
        SourceFile file = JavaParser.parse((ReadTextBuffer)textBuffer, (JdkVersion)JdkVersion.getMaxVersion());
        file.setPreferences(this.preferences);
        StringWriter writer = new StringWriter();
        file.print(new PrintWriter((Writer)writer, true));
        return writer.getBuffer().toString();
    }

    public String getFieldName(String base) {
        return this.generateName(base, this.getFieldPrefix(), this.getFieldSuffix());
    }

    public String getStaticFieldName(String base) {
        return this.generateName(base, this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
    }

    public String getParameterName(String base) {
        return this.generateName(base, this.getParameterPrefix(), this.getParameterSuffix());
    }

    public String getLocalVariableName(String base) {
        return this.generateName(base, this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
    }

    private String generateName(String base, String prefix, String suffix) {
        base = base == null ? "" : base.trim();
        prefix = prefix == null ? "" : prefix.trim();
        suffix = suffix == null ? "" : suffix.trim();
        StringBuffer result = new StringBuffer(base.length() + prefix.length() + suffix.length());
        result.append(base);
        if (base.length() > 1) {
            int len = prefix.length();
            if (!(len <= 0 || result.indexOf(prefix) == 0 && result.length() > len && Character.isUpperCase(result.charAt(len)))) {
                result.insert(0, prefix);
                char c = prefix.charAt(len - 1);
                if (Character.isLetter(c)) {
                    result.setCharAt(len, Character.toUpperCase(result.charAt(len)));
                }
            }
            result.append(suffix);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object target) {
        if (target == null) {
            target = new CodingStyleProfile();
        }
        CodingStyleProfile copy = (CodingStyleProfile)((Object)target);
        try {
            copy.disableEvents();
            Object object = super.copyTo(target);
            return object;
        }
        finally {
            copy.enableEvents();
            copy.fireOptionsChanged();
        }
    }

    private void disableEvents() {
        this.disableEvents = true;
    }

    private void enableEvents() {
        this.disableEvents = false;
    }

    private void fireOptionsChanged() {
        for (CodingStyleOptionsListener listener : this.listeners) {
            listener.optionsChanged((CodingStyleOptions)this);
        }
    }

    public String applyNamingConventions(String text) {
        String output = text;
        output = this.replaceTag(output, "field", this.getFieldPrefix(), this.getFieldSuffix());
        output = this.replaceTag(output, "static", this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
        output = this.replaceTag(output, "parameter", this.getParameterPrefix(), this.getParameterSuffix());
        output = this.replaceTag(output, "local", this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
        return output;
    }

    private String replaceTag(String text, String tag, String prefix, String suffix) {
        StringBuffer result = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{" + tag + " (.*?)\\}");
        Matcher matcher = pattern.matcher(text);
        int current = 0;
        while (matcher.find(current)) {
            int start = matcher.start();
            int end = matcher.end();
            result.append(text.substring(current, start));
            String name = matcher.group(1);
            result.append(this.generateName(name, prefix, suffix));
            current = end;
        }
        result.append(text.substring(current));
        return result.toString();
    }

    private class ChangeListener
    extends StructureChangeListener {
        private ChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            if (!CodingStyleProfile.this.disableEvents) {
                CodingStyleProfile.this.fireOptionsChanged();
            }
        }
    }
}

