/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Comparator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.token.Token;

public class PlSqlComparator
implements Comparator<String> {
    private boolean m_ignoreComments = true;
    private boolean m_ignoreWhitespace = true;

    public PlSqlComparator() {
    }

    public PlSqlComparator(boolean bl, boolean bl2) {
        this.m_ignoreComments = bl;
        this.m_ignoreWhitespace = bl2;
    }

    @Override
    public int compare(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize(string, new String[0]);
        PlSqlToken plSqlToken2 = PlSqlTokenizer.tokenize(string2, new String[0]);
        while (true) {
            plSqlToken = this.getNextTokenToCompare(plSqlToken);
            plSqlToken2 = this.getNextTokenToCompare(plSqlToken2);
            if (plSqlToken.getType() != plSqlToken2.getType()) {
                return plSqlToken.getType().toString().compareTo(plSqlToken2.getType().toString());
            }
            if (plSqlToken.getType() == Token.Type.END_MARKER) break;
            boolean bl = plSqlToken.getType() == Token.Type.ALPHANUMERIC;
            int n = plSqlToken.getSource(bl).compareTo(plSqlToken2.getSource(bl));
            if (n != 0) {
                return n;
            }
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        return 0;
    }

    private PlSqlToken getNextTokenToCompare(PlSqlToken plSqlToken) {
        PlSqlToken plSqlToken2 = plSqlToken;
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            if (this.m_ignoreWhitespace && plSqlToken2.getType() == Token.Type.WHITESPACE) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
                continue;
            }
            if (!this.m_ignoreComments || plSqlToken2.getType() != Token.Type.SINGLE_LINE_COMMENT && plSqlToken2.getType() != Token.Type.MULTI_LINE_COMMENT) break;
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        return plSqlToken2;
    }
}

