/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.GeneralNames;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ReceiptRequest
implements ASN1Object {
    private byte[] signedContentIdentifier;
    private AllOrFirstTier allOrFirstTier;
    private Vector receiptList;
    private Vector receiptsTo;
    private ASN1Sequence contents;
    public static final int UB_RECEIPTS_TO = 16;

    public ReceiptRequest(byte[] signedContentIdentifier, GeneralNames generalNames) {
        this(signedContentIdentifier, AllOrFirstTier.ALL_RECIPIENTS, generalNames);
    }

    public ReceiptRequest(byte[] signedContentIdentifier, AllOrFirstTier allOrFirstTier, GeneralNames generalNames) {
        this.signedContentIdentifier = signedContentIdentifier;
        this.allOrFirstTier = allOrFirstTier;
        this.receiptList = null;
        this.receiptsTo = new Vector();
        this.receiptsTo.addElement(generalNames);
        this.contents = null;
    }

    public ReceiptRequest(byte[] signedContentIdentifier, AllOrFirstTier allOrFirstTier, Vector generalNames) throws InvalidInputException {
        this.signedContentIdentifier = signedContentIdentifier;
        this.allOrFirstTier = allOrFirstTier;
        this.receiptList = null;
        this.receiptsTo = new Vector();
        if (generalNames.size() < 1) {
            throw new InvalidInputException("ReceiptsTo list MUST not be empty");
        }
        if (generalNames.size() > 16) {
            throw new InvalidInputException("Receipts To list MUST not exceed 16");
        }
        int j = generalNames.size();
        for (int i = 0; i < j; ++i) {
            this.receiptsTo.addElement((GeneralNames)generalNames.elementAt(i));
        }
        this.contents = null;
    }

    public ReceiptRequest(byte[] signedContentIdentifier, GeneralNames rcptsFrom, GeneralNames generalNames) throws InvalidInputException {
        this.signedContentIdentifier = signedContentIdentifier;
        this.allOrFirstTier = null;
        this.receiptList = new Vector();
        this.addReceiptsFrom(rcptsFrom);
        this.receiptsTo = new Vector();
        this.addReceiptsTo(generalNames);
        this.contents = null;
    }

    public ReceiptRequest(byte[] signedContentIdentifier, Vector rcptsFrom, Vector generalNames) throws InvalidInputException {
        this.signedContentIdentifier = signedContentIdentifier;
        this.allOrFirstTier = null;
        this.receiptList = new Vector();
        this.addReceiptsFrom(generalNames);
        this.receiptsTo = new Vector();
        this.addReceiptsTo(generalNames);
        this.contents = null;
    }

    public ReceiptRequest(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public ReceiptRequest(CMSSignerInfo si) throws InvalidInputException {
        if (si == null) {
            throw new InvalidInputException("No SignerInfo Present");
        }
        Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_receiptRequest);
        if (vals == null) {
            throw new InvalidInputException("ReceiptRequest Values is NULL");
        }
        if (vals.getValues().size() != 1) {
            throw new InvalidInputException("ReceiptRequest Must Be Single Valued");
        }
        try {
            this.input((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)((ASN1Sequence)vals.getValues().elementAt(0)))));
            this.contents = null;
        }
        catch (IOException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public void addReceiptsTo(X500Name directoryName) throws InvalidInputException {
        if (this.receiptsTo.size() + 1 > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        this.receiptsTo.addElement(new GeneralNames(directoryName));
        this.contents = null;
    }

    public void addReceiptsTo(String rfc822Name) throws InvalidInputException {
        if (this.receiptsTo.size() + 1 > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        this.receiptsTo.addElement(new GeneralNames(rfc822Name));
        this.contents = null;
    }

    public void addReceiptsTo(X500Name directoryName, String rfc822Name) throws InvalidInputException {
        if (this.receiptsTo.size() + 1 > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        this.receiptsTo.addElement(new GeneralNames(directoryName, rfc822Name));
        this.contents = null;
    }

    public void addReceiptsTo(GeneralName generalName) throws InvalidInputException {
        if (this.receiptsTo.size() + 1 > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        this.receiptsTo.addElement(new GeneralNames(generalName));
        this.contents = null;
    }

    public void addReceiptsTo(GeneralNames generalNames) throws InvalidInputException {
        if (this.receiptsTo.size() + 1 > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        this.receiptsTo.addElement(generalNames);
        this.contents = null;
    }

    public void addReceiptsTo(Vector generalNames) throws InvalidInputException {
        if (this.receiptsTo.size() + generalNames.size() > 16) {
            throw new InvalidInputException("Receipts To WILL exceed the maximum size allowed - 16");
        }
        int j = generalNames.size();
        for (int i = 0; i < j; ++i) {
            this.receiptsTo.addElement((GeneralNames)generalNames.elementAt(i));
        }
        this.contents = null;
    }

    public void addReceiptsFrom(X500Name directoryName) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        this.receiptList.addElement(new GeneralNames(directoryName));
        this.contents = null;
    }

    public void addReceiptsFrom(String rfc822Name) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        this.receiptList.addElement(new GeneralNames(rfc822Name));
        this.contents = null;
    }

    public void addReceiptsFrom(X500Name directoryName, String rfc822Name) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        this.receiptList.addElement(new GeneralNames(directoryName, rfc822Name));
        this.contents = null;
    }

    public void addReceiptsFrom(GeneralName generalName) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        this.receiptList.addElement(new GeneralNames(generalName));
        this.contents = null;
    }

    public void addReceiptsFrom(GeneralNames generalNames) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        this.receiptList.addElement(generalNames);
        this.contents = null;
    }

    public void addReceiptsFrom(Vector genNames) throws InvalidInputException {
        if (this.receiptList == null) {
            throw new InvalidInputException("AllOrFirstTier is being used for receipts from");
        }
        int j = genNames.size();
        for (int i = 0; i < j; ++i) {
            this.receiptList.addElement((GeneralNames)genNames.elementAt(i));
        }
        this.contents = null;
    }

    public void setAllOrFirstTierReceiptsFrom(AllOrFirstTier allOrFirstTier) throws InvalidInputException {
        if (allOrFirstTier == null) {
            throw new InvalidInputException("ReceiptList is being used for receipts from");
        }
        this.allOrFirstTier = allOrFirstTier;
        this.contents = null;
    }

    public AllOrFirstTier getAllOrFirstTier() {
        return this.allOrFirstTier;
    }

    public Enumeration receiptsTo() {
        return this.receiptsTo.elements();
    }

    public Vector getReceiptsTo() {
        return this.receiptsTo;
    }

    public Enumeration receiptsFrom() {
        if (this.receiptList == null || this.receiptList.size() < 1) {
            return null;
        }
        return this.receiptList.elements();
    }

    public Vector getReceiptList() {
        return this.receiptList;
    }

    public byte[] getSignedContentIdentifier() {
        return this.signedContentIdentifier;
    }

    public boolean checkReceiptsFrom(X500Name recipientX500Name) {
        return this.checkReceiptsFrom(new GeneralName(recipientX500Name));
    }

    public boolean checkReceiptsFrom(String rfc822Name) {
        return this.checkReceiptsFrom(new GeneralName(GeneralName.Type.RFC822_NAME, rfc822Name));
    }

    public boolean checkReceiptsFrom(GeneralName generalName) {
        if (this.allOrFirstTier != null) {
            return true;
        }
        int j = this.receiptList.size();
        for (int i = 0; i < j; ++i) {
            Vector vect = ((GeneralNames)this.receiptList.elementAt(i)).getGeneralNames();
            if (!vect.contains(generalName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReceiptRequest)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((ReceiptRequest)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public String toString() {
        int i;
        int tmp;
        StringBuffer sb = new StringBuffer("Signed Content ID: " + Utils.toHexString((byte[])this.signedContentIdentifier));
        if (this.allOrFirstTier != null) {
            sb.append("\n ALLOrFirstTier: " + this.allOrFirstTier.getValue());
        } else {
            sb.append("\n ReceiptList: ");
            tmp = this.receiptList.size();
            for (i = 0; i < tmp; ++i) {
                sb.append((GeneralNames)this.receiptList.elementAt(i));
            }
        }
        sb.append("\n ReceiptsTo: ");
        tmp = this.receiptsTo.size();
        for (i = 0; i < tmp; ++i) {
            sb.append((GeneralNames)this.receiptsTo.elementAt(i));
        }
        return sb.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq1;
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.signedContentIdentifier = ASN1OctetString.inputValue((InputStream)seq);
        if (seq.getCurrentTag() == 0) {
            this.receiptList = null;
            seq.setCurrentTag(2);
            this.allOrFirstTier = new AllOrFirstTier(new ASN1Integer((InputStream)seq).intValue());
        } else if (seq.getCurrentTag() == 1) {
            this.allOrFirstTier = null;
            seq.setCurrentTag(16);
            seq1 = new ASN1SequenceInputStream((InputStream)seq);
            if (seq1.hasMoreData()) {
                this.receiptList = new Vector();
                while (seq1.hasMoreData()) {
                    this.receiptList.addElement(new GeneralNames((InputStream)seq1));
                }
            }
            seq1.terminate();
        } else {
            throw new IOException("Unknown/Unsupported receiptsFrom tag: " + seq.getCurrentTag());
        }
        if (seq.hasMoreData()) {
            seq1 = new ASN1SequenceInputStream((InputStream)seq);
            this.receiptsTo = new Vector();
            while (seq1.hasMoreData()) {
                this.receiptsTo.addElement(new GeneralNames((InputStream)seq1));
            }
            seq1.terminate();
            if (this.receiptsTo.size() < 1) {
                throw new IOException("receiptsTo MUST NOT be empty");
            }
            if (this.receiptsTo.size() + 1 > 16) {
                throw new IOException("receiptsTo Exceeds Maximum allowed size");
            }
        } else {
            throw new IOException("Unexpected end of stream while reading receiptsTo");
        }
        seq.terminate();
        this.contents = null;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence();
            this.contents.addElement((ASN1Object)new ASN1OctetString(this.signedContentIdentifier));
            if (this.allOrFirstTier != null) {
                this.contents.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Integer((long)this.allOrFirstTier.getValue()), 0));
            } else {
                this.contents.addElement((ASN1Object)new ASN1GenericConstructed(this.receiptList, 1));
            }
            this.contents.addElement((ASN1Object)new ASN1Sequence(this.receiptsTo));
        }
        return this.contents;
    }

    public static class AllOrFirstTier {
        public static final AllOrFirstTier ALL_RECIPIENTS = new AllOrFirstTier(0);
        public static final AllOrFirstTier FIRST_TIER_RECIPIENTS = new AllOrFirstTier(1);
        private int value;

        AllOrFirstTier(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AllOrFirstTier)) {
                return false;
            }
            return this.value == ((AllOrFirstTier)o).getValue();
        }
    }
}

