/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralNames;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class MLReceiptPolicy
implements ASN1Object {
    private PolicyType policyType;
    private Vector generalNames;
    private ASN1Object contents;

    public MLReceiptPolicy(PolicyType policyType) {
        this.policyType = policyType;
        this.generalNames = null;
        this.contents = null;
    }

    public MLReceiptPolicy(PolicyType policyType, GeneralNames generalNames) {
        this.policyType = policyType;
        if (generalNames != null) {
            this.generalNames = new Vector();
            this.generalNames.addElement(generalNames);
        }
        this.contents = null;
    }

    public MLReceiptPolicy(PolicyType policyType, Vector generalNames) {
        this.policyType = policyType;
        if (generalNames != null && generalNames.size() > 0) {
            this.generalNames = new Vector();
            int j = generalNames.size();
            for (int i = 0; i < j; ++i) {
                this.generalNames.addElement((GeneralNames)generalNames.elementAt(i));
            }
        }
        this.contents = null;
    }

    public MLReceiptPolicy(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MLReceiptPolicy)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((MLReceiptPolicy)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void addReceiptPolicyValues(GeneralNames generalNames) {
        if (this.generalNames == null) {
            this.generalNames = new Vector();
        }
        this.generalNames.addElement(generalNames);
        this.contents = null;
    }

    public void addReceiptPolicyValues(Vector generalNames) {
        if (this.generalNames == null) {
            this.generalNames = new Vector();
        }
        int j = generalNames.size();
        for (int i = 0; i < j; ++i) {
            this.generalNames.addElement(generalNames.elementAt(i));
        }
        this.contents = null;
    }

    public boolean removeReceiptPolicyValues(GeneralNames generalNames) {
        if (generalNames == null) {
            return false;
        }
        this.contents = null;
        return this.generalNames.removeElement(generalNames);
    }

    public boolean removeReceiptPolicyValues(Vector generalNames) {
        if (generalNames == null) {
            return false;
        }
        this.contents = null;
        boolean res = false;
        if (generalNames.size() > 0) {
            int j = generalNames.size();
            for (int i = 0; i < j; ++i) {
                if (!res) {
                    res = this.generalNames.removeElement(generalNames.elementAt(i));
                    continue;
                }
                this.generalNames.removeElement(generalNames.elementAt(i));
            }
        }
        return res;
    }

    public PolicyType getMLReceiptPolicyType() {
        return this.policyType;
    }

    public Vector getReceiptNames() {
        if (this.policyType.equals(PolicyType.NONE)) {
            return null;
        }
        return this.generalNames;
    }

    public Enumeration receiptNames() {
        if (this.generalNames == null || this.policyType == PolicyType.NONE) {
            return null;
        }
        return this.generalNames.elements();
    }

    public void input(InputStream is) throws IOException {
        PushbackInputStream body_pbin = new PushbackInputStream(is);
        int ch = body_pbin.read();
        if (ch == 128) {
            body_pbin.unread(5);
            this.policyType = PolicyType.NONE;
            this.generalNames = null;
            new ASN1Null((InputStream)body_pbin);
        } else if (ch == 161) {
            body_pbin.unread(48);
            this.policyType = PolicyType.INSTEAD_OF;
            ASN1SequenceInputStream gns = new ASN1SequenceInputStream((InputStream)body_pbin);
            if (!gns.hasMoreData()) {
                throw new IOException("unexpected end of stream which reading MLReceiptPolicy");
            }
            this.generalNames = new Vector();
            while (gns.hasMoreData()) {
                this.generalNames.addElement(new GeneralNames((InputStream)gns));
            }
            gns.terminate();
        } else if (ch == 162) {
            body_pbin.unread(48);
            this.policyType = PolicyType.IN_ADDITION_TO;
            ASN1SequenceInputStream gns = new ASN1SequenceInputStream((InputStream)body_pbin);
            if (!gns.hasMoreData()) {
                throw new IOException("unexpected end of stream which reading MLReceiptPolicy");
            }
            this.generalNames = new Vector();
            while (gns.hasMoreData()) {
                this.generalNames.addElement(new GeneralNames((InputStream)gns));
            }
            gns.terminate();
        } else {
            throw new IOException("Unrecognized MLReceiptPolicyType: " + (ch & 0x1F));
        }
        this.contents = null;
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            this.contents = this.policyType.equals(PolicyType.INSTEAD_OF) ? new ASN1GenericConstructed(this.generalNames, 1) : (this.policyType.equals(PolicyType.IN_ADDITION_TO) ? new ASN1GenericConstructed(this.generalNames, 2) : new ASN1GenericPrimitive((ASN1Object)new ASN1Null(), 0));
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        if ((this.generalNames == null || this.generalNames.size() < 1) && (this.policyType.equals(PolicyType.INSTEAD_OF) || this.policyType.equals(PolicyType.IN_ADDITION_TO))) {
            throw new IOException("MLReceiptPolicy is not NONE: list of GeneralNames MUST be Present");
        }
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MLReceiptPolicy: ");
        sb.append("\nType: " + this.policyType);
        sb.append("GeneralNames: " + (this.generalNames == null ? "None\n" : this.generalNames.toString()));
        return sb.toString();
    }

    public static class PolicyType {
        int type;
        public static final PolicyType NONE = new PolicyType(0);
        public static final PolicyType INSTEAD_OF = new PolicyType(1);
        public static final PolicyType IN_ADDITION_TO = new PolicyType(2);

        PolicyType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            if (this.type == 2) {
                return "ML Receipt Policy: IN_ADDITION_TO";
            }
            if (this.type == 1) {
                return "ML Receipt Policy: INSTEAD_OF";
            }
            return "ML Receipt Policy: NONE";
        }

        public boolean equals(Object o) {
            if (!(o instanceof PolicyType)) {
                return false;
            }
            return this.type == ((PolicyType)o).getType();
        }

        public int hashCode() {
            return this.type;
        }
    }
}

