/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.GeneralNames;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.ESSReceipt;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.MailTrustPolicy;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.SmimeCapabilities;
import oracle.security.crypto.smime.SmimeMultipartSigned;
import oracle.security.crypto.smime.SmimeSigned;
import oracle.security.crypto.smime.SmimeSignedObject;
import oracle.security.crypto.smime.SmimeUtils;
import oracle.security.crypto.smime.ess.ESSException;
import oracle.security.crypto.smime.ess.ESSSecurityLabel;
import oracle.security.crypto.smime.ess.EquivalentLabels;
import oracle.security.crypto.smime.ess.MLData;
import oracle.security.crypto.smime.ess.MLExpansionHistory;
import oracle.security.crypto.smime.ess.MLReceiptPolicy;
import oracle.security.crypto.smime.ess.ReceiptRequest;
import oracle.security.crypto.smime.ess.SigningCertificate;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SmimeSignedReceipt
implements SmimeSignedObject {
    private ESSReceipt receipt;
    private boolean createReceipt;
    private CMSSignerInfo signerInfo;
    private ReceiptRequest receiptRequest;
    private Address[] receiptsToAddresses = null;
    private Vector signerSpecs;
    private CMSSignedDataContentInfo sd;
    private Vector certs;
    private Vector crls;
    private byte[] msgSigDigest;

    public SmimeSignedReceipt(SmimeSignedObject smimeSigned, X509Certificate signerCert, Address[] messageRecipientAddresses) throws InvalidInputException, ESSException {
        this(smimeSigned, signerCert, messageRecipientAddresses, null);
    }

    public SmimeSignedReceipt(SmimeSignedObject smimeSigned, X509Certificate signerCert, Address[] messageRecipientAddresses, MLExpansionHistory mlExpansionHistory) throws InvalidInputException, ESSException {
        MLData mlData;
        MLReceiptPolicy rcptPolicy;
        if (smimeSigned instanceof SmimeSignedReceipt) {
            throw new ESSException("smime message is a signed receipt");
        }
        if (smimeSigned instanceof SmimeSigned && ((SmimeSigned)smimeSigned).isSignedReceipt()) {
            throw new ESSException("smime message is a signed receipt");
        }
        if (messageRecipientAddresses == null || messageRecipientAddresses.length < 1) {
            throw new InvalidInputException("Recipient Address List can not be NULL or EMPTY");
        }
        this.createReceipt = true;
        CMSSignedDataContentInfo sdc = null;
        CMSDataContentInfo contentInfo = null;
        if (smimeSigned instanceof SmimeSigned) {
            sdc = ((SmimeSigned)smimeSigned).getSD();
            contentInfo = (CMSDataContentInfo)((SmimeSigned)smimeSigned).getCMSContentObject();
        } else if (smimeSigned instanceof SmimeMultipartSigned) {
            sdc = ((SmimeMultipartSigned)smimeSigned).getSD();
            contentInfo = (CMSDataContentInfo)((SmimeMultipartSigned)smimeSigned).getCMSContentObject();
        } else {
            throw new InvalidInputException("Unknown Signed Message Type");
        }
        if (!contentInfo.getContentType().equals((Object)CMS.id_data)) {
            throw new InvalidInputException("Invalid Signed Message Content Type: " + contentInfo.getContentType());
        }
        Enumeration signers = sdc.signers();
        Vector<ReceiptRequest> tmp = new Vector<ReceiptRequest>();
        while (signers.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)signers.nextElement();
            ReceiptRequest rcptReq = null;
            try {
                rcptReq = new ReceiptRequest(sigInfo);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (rcptReq != null) {
                tmp.addElement(rcptReq);
            }
            if (this.signerInfo != null || rcptReq == null) continue;
            try {
                sigInfo.verifySignature((CMSContentInfo)contentInfo, signerCert.getPublicKey());
                this.signerInfo = sigInfo;
                this.receiptRequest = rcptReq;
            }
            catch (AuthenticationException authenticationException) {
            }
            catch (SignatureException signatureException) {}
        }
        if (tmp.size() < 1 || this.receiptRequest == null) {
            throw new ESSException("No valid ReceiptRequests Found in Message");
        }
        for (int i = 1; i < tmp.size(); ++i) {
            if (((ReceiptRequest)tmp.elementAt(0)).equals((ReceiptRequest)tmp.elementAt(i))) continue;
            throw new ESSException("ReceiptRequests Found in Message MUST be Identical");
        }
        Vector receiptsTo = this.receiptRequest.getReceiptsTo();
        Vector<Object> rcptAddr = new Vector<Object>();
        for (int i = 0; i < receiptsTo.size(); ++i) {
            GeneralNames gns = (GeneralNames)receiptsTo.elementAt(i);
            try {
                Vector em = gns.getRFC822Names();
                for (int j = 0; em != null && j < em.size(); ++j) {
                    rcptAddr.addElement(new InternetAddress((String)em.elementAt(j)));
                }
                continue;
            }
            catch (AddressException ex) {
                throw new InvalidInputException(ex.toString());
            }
        }
        int mlReceiptPolicyType = -1;
        Vector mlReceiptNames = null;
        if (mlExpansionHistory != null && (rcptPolicy = (mlData = (MLData)mlExpansionHistory.getMLDatas().lastElement()).getMLReceiptPolicy()) != null) {
            mlReceiptPolicyType = rcptPolicy.getMLReceiptPolicyType().getType();
            if (mlReceiptPolicyType == MLReceiptPolicy.PolicyType.NONE.getType()) {
                throw new ESSException("No Receipts will be sent as Mail List Receipt Policy is NONE");
            }
            if (mlReceiptPolicyType != MLReceiptPolicy.PolicyType.INSTEAD_OF.getType() && mlReceiptPolicyType != MLReceiptPolicy.PolicyType.IN_ADDITION_TO.getType()) {
                throw new InvalidInputException("Unrecognized Mail Receipt Policy Tag: " + mlReceiptPolicyType);
            }
            mlReceiptNames = rcptPolicy.getReceiptNames();
        }
        if (this.receiptRequest.getAllOrFirstTier() != null) {
            if (this.receiptRequest.getAllOrFirstTier().equals(ReceiptRequest.AllOrFirstTier.ALL_RECIPIENTS)) {
                this.receipt = new ESSReceipt(CMS.id_data, this.receiptRequest.getSignedContentIdentifier(), this.signerInfo.getEncryptedDigest());
                this.sd = new CMSSignedDataContentInfo((CMSContentInfo)this.receipt);
                this.receiptsToAddresses = new Address[rcptAddr.size()];
                for (int z = 0; z < rcptAddr.size(); ++z) {
                    this.receiptsToAddresses[z] = (InternetAddress)rcptAddr.elementAt(z);
                }
                try {
                    MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)this.signerInfo.getDigestAlgID()));
                    this.msgSigDigest = md.digest(Utils.toBytes((Streamable)this.signerInfo.getSignedAttributes()));
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new InvalidInputException(ex.toString());
                }
                return;
            }
            if (this.receiptRequest.getAllOrFirstTier().equals(ReceiptRequest.AllOrFirstTier.FIRST_TIER_RECIPIENTS)) {
                if (mlExpansionHistory != null) {
                    throw new ESSException("Not a First Tier Recipient - MLExpansionHistory Present ");
                }
                this.receipt = new ESSReceipt(CMS.id_data, this.receiptRequest.getSignedContentIdentifier(), this.signerInfo.getEncryptedDigest());
                this.sd = new CMSSignedDataContentInfo((CMSContentInfo)this.receipt);
                this.receiptsToAddresses = new Address[rcptAddr.size()];
                for (int z = 0; z < rcptAddr.size(); ++z) {
                    this.receiptsToAddresses[z] = (InternetAddress)rcptAddr.elementAt(z);
                }
                try {
                    MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)this.signerInfo.getDigestAlgID()));
                    this.msgSigDigest = md.digest(Utils.toBytes((Streamable)this.signerInfo.getSignedAttributes()));
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new InvalidInputException(ex.toString());
                }
                return;
            }
            throw new ESSException("Unrecognized AllOrFirstTier in ReceiptsFrom field of ReceiptRequest: " + this.receiptRequest.getAllOrFirstTier().getValue());
        }
        Vector rl = this.receiptRequest.getReceiptList();
        if (rl == null || rl.size() < 1) {
            throw new ESSException("Missing/Empty ReceiptList in ReceiptsFrom field of ReceiptRequest: ");
        }
        boolean inRecipientList = false;
        for (int i = 0; !inRecipientList && i < rl.size(); ++i) {
            GeneralNames gns = (GeneralNames)rl.elementAt(i);
            Vector em = gns.getRFC822Names();
            for (int j = 0; em != null && !inRecipientList && j < em.size(); ++j) {
                if (!((InternetAddress)messageRecipientAddresses[j]).getAddress().equalsIgnoreCase((String)em.elementAt(j))) continue;
                inRecipientList = true;
            }
        }
        if (!inRecipientList) {
            throw new ESSException("Recipient not present in ReceiptList in ReceiptsFrom field of ReceiptRequest: ");
        }
        this.receipt = new ESSReceipt(CMS.id_data, this.receiptRequest.getSignedContentIdentifier(), this.signerInfo.getEncryptedDigest());
        this.sd = new CMSSignedDataContentInfo((CMSContentInfo)this.receipt);
        if (mlExpansionHistory != null) {
            Vector<InternetAddress> addr = new Vector<InternetAddress>();
            for (int i = 0; mlReceiptNames != null && i < mlReceiptNames.size(); ++i) {
                GeneralNames gns = (GeneralNames)mlReceiptNames.elementAt(i);
                Vector em = gns.getRFC822Names();
                for (int j = 0; em != null && j < em.size(); ++j) {
                    try {
                        addr.addElement(new InternetAddress((String)em.elementAt(j)));
                        continue;
                    }
                    catch (AddressException ex) {
                        throw new InvalidInputException(ex.toString());
                    }
                }
            }
            if (mlReceiptPolicyType == MLReceiptPolicy.PolicyType.INSTEAD_OF.getType()) {
                rcptAddr = addr;
            } else if (mlReceiptPolicyType == MLReceiptPolicy.PolicyType.IN_ADDITION_TO.getType()) {
                int vecSize = addr.size();
                for (int index = 0; index < vecSize; ++index) {
                    rcptAddr.addElement(addr.elementAt(index));
                }
            }
        }
        this.receiptsToAddresses = new Address[rcptAddr.size()];
        for (int z = 0; z < rcptAddr.size(); ++z) {
            this.receiptsToAddresses[z] = (InternetAddress)rcptAddr.elementAt(z);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)this.signerInfo.getDigestAlgID()));
            this.msgSigDigest = md.digest(Utils.toBytes((Streamable)this.signerInfo.getSignedAttributes()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public SmimeSignedReceipt(SmimeSignedObject smimeObj) throws InvalidInputException {
        if (!(smimeObj instanceof SmimeSigned && ((SmimeSigned)smimeObj).isSignedReceipt() || smimeObj instanceof SmimeSignedReceipt)) {
            throw new InvalidInputException("Expected signed receipt");
        }
        this.createReceipt = false;
        this.sd = smimeObj instanceof SmimeSigned ? ((SmimeSigned)smimeObj).getSD() : ((SmimeSignedReceipt)smimeObj).getSD();
        this.receipt = (ESSReceipt)this.sd.getEnclosed();
    }

    public SmimeSignedReceipt(ESSReceipt receipt, byte[] msgSigDigest, Address[] receiptsToAddresses) {
        this.createReceipt = true;
        this.receipt = receipt;
        this.msgSigDigest = msgSigDigest;
        this.receiptsToAddresses = receiptsToAddresses;
        this.sd = new CMSSignedDataContentInfo((CMSContentInfo)receipt);
    }

    SmimeSignedReceipt(CMSSignedDataContentInfo sd) throws InvalidInputException {
        this.sd = sd;
        if (!sd.getEnclosedContentType().equals((Object)CMS.id_ct_receipt)) {
            throw new InvalidInputException("expected signed receipt");
        }
        this.receipt = (ESSReceipt)sd.getEnclosed();
        this.createReceipt = false;
    }

    public SmimeSignedReceipt(InputStream is) throws IOException {
        this(new CMSSignedDataContentInfo(is));
    }

    public void addCertificate(X509Certificate cert) {
        this.sd.addCertificate(cert);
    }

    public void addCRL(CRL crl) {
        this.sd.addCRL(crl);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateEncodingException {
        this.addSignature(signerKey, signerCert, digestAlgID, (AttributeSet)null);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, Date timeStamp) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateEncodingException {
        this.addSignature(signerKey, signerCert, digestAlgID, timeStamp, null);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, SmimeCapabilities smimeCaps) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateEncodingException {
        this.addSignature(signerKey, signerCert, digestAlgID, null, smimeCaps);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, Date timeStamp, SmimeCapabilities smimeCaps) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateEncodingException {
        AttributeSet authAttribs = null;
        if (timeStamp != null || smimeCaps != null) {
            authAttribs = new AttributeSet();
            if (timeStamp != null) {
                authAttribs.addAttribute(CMS.id_signingTime, (ASN1Object)new ASN1Date(timeStamp));
            }
            if (smimeCaps != null) {
                authAttribs.addAttribute(Smime.smimeCapabilities, (ASN1Object)smimeCaps);
            }
        }
        this.addSignature(signerKey, signerCert, digestAlgID, authAttribs);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AttributeSet signedAttributes) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateEncodingException {
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)digestAlgID)));
        signature.initSign(signerKey);
        AlgorithmIdentifier digestEncryptionAlgID = CMSUtils.getAlgoID((String)signerKey.getAlgorithm());
        AttributeSet authAttribs = (AttributeSet)signedAttributes.clone();
        authAttribs.addAttribute(Smime.id_aa_msgSigDigest, (ASN1Object)new ASN1OctetString(this.msgSigDigest));
        this.sd.addSignature(authAttribs, signerKey, signerCert, digestAlgID, digestEncryptionAlgID, null);
    }

    CMSSignedDataContentInfo getSD() {
        return this.sd;
    }

    public Address[] getReceiptsToAddresses() {
        return this.receiptsToAddresses;
    }

    public ESSReceipt getEnclosedReceipt() {
        return this.receipt;
    }

    @Override
    public MimeBodyPart getEnclosedBodyPart() throws InvalidInputException, MessagingException {
        return new MimeBodyPart((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)this.receipt)));
    }

    @Override
    public Vector getCertificates() {
        if (this.sd == null) {
            return null;
        }
        return this.sd.getCertificates();
    }

    @Override
    public Vector getCRLs() {
        if (this.sd == null) {
            return null;
        }
        return this.sd.getCRLs();
    }

    @Override
    public Enumeration signers() {
        if (this.sd == null) {
            return null;
        }
        return this.sd.signers();
    }

    @Override
    public void verifySignature(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sd.verifySignature(signerCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verifySignature(X509Certificate signerCert, Address[] senderAddresses) throws AuthenticationException, SignatureException {
        if (senderAddresses == null) {
            throw new AuthenticationException("No 'sender' or 'from' addresses found.");
        }
        SmimeUtils.checkEmailAddress(signerCert, senderAddresses);
        try {
            this.sd.verifySignature(signerCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy) throws AuthenticationException {
        this.sd.verify(trustPolicy);
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy, Address[] senderAddresses) throws AuthenticationException {
        this.sd.verify((CertificateTrustPolicy)new MailTrustPolicy(trustPolicy, senderAddresses));
    }

    public void verifyReceipt(SmimeSignedObject originalSmimeSignedObject, X509Certificate signerCert) throws AuthenticationException {
        if (this.createReceipt) {
            throw new AuthenticationException("not allowed: receipt is being created");
        }
        ReceiptRequest receiptRequest = null;
        byte[] osv = null;
        byte[] origMsgSigDigest = null;
        Enumeration e = originalSmimeSignedObject.signers();
        while (receiptRequest == null && e.hasMoreElements()) {
            CMSSignerInfo sii = (CMSSignerInfo)e.nextElement();
            try {
                receiptRequest = new ReceiptRequest(sii);
                osv = sii.getEncryptedDigest();
                try {
                    MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)sii.getDigestAlgID()));
                    origMsgSigDigest = md.digest(Utils.toBytes((Streamable)sii.getSignedAttributes()));
                }
                catch (NoSuchAlgorithmException md) {
                    // empty catch block
                }
                if (Utils.areEqual((byte[])receiptRequest.getSignedContentIdentifier(), (byte[])this.receipt.getSignedContentIdentifier())) continue;
                receiptRequest = null;
                osv = null;
                origMsgSigDigest = null;
            }
            catch (InvalidInputException md) {}
        }
        if (receiptRequest == null) {
            throw new AuthenticationException("The receipt received and the receipt request contained in the original SmimeSignedObject do not correspond i.e. signed content identifier do not match");
        }
        try {
            IssuerAndSerialNo iasn = new IssuerAndSerialNo(new X509(signerCert.getEncoded()));
            CMSSignerInfo si = null;
            Enumeration e2 = this.sd.signers();
            while (e2.hasMoreElements()) {
                CMSSignerInfo tmp = (CMSSignerInfo)e2.nextElement();
                if (!tmp.getIssuer().equals((Object)iasn.getIssuer()) || !tmp.getSerialNo().equals(iasn.getSerialNo())) continue;
                si = tmp;
            }
            if (si == null) {
                throw new AuthenticationException("signer is unknown");
            }
            try {
                si.verifySignature(this.sd.getEnclosed(), signerCert.getPublicKey());
            }
            catch (Exception ex) {
                throw new AuthenticationException("Unable to verify Receipt Signature:  " + ex.toString());
            }
            if (!((SmimeSigned)originalSmimeSignedObject).getSD().getEnclosedContentType().equals((Object)this.receipt.getReceiptContentType())) {
                throw new AuthenticationException("The receipt received and the receipt request contained in the original SmimeSignedObject do not have matching Content Type Values");
            }
            if (!Utils.areEqual((byte[])osv, (byte[])this.receipt.getOriginatorSignatureValue())) {
                throw new AuthenticationException("The receipt received and the receipt request contained in the original SmimeSignedObject do not have matching Originator Signature Values");
            }
            Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_msgSigDigest);
            if (vals == null) {
                throw new AuthenticationException("SignedAttribute msgSigDigest Values is NULL");
            }
            if (vals.getValues().size() != 1) {
                throw new AuthenticationException("SignedAttribute msgSigDigest Must Be Single Valued");
            }
            byte[] msgSigDigest0 = ((ASN1OctetString)vals.getValues().elementAt(0)).getValue();
            if (!Utils.areEqual((byte[])msgSigDigest0, (byte[])origMsgSigDigest)) {
                throw new AuthenticationException("The receipt received and the receipt request contained in the original SmimeSignedObject do not have matching msgSigDigest Values");
            }
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public ESSSecurityLabel getESSSecurityLabel(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ESSSecurityLabel vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new ESSSecurityLabel(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ESSSecurityLabel's with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ESSSecurityLabel sl = new ESSSecurityLabel(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ESSSecurityLabels MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public EquivalentLabels getEquivalentLabels(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        EquivalentLabels vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new EquivalentLabels(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find EquivalentLabels with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                EquivalentLabels sl = new EquivalentLabels(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("EquivalentLabels MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public SigningCertificate getSigningCertificate(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            SigningCertificate vsl = new SigningCertificate(sigInfo);
            return vsl;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find SigningCertificate with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public MLExpansionHistory getMLExpansionHistory(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        MLExpansionHistory vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new MLExpansionHistory(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find MLExpansionHistory's with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                MLExpansionHistory sl = new MLExpansionHistory(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("MLExpansionHistory MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public ReceiptRequest getReceiptRequest(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ReceiptRequest vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new ReceiptRequest(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ReceiptRequest's with Verifiable Signature" + ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ReceiptRequest sl = new ReceiptRequest(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ReceiptRequest MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public String generateContentType(boolean useStandardContentTypes) {
        if (useStandardContentTypes) {
            return "application/pkcs7-mime; smime-type=signed-receipt";
        }
        return "application/x-pkcs7-mime; smime-type=signed-receipt";
    }

    @Override
    public String generateContentType() {
        return this.generateContentType(true);
    }

    @Override
    public void writeTo(OutputStream os, String mimeType) throws IOException, MessagingException {
        this.sd.output(os);
    }
}

