/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.BodyPartUpdater;
import oracle.security.crypto.smime.MailTrustPolicy;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.SmimeCapabilities;
import oracle.security.crypto.smime.SmimeSigned;
import oracle.security.crypto.smime.SmimeSignedObject;
import oracle.security.crypto.smime.SmimeUtils;
import oracle.security.crypto.smime.ess.ESSSecurityLabel;
import oracle.security.crypto.smime.ess.EquivalentLabels;
import oracle.security.crypto.smime.ess.MLExpansionHistory;
import oracle.security.crypto.smime.ess.ReceiptRequest;
import oracle.security.crypto.smime.ess.SigningCertificate;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class SmimeMultipartSigned
extends MimeMultipart
implements SmimeSignedObject {
    private CMSDataContentInfo data;
    private CMSSignedDataContentInfo sig;
    private AlgorithmIdentifier digestAlgID;
    private String micalg;

    public SmimeMultipartSigned(MimeBodyPart bodyPart, AlgorithmIdentifier digestAlgID) throws MessagingException {
        new BodyPartUpdater(bodyPart);
        SmimeUtils.canonicalize((MimePart)bodyPart);
        UnsyncByteArrayOutputStream bp_store = new UnsyncByteArrayOutputStream();
        try {
            bodyPart.writeTo((OutputStream)bp_store);
        }
        catch (IOException ex) {
            throw new MessagingException("Unexpected I/O exception", (Exception)ex);
        }
        this.data = new CMSDataContentInfo(bp_store.toByteArray());
        this.sig = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo());
        this.digestAlgID = digestAlgID;
        this.micalg = digestAlgID.getOID().equals((Object)Smime.md5.getOID()) ? "md5" : (digestAlgID.getOID().equals((Object)Smime.sha_1.getOID()) ? "sha-1" : (digestAlgID.getOID().equals((Object)Smime.sha_256.getOID()) ? "sha-256" : (digestAlgID.getOID().equals((Object)Smime.sha_384.getOID()) ? "sha-384" : (digestAlgID.getOID().equals((Object)Smime.sha_512.getOID()) ? "sha-512" : null))));
    }

    public SmimeMultipartSigned(DataSource ds) throws MessagingException, IOException {
        super(ds);
        if (this.getCount() != 2) {
            throw new InvalidInputException("Wrong number of body parts for multipart/signed.");
        }
        ContentType sigPartType = new ContentType(this.getBodyPart(1).getContentType());
        if (!sigPartType.match("application/pkcs7-signature") && !sigPartType.match("application/x-pkcs7-signature")) {
            throw new InvalidInputException("Signature has unrecognized content type (" + sigPartType + ").");
        }
        UnsyncByteArrayOutputStream bp_store = new UnsyncByteArrayOutputStream();
        this.getBodyPart(0).writeTo((OutputStream)bp_store);
        this.data = new CMSDataContentInfo(bp_store.toByteArray());
        try {
            this.sig = ((SmimeSigned)this.getBodyPart(1).getContent()).getSD();
        }
        catch (ClassCastException ex) {
            throw new MessagingException("Installed data handler generates invalid content.");
        }
    }

    CMSSignedDataContentInfo getSD() {
        return this.sig;
    }

    CMSContentInfo getCMSContentObject() {
        return this.data;
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert) throws NoSuchAlgorithmException, InvalidKeyException, IOException, CertificateEncodingException, SignatureException {
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)this.digestAlgID)));
        signature.initSign(signerKey);
        this.sig.addSignerInfo(signerCert, new CMSSignerInfo((CMSContentInfo)this.data, null, signerKey, signerCert, this.digestAlgID, CMSUtils.getAlgoID((String)signerKey.getAlgorithm()), null));
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, Date timeStamp) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, CertificateEncodingException {
        AttributeSet authAttribs = new AttributeSet();
        authAttribs.addAttribute(CMS.id_signingTime, (ASN1Object)new ASN1Date(timeStamp));
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)this.digestAlgID)));
        signature.initSign(signerKey);
        this.sig.addSignerInfo(signerCert, new CMSSignerInfo((CMSContentInfo)this.data, authAttribs, signerKey, signerCert, this.digestAlgID, CMSUtils.getAlgoID((String)signerKey.getAlgorithm()), null));
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, SmimeCapabilities smimeCaps) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, CertificateEncodingException {
        AttributeSet authAttribs = new AttributeSet();
        authAttribs.addAttribute(Smime.smimeCapabilities, (ASN1Object)smimeCaps);
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)this.digestAlgID)));
        signature.initSign(signerKey);
        this.sig.addSignerInfo(signerCert, new CMSSignerInfo((CMSContentInfo)this.data, authAttribs, signerKey, signerCert, this.digestAlgID, CMSUtils.getAlgoID((String)signerKey.getAlgorithm()), null));
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, Date timeStamp, SmimeCapabilities smimeCaps) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, CertificateEncodingException {
        AttributeSet authAttribs = new AttributeSet();
        authAttribs.addAttribute(CMS.id_signingTime, (ASN1Object)new ASN1Date(timeStamp));
        authAttribs.addAttribute(Smime.smimeCapabilities, (ASN1Object)smimeCaps);
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)this.digestAlgID)));
        signature.initSign(signerKey);
        this.sig.addSignerInfo(signerCert, new CMSSignerInfo((CMSContentInfo)this.data, authAttribs, signerKey, signerCert, this.digestAlgID, CMSUtils.getAlgoID((String)signerKey.getAlgorithm()), null));
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AttributeSet signedAttributes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, CertificateEncodingException {
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)digestAlgID)));
        signature.initSign(signerKey);
        this.sig.addSignerInfo(signerCert, new CMSSignerInfo((CMSContentInfo)this.data, signedAttributes, signerKey, signerCert, digestAlgID, CMSUtils.getAlgoID((String)signerKey.getAlgorithm()), null));
    }

    public void addCertificate(X509Certificate cert) {
        this.sig.addCertificate(cert);
    }

    public void addCRL(CRL crl) {
        this.sig.addCRL(crl);
    }

    @Override
    public MimeBodyPart getEnclosedBodyPart() throws InvalidInputException, MessagingException {
        return (MimeBodyPart)this.getBodyPart(0);
    }

    @Override
    public Enumeration signers() {
        return this.sig.signers();
    }

    @Override
    public Vector getCertificates() {
        return this.sig.getCertificates();
    }

    @Override
    public Vector getCRLs() {
        return this.sig.getCRLs();
    }

    @Override
    public void verifySignature(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verifySignature(X509Certificate signerCert, Address[] senderAddresses) throws AuthenticationException, SignatureException {
        if (senderAddresses == null) {
            throw new AuthenticationException("No 'sender' or 'from' addresses found.");
        }
        SmimeUtils.checkEmailAddress(signerCert, senderAddresses);
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy) throws AuthenticationException {
        this.sig.verify(trustPolicy, (CMSContentInfo)this.data);
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy, Address[] senderAddresses) throws AuthenticationException {
        this.sig.verify((CertificateTrustPolicy)new MailTrustPolicy(trustPolicy, senderAddresses), (CMSContentInfo)this.data);
    }

    @Override
    public ESSSecurityLabel getESSSecurityLabel(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ESSSecurityLabel vsl = null;
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
            CMSSignerInfo sigInfo = this.sig.getSignerInfo(signerCert);
            vsl = new ESSSecurityLabel(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ESSSecurityLabel with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sig.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ESSSecurityLabel sl = new ESSSecurityLabel(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ESSSecurityLabels MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public EquivalentLabels getEquivalentLabels(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        EquivalentLabels vsl = null;
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
            CMSSignerInfo sigInfo = this.sig.getSignerInfo(signerCert);
            vsl = new EquivalentLabels(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find EquivalentLabels with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sig.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                EquivalentLabels sl = new EquivalentLabels(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("EquivalentLabels MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public SigningCertificate getSigningCertificate(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
            CMSSignerInfo sigInfo = this.sig.getSignerInfo(signerCert);
            SigningCertificate vsl = new SigningCertificate(sigInfo);
            return vsl;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find SigningCertificate with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public MLExpansionHistory getMLExpansionHistory(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        MLExpansionHistory vsl = null;
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
            CMSSignerInfo sigInfo = this.sig.getSignerInfo(signerCert);
            vsl = new MLExpansionHistory(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find MLExpansionHistory with Verifiable Signature");
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sig.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                MLExpansionHistory sl = new MLExpansionHistory(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("MLExpansionHistory's MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public ReceiptRequest getReceiptRequest(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ReceiptRequest vsl = null;
        try {
            this.sig.verifySignature(signerCert, (CMSContentInfo)this.data);
            CMSSignerInfo sigInfo = this.sig.getSignerInfo(signerCert);
            vsl = new ReceiptRequest(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ReceiptRequest with Verifiable Signature" + ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sig.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ReceiptRequest sl = new ReceiptRequest(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ReceiptRequest's MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public String generateContentType(boolean useStandardContentTypes) {
        if (useStandardContentTypes) {
            return this.makeContentTypeUsingSHA1AsDigestAlgorithm("application/pkcs7-signature");
        }
        return this.makeContentTypeUsingSHA1AsDigestAlgorithm("application/x-pkcs7-signature");
    }

    @Override
    public String generateContentType() {
        return this.generateContentType(true);
    }

    public String generateContentType(boolean useStandardContentTypes, AlgorithmIdentifier digestAlgId) throws NoSuchAlgorithmException {
        if (useStandardContentTypes) {
            return this.makeContentTypeUsingGivenDigestAlgorithm("application/pkcs7-signature", digestAlgId);
        }
        return this.makeContentTypeUsingGivenDigestAlgorithm("application/x-pkcs7-signature", digestAlgId);
    }

    public String generateContentType(AlgorithmIdentifier digestAlgId) throws NoSuchAlgorithmException {
        return this.generateContentType(true, digestAlgId);
    }

    public String getContentType() {
        return this.generateContentType();
    }

    private String makeContentTypeUsingSHA1AsDigestAlgorithm(String protocol) {
        byte[] digest = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)CMS.sha_1));
            digest = sha.digest(this.data.getData());
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                digest = md.digest(this.data.getData());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.makeContentTypeCommon(protocol, digest);
    }

    private String makeContentTypeUsingGivenDigestAlgorithm(String protocol, AlgorithmIdentifier digestAlgId) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)digestAlgId));
        byte[] digest = sha.digest(this.data.getData());
        return this.makeContentTypeCommon(protocol, digest);
    }

    private String makeContentTypeCommon(String protocol, byte[] digest) {
        StringBuffer sb = new StringBuffer("multipart/signed; protocol=\"");
        sb.append(protocol);
        sb.append("\";\r\n");
        if (this.micalg != null) {
            sb.append("     micalg=");
            sb.append(this.micalg);
            sb.append(";\r\n");
        }
        sb.append(" boundary=\"SMS:");
        sb.append(Utils.toBase64((byte[])digest, (boolean)false));
        sb.append('\"');
        return sb.toString();
    }

    protected void updateHeaders() {
    }

    @Override
    public void writeTo(OutputStream os, String contentType) throws IOException, MessagingException {
        ContentType ct = new ContentType(contentType);
        String protocol = ct.getParameter("protocol");
        byte[] boundary = new StringBuffer("--").append(ct.getParameter("boundary")).toString().getBytes("ASCII");
        byte[] eol = "\r\n".getBytes("ASCII");
        os.write(boundary);
        os.write(eol);
        os.write(this.data.getData());
        os.write(eol);
        os.write(boundary);
        os.write(eol);
        os.write(new StringBuffer("Content-Type: ").append(protocol).toString().getBytes("ASCII"));
        os.write(eol);
        os.write("Content-Transfer-Encoding: base64".getBytes("ASCII"));
        os.write(eol);
        os.write(eol);
        os.write(Utils.toBase64((byte[])Utils.toBytes((Streamable)this.sig), (String)"\r\n").getBytes("ASCII"));
        os.write(boundary);
        os.write("--".getBytes("ASCII"));
        os.write(eol);
    }
}

