/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSEnvelopedDataContentInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.UnknownRecipientException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.smime.BodyPartUpdater;
import oracle.security.crypto.smime.SmimeObject;
import oracle.security.crypto.smime.SmimeUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class SmimeEnveloped
implements SmimeObject {
    private CMSEnvelopedDataContentInfo ed;

    SmimeEnveloped(CMSEnvelopedDataContentInfo ed) {
        this.ed = ed;
    }

    public SmimeEnveloped(MimeBodyPart content, AlgorithmIdentifier contentEncryptionAlgID) throws MessagingException, IOException {
        if (content == null) {
            throw new InvalidInputException("message content is empty");
        }
        new BodyPartUpdater(content);
        byte[] dc = SmimeUtils.toBytes(content);
        if (dc == null || dc.length < 1) {
            throw new InvalidInputException("message content is empty");
        }
        try {
            this.ed = new CMSEnvelopedDataContentInfo((CMSContentInfo)new CMSDataContentInfo(dc), contentEncryptionAlgID);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (IllegalBlockSizeException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (BadPaddingException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (NoSuchPaddingException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public SmimeEnveloped(InputStream is) throws IOException {
        this.ed = new CMSEnvelopedDataContentInfo(is);
    }

    CMSEnvelopedDataContentInfo getED() {
        return this.ed;
    }

    public MimeBodyPart getEnclosedBodyPart(PrivateKey recipientKey, X509Certificate recipientCert) throws NoSuchAlgorithmException, InvalidKeyException, UnknownRecipientException, IOException, CertificateEncodingException, InvalidInputException, MessagingException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException {
        CMSDataContentInfo data;
        try {
            data = (CMSDataContentInfo)this.ed.getEnclosed(recipientKey, recipientCert);
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException("Content-type 'data' expected");
        }
        return new MimeBodyPart((InputStream)new UnsyncByteArrayInputStream(data.getData()));
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() {
        return this.ed.getContentEncryptionAlgID();
    }

    public Enumeration recipients() {
        if (this.ed == null) {
            return null;
        }
        return this.ed.recipients();
    }

    public byte[] getEncryptedContent() {
        return this.ed.getEncryptedContent();
    }

    @Override
    public String generateContentType(boolean useStandardContentTypes) {
        if (useStandardContentTypes) {
            return "application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"";
        }
        return "application/x-pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"";
    }

    @Override
    public String generateContentType() {
        return this.generateContentType(true);
    }

    public void addRecipient(X509Certificate cert) throws NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, InvalidKeyException, CertificateEncodingException, IOException {
        this.ed.addRecipient(cert, CMSUtils.getAlgoID((String)cert.getPublicKey().getAlgorithm()));
    }

    public void addRecipient(X509Certificate cert, AlgorithmIdentifier keyEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, CertificateEncodingException, IOException {
        this.ed.addRecipient(cert, keyEncryptionAlgID);
    }

    @Override
    public void writeTo(OutputStream os, String mimeType) throws IOException, MessagingException {
        this.ed.output(os);
    }
}

