/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class ClassUtils {
    public static boolean isInstanceOf(Class derivedClass, String parentName) {
        for (Class clazz = derivedClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz.getName().equals(parentName)) {
                return true;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces == null) continue;
            for (Class<?> interfaceClazz : interfaces) {
                if (!ClassUtils.isInstanceOf(interfaceClazz, parentName)) continue;
                return true;
            }
        }
        return false;
    }

    public static int instanceOfDepth(Class derivedClass, String parentName) {
        return ClassUtils._instanceOfDepth(derivedClass, parentName, 0);
    }

    private static int _instanceOfDepth(Class derivedClass, String parentName, int depth) {
        Class clazz = derivedClass;
        while (clazz != null) {
            if (clazz.getName().equals(parentName)) {
                return depth;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                for (Class<?> interfaceClazz : interfaces) {
                    int interfaceDepth = ClassUtils._instanceOfDepth(interfaceClazz, parentName, depth + 1);
                    if (interfaceDepth == -1) continue;
                    return interfaceDepth;
                }
            }
            clazz = clazz.getSuperclass();
            ++depth;
        }
        return -1;
    }
}

