/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.accessibility.AccessibleState;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.resource.ADABundle;
import oracle.ide.util.TriStateBoolean;

public class CheckBoxList
extends JList {
    private CheckBoxListCellRenderer _listCellRenderer = new CheckBoxListCellRenderer();
    private CheckBoxListListener _listListener = new CheckBoxListListener();
    private boolean _trackingKeyboard = false;

    public CheckBoxList() {
        this(new CheckBoxListModel());
    }

    public CheckBoxList(CheckBoxListModel model) {
        super(model);
        this.addMouseListener(this._listListener);
        this.setCellRenderer(this._listCellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public CheckBoxList(Object[] userObjects) {
        this(new CheckBoxListModel(userObjects));
    }

    public CheckBoxList(Object[] userObjects, Icon icon, boolean hasCheckBox) {
        this(new CheckBoxListModel(userObjects, icon, hasCheckBox));
    }

    public CheckBoxList(Object[] userObjects, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this(new CheckBoxListModel(userObjects, icon, hasCheckBox, checkBoxState));
    }

    public CheckBoxList(Object[] userObjects, boolean hasCheckBox) {
        this(new CheckBoxListModel(userObjects, hasCheckBox));
    }

    public CheckBoxList(Object[] userObjects, boolean hasCheckBox, boolean checkBoxState) {
        this(new CheckBoxListModel(userObjects, hasCheckBox, checkBoxState));
    }

    public CheckBoxListModel getCheckBoxListModel() {
        return (CheckBoxListModel)this.getModel();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this._trackingKeyboard && e.getKeyCode() == 27) {
            this._trackingKeyboard = false;
            this._listListener.keyReleaseRow(this, -1);
            return;
        }
        if (e.getKeyCode() != 32) {
            super.processKeyEvent(e);
            return;
        }
        int row = this._listCellRenderer.getLastRowWithFocus();
        if (row < 0) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                if (this._trackingKeyboard) break;
                this._trackingKeyboard = true;
                this._listListener.keyPressRow(this, row);
                break;
            }
            case 402: {
                if (!this._trackingKeyboard) break;
                this._trackingKeyboard = false;
                this._listListener.keyReleaseRow(this, row);
                break;
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int index = this.locationToIndex(p);
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        if (index >= 0 && index < model.getSize()) {
            return model.getToolTipTextForElement(index);
        }
        return "";
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (this._trackingKeyboard && e.getSource() == this) {
            this._trackingKeyboard = false;
            this._listListener.keyReleaseRow(this, -1);
        }
        if (e.getSource() == this && e.getID() == 1004 && e.getOppositeComponent() instanceof JLabel && !e.isTemporary() && this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        super.processFocusEvent(e);
    }

    private static void forceCheckboxADARead(JList list, CheckBoxListCellData listCellData) {
        TriStateBoolean checkBoxState = listCellData.getCheckBoxState();
        boolean cbSelected = false;
        if (!checkBoxState.isTriState()) {
            cbSelected = checkBoxState.booleanValue();
        }
        String notChecked = ADABundle.get("ADA_UNCHECKED_STATE");
        list.getAccessibleContext().firePropertyChange("AccessibleDescription", cbSelected ? notChecked : AccessibleState.CHECKED.toDisplayString(), cbSelected ? AccessibleState.CHECKED.toDisplayString() : notChecked);
    }

    private static class CheckBoxListListener
    implements MouseListener,
    MouseMotionListener {
        private boolean _isArmed = false;
        private long _pressedTime = -1L;
        private int _pressedRow = -1;
        private int _checkBoxWidth = -1;
        private boolean _trackingMousePress = false;
        private boolean _trackingKeyPress = false;
        private static final int BOUNCE_TIME = 150;

        private CheckBoxListListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this._trackingKeyPress) {
                if (SwingUtilities.isRightMouseButton(e) || SwingUtilities.isMiddleMouseButton(e)) {
                    this.mouseReleased(e);
                }
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this._pressedTime = e.getWhen();
            CheckBoxList list = (CheckBoxList)e.getComponent();
            this.pressRow(list, this.getCurrentRow(e));
            if (this._pressedRow >= 0) {
                this._trackingMousePress = true;
                list.addMouseMotionListener(this);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._trackingKeyPress) {
                return;
            }
            long releasedTime = e.getWhen();
            CheckBoxList list = (CheckBoxList)e.getComponent();
            this.releaseRow(list, this.getCurrentRow(e), releasedTime);
            this._trackingMousePress = false;
            list.removeMouseMotionListener(this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._pressedRow == -1) {
                return;
            }
            int currentRow = this.getCurrentRow(e);
            if (currentRow != this._pressedRow && this._isArmed || currentRow == this._pressedRow && !this._isArmed) {
                CheckBoxList list = (CheckBoxList)e.getComponent();
                CheckBoxListCellData listCellData = (CheckBoxListCellData)list.getModel().getElementAt(this._pressedRow);
                this._isArmed = currentRow == this._pressedRow;
                listCellData.setArmed(this._isArmed);
                Rectangle r = list.getCellBounds(this._pressedRow, this._pressedRow);
                list.repaint(r.x, r.y, r.width, r.height);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        void keyPressRow(CheckBoxList list, int row) {
            if (this._trackingMousePress || this._trackingKeyPress) {
                return;
            }
            this._trackingKeyPress = true;
            this.pressRow(list, row);
        }

        void keyReleaseRow(CheckBoxList list, int row) {
            if (this._trackingMousePress || !this._trackingKeyPress) {
                return;
            }
            this._trackingKeyPress = false;
            this.releaseRow(list, row, 0L);
        }

        private void pressRow(CheckBoxList list, int row) {
            if (row < 0) {
                this._pressedRow = -1;
                return;
            }
            if (this._pressedRow >= 0) {
                throw new IllegalStateException("Can't invoke pressRow() when a different row is already being pressed");
            }
            CheckBoxListCellData listCellData = (CheckBoxListCellData)list.getModel().getElementAt(row);
            boolean hasCheckBox = listCellData.getHasCheckBox();
            boolean isCheckBoxSelectable = listCellData.isCheckBoxSelectable();
            if (!hasCheckBox || !isCheckBoxSelectable) {
                this._pressedRow = -1;
                return;
            }
            this._isArmed = true;
            listCellData.setArmed(true);
            listCellData.setPressed(true);
            CheckBoxList.forceCheckboxADARead(list, listCellData);
            this._pressedRow = row;
            Rectangle r = list.getCellBounds(this._pressedRow, this._pressedRow);
            list.repaint(r.x, r.y, r.width, r.height);
        }

        private void releaseRow(CheckBoxList list, int row, long releasedTime) {
            this._checkBoxWidth = -1;
            this._isArmed = false;
            if (this._pressedRow < 0) {
                this._pressedTime = -1L;
                return;
            }
            long diffTime = releasedTime > 0L ? releasedTime - this._pressedTime : 0L;
            CheckBoxListCellData pressedData = (CheckBoxListCellData)list.getModel().getElementAt(this._pressedRow);
            pressedData.setPressed(false);
            pressedData.setArmed(false);
            if (row >= 0 && (this._pressedRow == row || diffTime <= 150L)) {
                TriStateBoolean checkBoxState = pressedData.getCheckBoxState();
                TriStateBoolean newCheckBoxState = checkBoxState.toggle();
                pressedData.setCheckBoxState(newCheckBoxState);
            }
            list.repaint();
            this._pressedRow = -1;
        }

        private int getCurrentRow(MouseEvent e) {
            int y;
            int x;
            CheckBoxList list = (CheckBoxList)e.getComponent();
            int row = list.locationToIndex(new Point(x = e.getX(), y = e.getY()));
            if (row < 0) {
                return -1;
            }
            if (this._checkBoxWidth < 0) {
                Object value = list.getModel().getElementAt(row);
                ListCellRenderer lcr = list.getCellRenderer();
                Component component = lcr.getListCellRendererComponent(list, value, row, true, true);
                this._checkBoxWidth = component instanceof JLabeledCheckBox ? ((JLabeledCheckBox)component).checkBox.getWidth() : 0;
            }
            Rectangle cellBounds = list.getCellBounds(row, row);
            if (x > cellBounds.x + this._checkBoxWidth) {
                return -1;
            }
            return row;
        }
    }

    private static class CheckBoxListCellRenderer
    extends DefaultListCellRenderer {
        protected int _lastRowWithFocus = -1;
        protected String _selText = null;
        private JLabeledCheckBox _lcb = new JLabeledCheckBox();
        private JSelectableLabel _sl = new JSelectableLabel();

        private CheckBoxListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean hasCheckBox;
            if (cellHasFocus) {
                this._lastRowWithFocus = index;
            }
            if (!(value instanceof CheckBoxListCellData)) {
                return this;
            }
            CheckBoxListCellData listCellData = (CheckBoxListCellData)value;
            if (listCellData == null) {
                return this;
            }
            if (cellHasFocus) {
                this._selText = listCellData.getText();
            }
            if (hasCheckBox = listCellData.getHasCheckBox()) {
                this._lcb.checkBox.setBorderPaintedFlat(true);
                if (listCellData.getGroupId() != null && !listCellData.isGroupTitle()) {
                    this._lcb.increaseLeftMargin();
                } else {
                    this._lcb.decreaseLeftMargin();
                }
                this._lcb.label.setHeightAdjustment(listCellData.getHeightAdjustment());
                if (!list.isEnabled()) {
                    this._lcb.label.setEnabled(false);
                    this._lcb.checkBox.setEnabled(false);
                } else {
                    this._lcb.label.setEnabled(listCellData.isTextEnabled());
                    this._lcb.checkBox.setEnabled(listCellData.isCheckBoxEnabled());
                }
                this._lcb.label.setSelected(isSelected);
                this._lcb.label.setText(listCellData.getText());
                this._lcb.label.setIcon(listCellData.getIcon());
                this._lcb.label.setHasFocus(cellHasFocus);
                this._lcb.setToolTipText(listCellData.getToolTipText());
                this._lcb.getAccessibleContext().setAccessibleName(listCellData.getText());
                TriStateBoolean checkBoxState = listCellData.getCheckBoxState();
                boolean cbSelected = false;
                if (!checkBoxState.isTriState()) {
                    cbSelected = checkBoxState.booleanValue();
                }
                if (cellHasFocus) {
                    this._lcb.getAccessibleContext().firePropertyChange("AccessibleState", cbSelected ? null : AccessibleState.CHECKED, cbSelected ? AccessibleState.CHECKED : null);
                    CheckBoxList.forceCheckboxADARead(list, listCellData);
                }
                ButtonModel bm = this._lcb.checkBox.getModel();
                if (!checkBoxState.isTriState()) {
                    this._lcb.checkBox.setSelected(checkBoxState.booleanValue());
                    bm.setArmed(listCellData.isArmed());
                    bm.setPressed(listCellData.isPressed());
                } else if (listCellData.isArmed() && listCellData.isPressed()) {
                    this._lcb.checkBox.setSelected(true);
                    bm.setArmed(true);
                    bm.setPressed(true);
                } else {
                    this._lcb.checkBox.setSelected(true);
                    this._lcb.checkBox.setEnabled(false);
                }
                return this._lcb;
            }
            this._sl.setHeightAdjustment(listCellData.getHeightAdjustment());
            this._sl.setEnabled(list.isEnabled() ? listCellData.isTextEnabled() : false);
            this._sl.setSelected(isSelected);
            this._sl.setText(listCellData.getText());
            this._sl.getAccessibleContext().setAccessibleName(listCellData.getText());
            this._sl.setIcon(listCellData.getIcon());
            this._sl.setHasFocus(cellHasFocus);
            this._sl.setToolTipText(listCellData.getToolTipText());
            return this._sl;
        }

        public int getLastRowWithFocus() {
            return this._lastRowWithFocus;
        }

        @Override
        public String getText() {
            return this._selText != null ? this._selText : super.getText();
        }
    }
}

