/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaitCursor {
    private static final int DEFAULT_DELAY = 500;
    private static Boolean _suppressWaitCursor = Boolean.valueOf(System.getProperty("oracle.ide.SuppressWaitCursor", "false"));
    private static final MouseAdapter BEEPER = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private static Object _monitor = new Object();
    private static final Timer _timer = new Timer("WaitCursor-Timer");
    private static ReferenceCountedHashMap _components = new ReferenceCountedHashMap();
    private static Stack<SessionList<Component>> _stack = new Stack();

    @Deprecated
    public WaitCursor() {
    }

    public WaitCursor(Component component) {
        if (component == null) {
            return;
        }
        this.attach(this.findRootPaneContainer(component));
    }

    @Deprecated
    protected final RootPaneContainer findRootPaneContainer(Component component) {
        if (component instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)component);
        }
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
    }

    @Deprecated
    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void attach(RootPaneContainer rootPaneContainer) {
        Component glassPane;
        if (rootPaneContainer != null && (glassPane = rootPaneContainer.getGlassPane()) != null) {
            Object object = _monitor;
            synchronized (object) {
                _components.add(glassPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void detach(RootPaneContainer rootPaneContainer) {
        if (rootPaneContainer != null) {
            Component glassPane = rootPaneContainer.getGlassPane();
            Object object = _monitor;
            synchronized (object) {
                int refCount = _components.release(glassPane);
                if (refCount == 0) {
                    this.setWaitCursor(glassPane, false);
                }
            }
        }
    }

    @Deprecated
    public void dispose() {
    }

    public void show() {
        this.show(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(int delay) {
        if (_suppressWaitCursor.booleanValue()) {
            return;
        }
        Object object = _monitor;
        synchronized (object) {
            SessionList<Component> thisShow = new SessionList<Component>();
            SessionList<Component> priorShow = null;
            if (_stack.size() > 0) {
                priorShow = _stack.peek();
            }
            for (Component component : _components.items()) {
                if (priorShow != null && priorShow.contains(component)) continue;
                _components.retain(component);
                thisShow.add(component);
                this.setGlassPane(component, true);
            }
            if (thisShow.size() == 0) {
                _stack.push(null);
            } else {
                _stack.push(thisShow);
                if (delay > 0) {
                    DisplayCursorTask task = new DisplayCursorTask(thisShow);
                    ((SessionList)thisShow).setTask(task);
                    _timer.schedule((TimerTask)task, delay);
                } else {
                    for (Component component : thisShow) {
                        this.setWaitCursor(component, true);
                    }
                }
            }
        }
    }

    @Deprecated
    public void show(long delay) {
        if (delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Delay is too long.");
        }
        this.show((int)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        if (_suppressWaitCursor.booleanValue()) {
            return;
        }
        Object object = _monitor;
        synchronized (object) {
            try {
                SessionList<Component> list = _stack.pop();
                if (list != null) {
                    DisplayCursorTask task = ((SessionList)list).getTask();
                    ((SessionList)list).setTask(null);
                    for (Component component : list) {
                        _components.release(component);
                        this.setWaitCursor(component, false);
                        this.setGlassPane(component, false);
                    }
                }
            }
            catch (EmptyStackException e) {
                Logger logger = Logger.getLogger(WaitCursor.class.getName());
                logger.log(Level.SEVERE, "WaitCursor.hide() called without matching WaitCursor.show()", e);
            }
        }
    }

    private void setWaitCursor(final Component glass, boolean visible) {
        int cursorType = visible ? 3 : 0;
        final Cursor cursor = Cursor.getPredefinedCursor(cursorType);
        if (SwingUtilities.isEventDispatchThread()) {
            glass.setCursor(cursor);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    glass.setCursor(cursor);
                }
            });
        }
    }

    private void setGlassPane(final Component glass, final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            glass.setVisible(visible);
            if (visible) {
                glass.addMouseListener(BEEPER);
            } else {
                glass.removeMouseListener(BEEPER);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    glass.setVisible(visible);
                    if (visible) {
                        glass.addMouseListener(BEEPER);
                    } else {
                        glass.removeMouseListener(BEEPER);
                    }
                }
            });
        }
    }

    private class DisplayCursorTask
    extends TimerTask {
        private SessionList<Component> _list;

        private DisplayCursorTask(SessionList<Component> list) {
            this._list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = _monitor;
            synchronized (object) {
                if (((SessionList)this._list).getTask() != null) {
                    for (Component c : this._list) {
                        WaitCursor.this.setWaitCursor(c, true);
                    }
                    ((SessionList)this._list).setTask(null);
                }
            }
        }
    }

    private static class SessionList<E>
    extends LinkedList<E> {
        private DisplayCursorTask _task;

        private SessionList() {
        }

        private DisplayCursorTask getTask() {
            return this._task;
        }

        private void setTask(DisplayCursorTask value) {
            this._task = value;
        }
    }

    private static class ReferenceCountedHashMap {
        private Map<Component, Integer> _items = new HashMap<Component, Integer>();

        private ReferenceCountedHashMap() {
        }

        public void add(Component component) {
            if (!this._items.containsKey(component)) {
                this._items.put(component, 0);
            }
        }

        public int retain(Component component) {
            int refCount = 1;
            if (this._items.containsKey(component)) {
                refCount = this._items.get(component);
                ++refCount;
            }
            this._items.put(component, refCount);
            return refCount;
        }

        public int release(Component component) {
            int refCount = 0;
            if (this._items.containsKey(component)) {
                refCount = this._items.get(component);
                if (--refCount == 0) {
                    this._items.remove(component);
                } else {
                    this._items.put(component, refCount);
                }
            }
            return refCount;
        }

        public Collection<Component> items() {
            return this._items.keySet();
        }
    }
}

