/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VxxString {
    public static String formatText(String strText) {
        String strEOL = System.getProperty("line.separator");
        StringBuffer strOutput = new StringBuffer();
        int cEOL = 10;
        if (strEOL == null) {
            return null;
        }
        int nLen = strText.length();
        for (int i = 0; i < nLen; ++i) {
            char c = strText.charAt(i);
            if (c == '\n') {
                strOutput.append(strEOL);
                continue;
            }
            strOutput.append(c);
        }
        return new String(strOutput);
    }

    public static String removeSpaces(String strText) {
        StringBuffer strOutput = new StringBuffer();
        int spaceChar = 32;
        int tabChar = 9;
        int nLen = strText.length();
        char[] c = new char[nLen];
        strText.getChars(0, nLen, c, 0);
        for (int i = 0; i < nLen; ++i) {
            if (c[i] == ' ' || c[i] == '\t') continue;
            strOutput.append(c[i]);
        }
        return new String(strOutput);
    }

    public static String normalizeWhitespace(String str) {
        if (str == null) {
            return null;
        }
        String s = str.trim();
        s = s.replaceAll("[\\s]+", " ");
        Pattern wsPnct = Pattern.compile(" ([\\.\\,\\;\\:\\?\\!])");
        Matcher m = wsPnct.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "$1");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String insertSpacesForParenthesis(String strText) {
        StringBuffer strOutput = new StringBuffer();
        int spaceChar = 32;
        int parLeft = 40;
        int parRight = 41;
        int nLen = strText.length();
        char[] c = new char[nLen];
        strText.getChars(0, nLen, c, 0);
        for (int i = 0; i < nLen; ++i) {
            if (c[i] != '(' && c[i] != ')') {
                strOutput.append(c[i]);
                continue;
            }
            if (c[i] == '(') {
                strOutput.append(c[i]);
                strOutput.append(' ');
                continue;
            }
            if (c[i] != ')') continue;
            strOutput.append(' ');
            strOutput.append(c[i]);
        }
        return new String(strOutput);
    }

    public static String spacesToCtrlChars(String strText) {
        StringBuffer strOutput = new StringBuffer();
        int spaceChar = 32;
        int nLen = strText.length();
        char[] c = new char[nLen];
        strText.getChars(0, nLen, c, 0);
        for (int i = 0; i < nLen; ++i) {
            if (c[i] != ' ') {
                strOutput.append(c[i]);
                continue;
            }
            strOutput.append("%20");
        }
        return new String(strOutput);
    }

    public static String upCaseIfNotQuoted(String inStr) {
        String tempStr = inStr.trim();
        if (tempStr.startsWith("\"") && tempStr.endsWith("\"")) {
            return inStr;
        }
        return inStr.toUpperCase();
    }

    public static String quoteApostrophe(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            out.append(c);
            if (c != '\'') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String getLogicalSQLString(String s) {
        if (s == null) {
            return null;
        }
        LogicalSQLStringWalker strw = new LogicalSQLStringWalker(s);
        boolean next = strw.next();
        StringBuffer buff = new StringBuffer();
        while (next) {
            buff.append(strw.getChar());
            next = strw.next();
        }
        return buff.toString();
    }

    public static boolean logicalSQLStringsEqual(String str1, String str2) {
        LogicalSQLStringWalker str1w = new LogicalSQLStringWalker(str1);
        LogicalSQLStringWalker str2w = new LogicalSQLStringWalker(str2);
        boolean str1Next = str1w.next();
        boolean str2Next = str2w.next();
        StringBuffer sb = new StringBuffer();
        while (str1Next && str2Next && str1w.getChar() == str2w.getChar()) {
            sb.append(str1w.getChar());
            str1Next = str1w.next();
            str2Next = str2w.next();
        }
        return !str1Next && !str2Next;
    }

    public static String concatStrings(String[] stringsToConcat, String separator) throws IllegalArgumentException {
        if (separator == null) {
            throw new IllegalArgumentException();
        }
        String finalString = "";
        for (int i = 0; i < stringsToConcat.length; ++i) {
            finalString = finalString + stringsToConcat[i];
            if (i == stringsToConcat.length - 1) continue;
            finalString = finalString + separator;
        }
        return finalString;
    }

    public static String concatStrings(Vector vectorToConcat, String separator) throws IllegalArgumentException {
        int size = vectorToConcat.size();
        String[] stringsToConcat = new String[size];
        for (int i = 0; i < size; ++i) {
            stringsToConcat[i] = vectorToConcat.elementAt(i).toString();
        }
        return VxxString.concatStrings(stringsToConcat, separator);
    }

    public static void main(String[] args) {
        String str1;
        String str2 = str1 = "Simple TEST for equal strings";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
        str2 = " Simple TEST for equal strings";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
        str2 = "Simple TEST for equal strings ";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
        str2 = "Simple  test for    \nequal strings";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
        str1 = "Simple test for equal strings";
        str2 = "Simple  \"TEST\" for    \nequal strings";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
        str1 = "Simple test '  for' equal strings";
        str2 = "Simple  \"TEST\" for    \nequal strings";
        System.out.println(" Comparing \"" + str1 + "\" with \"" + str2 + "\"");
        System.out.println("    Result = " + VxxString.logicalSQLStringsEqual(str1, str2));
    }

    public static String SQLStringTokenizer(String s) {
        return VxxString.SQLStringTokenizer(s, 65);
    }

    public static String SQLStringTokenizer(String s, int fixedLength) {
        if (s == null || s.equals("") || s.equals("\n")) {
            return s;
        }
        return VxxString.newSQLStringTokenizer(s, fixedLength, 0);
    }

    public static String newSQLStringTokenizer(String s, int fixedLength, int origLength) {
        String strValue = "";
        String newString = "";
        String delim = " ,/\n";
        if (s.indexOf("\n") != -1) {
            newString = s.substring(s.indexOf("\n"));
        }
        StringTokenizer st = new StringTokenizer(s, delim, true);
        String strPrev = strValue = strValue + st.nextToken();
        String strNext = "";
        int lineLength = 0;
        origLength += strValue.length();
        while (st.hasMoreTokens()) {
            strNext = st.nextToken();
            if (strNext.equals("\n")) {
                strValue = strValue + newString;
                break;
            }
            if (origLength != 4 && (strNext.toUpperCase().equals("ADD") || strNext.toUpperCase().equals("ACCOUNT") || strNext.toUpperCase().equals("ALLOCATE") || strNext.toUpperCase().equals("AND") || strNext.toUpperCase().equals("CACHE") || strNext.toUpperCase().equals("COALESCE") || strNext.toUpperCase().equals("COMPRESS") || strNext.toUpperCase().equals("DEALLOCATE") || strNext.toUpperCase().equals("DECLARE") || strNext.toUpperCase().equals("DISABLE") || strNext.toUpperCase().equals("ENABLE") || strNext.toUpperCase().equals("EXCHANGE") || strNext.toUpperCase().equals("FOR") || strNext.toUpperCase().equals("IDENTIFIED") || strNext.toUpperCase().equals("INCLUDING") || strNext.toUpperCase().equals("LIST") || strNext.toUpperCase().equals("LIMIT") || strNext.toUpperCase().equals("LOGGING") || strNext.toUpperCase().equals("MERGE") || strNext.toUpperCase().equals("MINIMIZE") || strNext.toUpperCase().equals("MODIFY") || strNext.toUpperCase().equals("MONITORING") || strNext.toUpperCase().equals("MOVE") || strNext.toUpperCase().equals("NOCACHE") || strNext.toUpperCase().equals("NOCOMPRESS") || strNext.toUpperCase().equals("NOLOGGING") || strNext.toUpperCase().equals("NOMINIMIZE") || strNext.toUpperCase().equals("NOMONITORING") || strNext.toUpperCase().equals("NOPARALLEL") || strNext.toUpperCase().equals("ON") || strNext.toUpperCase().equals("PARALLEL") || strNext.toUpperCase().equals("QUOTA") || strNext.toUpperCase().equals("REBUILD") || strNext.toUpperCase().equals("RENAME") || strNext.toUpperCase().equals("SET") || strNext.toUpperCase().equals("SPLIT") || strNext.toUpperCase().equals("TEMPORARY") || strNext.toUpperCase().equals("TRUNCATE") || strNext.toUpperCase().equals("UNUSABLE") || strNext.toUpperCase().equals("USING") || strNext.toUpperCase().equals("VALUES") || strNext.toUpperCase().equals("WHERE"))) {
                strValue = strValue + "\n    " + strNext;
                if (!strNext.equals(" ")) {
                    strPrev = strNext.toUpperCase();
                }
                origLength = strNext.length() + 4;
                continue;
            }
            if (origLength != 4 && !strPrev.equals("AFTER") && !strPrev.equals("BEFORE") && !strPrev.equals("GRANT") && !strPrev.equals("ON") && !strPrev.equals("OR") && !strPrev.equals("REVOKE") && (strNext.toUpperCase().equals("ALTER") || strNext.toUpperCase().equals("CREATE") || strNext.toUpperCase().equals("DELETE") || strNext.toUpperCase().equals("DROP") || strNext.toUpperCase().equals("EXECUTE") || strNext.toUpperCase().equals("INSERT") || strNext.toUpperCase().equals("REFERENCES") || strNext.toUpperCase().equals("SELECT") || strNext.toUpperCase().equals("UPDATE"))) {
                strValue = strValue + "\n    " + strNext;
                if (!strNext.equals(" ")) {
                    strPrev = strNext.toUpperCase();
                }
                origLength = strNext.length() + 4;
                continue;
            }
            if (!(origLength == 4 || strPrev.equals("(") || strPrev.equals("*/") || strPrev.equals("ALTER") || strPrev.equals("ANALYZE") || strPrev.equals("CREATE") || strPrev.equals("DELETE") || strPrev.equals("DEFAULT") || strPrev.equals("DROP") || strPrev.equals("GRANT") || strPrev.equals("INSERT") || strPrev.equals("MOVE") || strPrev.equals("NESTED") || strPrev.equals("ON") || strPrev.equals("TEMPORARY") || strPrev.equals("UNIQUE") || strPrev.equals("UNLIMITED") || strPrev.equals("USING") || !strNext.toUpperCase().equals("CLUSTER") && !strNext.toUpperCase().equals("CONSTRAINT") && !strNext.toUpperCase().equals("DATAFILE") && !strNext.toUpperCase().equals("FROM") && !strNext.toUpperCase().equals("INDEX") && !strNext.toUpperCase().equals("INTO") && !strNext.toUpperCase().equals("LOB") && !strNext.toUpperCase().equals("STORAGE") && !strNext.toUpperCase().equals("TABLE") && !strNext.toUpperCase().equals("TABLESPACE"))) {
                strValue = strValue + "\n    " + strNext;
                if (!strNext.equals(" ")) {
                    strPrev = strNext.toUpperCase();
                }
                origLength = strNext.length() + 4;
                continue;
            }
            if (!(origLength == 4 || strPrev.equals("ADD") || strPrev.equals("ALTER") || strPrev.equals("COALESCE") || strPrev.equals("CREATE") || strPrev.equals("DROP") || strPrev.equals("EXCHANGE") || strPrev.equals("MERGE") || strPrev.equals("MODIFY") || strPrev.equals("MOVE") || strPrev.equals("RENAME") || strPrev.equals("SPLIT") || strPrev.equals("TRUNCATE") || !strNext.toUpperCase().equals("PARTITION"))) {
                strValue = strValue + "\n    " + strNext;
                if (!strNext.equals(" ")) {
                    strPrev = strNext.toUpperCase();
                }
                origLength = strNext.length() + 4;
                continue;
            }
            lineLength = origLength + strNext.length();
            if (fixedLength > 0 && lineLength > fixedLength && delim.indexOf(strNext) == -1) {
                strValue = strValue + "\n    " + strNext;
                origLength = strNext.length() + 4;
            } else if (fixedLength > 0 && lineLength > fixedLength && strNext.equals(" ")) {
                strValue = strValue + "\n    ";
                origLength = 4;
            } else {
                strValue = strValue + strNext;
                origLength = lineLength;
            }
            if (strNext.equals(" ")) continue;
            strPrev = strNext.toUpperCase();
        }
        return strValue;
    }

    private static class LogicalSQLStringWalker {
        private String str = null;
        private boolean inQuotes = false;
        private int currentCharIndex = -1;
        private int effectiveLength = 0;
        char quoteChar;

        LogicalSQLStringWalker(String theStr) {
            this.str = theStr;
            this.effectiveLength = this.lastWhitespaceInString();
            this.currentCharIndex = this.getStartingIndex();
        }

        char getChar() {
            int ch = this.str.charAt(this.currentCharIndex);
            if (!this.inQuotes) {
                if (Character.isWhitespace((char)ch)) {
                    ch = 32;
                } else if ((ch = (int)Character.toUpperCase((char)ch)) == 65 && Character.isWhitespace(this.lookahead(-1)) && Character.toUpperCase(this.lookahead(1)) == 'S' && Character.isWhitespace(this.lookahead(2))) {
                    ch = 73;
                }
            }
            return (char)ch;
        }

        char lookahead(int offset) {
            char ch = '\uffff';
            if (offset < 0 && this.currentCharIndex + offset >= 0 || offset >= 0 && this.currentCharIndex + offset < this.effectiveLength) {
                ch = this.str.charAt(this.currentCharIndex + offset);
            }
            return ch;
        }

        boolean next() {
            ++this.currentCharIndex;
            if (this.currentCharIndex < this.effectiveLength) {
                char ch = this.str.charAt(this.currentCharIndex);
                if (!this.inQuotes) {
                    if (ch == '\'' || ch == '\"') {
                        this.quoteChar = ch;
                        this.inQuotes = true;
                        if (ch == '\"') {
                            ++this.currentCharIndex;
                            if (this.currentCharIndex < this.effectiveLength && this.str.charAt(this.currentCharIndex) == '\"') {
                                this.inQuotes = false;
                            }
                        }
                    } else {
                        this.currentCharIndex = this.lastWhitespaceInSeries(this.currentCharIndex);
                    }
                } else if (ch == this.quoteChar) {
                    this.inQuotes = false;
                    if (ch == '\"') {
                        ++this.currentCharIndex;
                        this.currentCharIndex = this.lastWhitespaceInSeries(this.currentCharIndex);
                    }
                }
            }
            return this.currentCharIndex < this.effectiveLength;
        }

        private int lastWhitespaceInSeries(int from) {
            boolean wasPunct;
            int i = from;
            boolean bl = wasPunct = from > 0 && this.isPLSqlPunctuation(this.str.charAt(from - 1));
            if (i < this.effectiveLength && Character.isWhitespace(this.str.charAt(i))) {
                ++i;
                while (i < this.effectiveLength && Character.isWhitespace(this.str.charAt(i))) {
                    ++i;
                }
                char nonWSChar = this.str.charAt(i);
                if (!(wasPunct ^ this.isPLSqlPunctuation(nonWSChar)) || wasPunct && (nonWSChar == '\'' || nonWSChar == '\"')) {
                    --i;
                }
            }
            return i;
        }

        private boolean isPLSqlPunctuation(char c) {
            switch (c) {
                case '!': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '@': 
                case '^': 
                case '|': 
                case '~': {
                    return true;
                }
            }
            return false;
        }

        private int getStartingIndex() {
            int i;
            for (i = 0; i < this.effectiveLength && Character.isWhitespace(this.str.charAt(i)); ++i) {
            }
            return --i;
        }

        private int lastWhitespaceInString() {
            int i;
            for (i = this.str.length() - 1; i >= 0 && (Character.isWhitespace(this.str.charAt(i)) || this.str.charAt(i) == ';'); --i) {
            }
            return ++i;
        }
    }
}

