/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.BasicXMLDiffer;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.XMLDifferException;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

public class SchemaDrivenXMLDiffer
extends BasicXMLDiffer {
    private static final String XSD_PREFIX = "xsd";
    private static final String XDF_PREFIX = "xdf";
    private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String XDF_NS_URI = "http://xmlns.oracle.com/xdf";
    private static final String XSD_NAME_ATTR = "name";
    private static final String XSD_TYPE_ATTR = "type";
    private static final String XSD_BASE_ATTR = "base";
    private static final String XSD_XPATH_ATTR = "xpath";
    private static final String XSD_MAX_OCCURS_ATTR = "maxOccurs";
    private static final String XSD_MIN_OCCURS_ATTR = "minOccurs";
    private static final String XSD_UNBOUNDED_ATTR_VALUE = "unbounded";
    private static final String XSD_STRING_TYPE = "xsd:string";
    private static final String XSD_NORMALIZED_STRING_TYPE = "xsd:normalizedString";
    private static final String XSD_DOUBLE_TYPE = "xsd:double";
    private static final String XSD_INTEGER_TYPE = "xsd:integer";
    private static final String XDF_ORDERED_ATTR = "ordered";
    private XMLDocument m_xsdDoc = null;
    private XMLSchema m_xsdSchema = null;
    private URL m_baseURL = null;
    private XSDPrefixResolver s_resolver = new XSDPrefixResolver();

    public SchemaDrivenXMLDiffer(XMLElement e1, XMLElement e2, XMLDocument xsdDoc) {
        super(e1, e2);
        this.m_xsdDoc = xsdDoc;
    }

    public void setBaseURL(URL baseURL) {
        this.m_baseURL = baseURL;
    }

    @Override
    protected void initDiffer() throws XMLDifferException {
        try {
            XSDBuilder xb = new XSDBuilder();
            this.m_xsdSchema = xb.build(this.m_xsdDoc, this.m_baseURL);
        }
        catch (XSDException xsde) {
            SchemaDrivenXMLDiffer.assertDifferException(xsde.getMessage(), (Exception)((Object)xsde));
        }
    }

    @Override
    protected boolean matchTextNodes(XMLText tn1, XMLText tn2, Object context) throws XMLDifferException {
        return this.compareTextNodes(tn1, tn2, (SchemaElement)context) == 0;
    }

    @Override
    protected void compareSequences(XMLNode n1, XMLNode n2, NodeList childrenList1, NodeList childrenList2, int idx1, int idx2, int length1, int length2, Object context) throws XMLDifferException {
        SchemaElement se = null;
        se = context == null ? this.findDefiningElement((XMLElement)n1, (SchemaElement)context) : ((SchemaElement)context).findChildForPath(((XMLElement)n1).getTagName());
        if (se == null || !se.getIsCollection()) {
            super.compareSequences(n1, n2, childrenList1, childrenList2, idx1, idx2, length1, length2, se);
            return;
        }
        boolean isOrdered = se.getIsOrdered();
        SchemaElement[] keys = se.getCollectionKeys();
        if (isOrdered) {
            this.compareOrderedCollections(n1, n2, childrenList1, childrenList2, idx1, idx2, length1, length2, keys, se);
        } else {
            this.compareUnOrderedCollections(n1, n2, childrenList1, childrenList2, idx1, idx2, length1, length2, keys, se);
        }
    }

    @Override
    protected int isOptionalElement(XMLElement e, Object context) throws XMLDifferException {
        int isOptElem = 3;
        if (context != null) {
            SchemaElement se = (SchemaElement)context;
            SchemaElement childSE = se.findChildForPath(e.getTagName());
            if (childSE != null) {
                isOptElem = childSE.getIsOptional() ? 1 : 2;
            } else {
                SchemaDrivenXMLDiffer.assertDifferException("Unable to find SchemaElement for child element <" + e.getTagName() + ">");
            }
        }
        return isOptElem;
    }

    private void compareOrderedCollections(XMLNode n1, XMLNode n2, NodeList childrenList1, NodeList childrenList2, int idx1, int idx2, int length1, int length2, SchemaElement[] keys, SchemaElement se) throws XMLDifferException {
        int i;
        Vector<XMLElement> collItems1 = new Vector<XMLElement>(length1 - idx1);
        Vector<XMLElement> collItems2 = new Vector<XMLElement>(length2 - idx2);
        for (i = idx1; i < length1; ++i) {
            collItems1.add((XMLElement)childrenList1.item(i));
        }
        for (i = idx2; i < length2; ++i) {
            collItems2.add((XMLElement)childrenList2.item(i));
        }
        CollItemComparator cic = new CollItemComparator(keys);
        this.compareOrderedCollItemLists(collItems1, collItems2, (XMLElement)n2, keys, se);
    }

    private void compareUnOrderedCollections(XMLNode n1, XMLNode n2, NodeList childrenList1, NodeList childrenList2, int idx1, int idx2, int length1, int length2, SchemaElement[] keys, SchemaElement se) throws XMLDifferException {
        int i;
        CollItemComparator cic = new CollItemComparator(keys);
        TreeSet<XMLElement> collItems1 = new TreeSet<XMLElement>(cic);
        TreeSet<XMLElement> collItems2 = new TreeSet<XMLElement>(cic);
        for (i = idx1; i < length1; ++i) {
            if (collItems1.add((XMLElement)childrenList1.item(i))) continue;
            SchemaDrivenXMLDiffer.assertDifferException("Duplicate elements found in collection " + ((XMLElement)n1).getTagName() + " on side 1");
        }
        for (i = idx2; i < length2; ++i) {
            if (collItems2.add((XMLElement)childrenList2.item(i))) continue;
            SchemaDrivenXMLDiffer.assertDifferException("Duplicate elements found in collection " + ((XMLElement)n2).getTagName() + " on side 2");
        }
        this.compareOrderedCollItemLists(collItems1, collItems2, (XMLElement)n2, keys, se);
    }

    private void compareOrderedCollItemLists(Collection<XMLElement> collItems1, Collection<XMLElement> collItems2, XMLElement side2Parent, SchemaElement[] keys, SchemaElement se) throws XMLDifferException {
        Iterator<XMLElement> itemsItr1 = collItems1.iterator();
        Iterator<XMLElement> itemsItr2 = collItems2.iterator();
        XMLElement item1 = this.nextElement(itemsItr1);
        XMLElement item2 = this.nextElement(itemsItr2);
        while (item1 != null || item2 != null) {
            while (item1 != null && (item2 == null || this.compareCollectionItems(item1, item2, keys) < 0)) {
                this.attachNewNode((XMLNode)item1, (XMLNode)side2Parent, (XMLNode)item2, "1");
                item1 = this.nextElement(itemsItr1);
            }
            while (item1 != null && item2 != null && this.compareCollectionItems(item1, item2, keys) == 0) {
                this.compare((XMLNode)item1, (XMLNode)item2, side2Parent, null, se);
                item1 = this.nextElement(itemsItr1);
                item2 = this.nextElement(itemsItr2);
            }
            while (item2 != null && (item1 == null || this.compareCollectionItems(item2, item1, keys) < 0)) {
                this.markSideOnlyNode((XMLNode)item2, "2");
                item2 = this.nextElement(itemsItr2);
            }
        }
    }

    private XMLElement nextElement(Iterator<XMLElement> itemsItr) {
        return itemsItr.hasNext() ? itemsItr.next() : null;
    }

    private int compareCollectionItems(XMLElement ci1, XMLElement ci2, SchemaElement[] keys) throws XMLDifferException {
        int result = 0;
        for (int keyIdx = 0; keyIdx < keys.length; ++keyIdx) {
            SchemaElement keyDefn = keys[keyIdx];
            String pattern = keyDefn.getKeyPath();
            NodeList keyElemList1 = null;
            NodeList keyElemList2 = null;
            try {
                keyElemList1 = ci1.selectNodes(pattern);
                keyElemList2 = ci2.selectNodes(pattern);
            }
            catch (XSLException xse) {
                xse.printStackTrace(System.err);
                SchemaDrivenXMLDiffer.assertDifferException("XSLException: " + xse.toString());
            }
            if (keyElemList1.getLength() != 1 || keyElemList2.getLength() != 1) {
                SchemaDrivenXMLDiffer.assertDifferException("Zero or multiple instances found for key element " + keyDefn.getElementName() + " of collection item " + ci1.getTagName());
            }
            XMLElement cItem1 = (XMLElement)keyElemList1.item(0);
            XMLElement cItem2 = (XMLElement)keyElemList2.item(0);
            if (!keyDefn.getIsCollection()) {
                String s1 = cItem1.getText();
                String s2 = cItem2.getText();
                result = this.compareText(s1, s2, keyDefn);
            } else {
                SchemaElement[] subKeys = keyDefn.getCollectionKeys();
                if (subKeys.length != 1) {
                    SchemaDrivenXMLDiffer.assertDifferException("Collection-valued collection key " + keyDefn.getElementName() + " does not have exactly one sub-key.");
                }
                SchemaElement subKey = subKeys[0];
                SchemaElement subKeyParent = (SchemaElement)keyDefn.getChildElements().elementAt(0);
                String subKeyPattern = subKeyParent.getElementName() + "/" + subKey.getElementName();
                NodeList subKeyValues1 = null;
                NodeList subKeyValues2 = null;
                try {
                    subKeyValues1 = cItem1.selectNodes(subKeyPattern);
                    subKeyValues2 = cItem2.selectNodes(subKeyPattern);
                }
                catch (XSLException xse) {
                    xse.printStackTrace(System.err);
                    SchemaDrivenXMLDiffer.assertDifferException("XSLException: " + xse.toString());
                }
                int numValues1 = subKeyValues1.getLength();
                int numValues2 = subKeyValues2.getLength();
                for (int vi = 0; vi < numValues1 && vi < numValues2 && result == 0; ++vi) {
                    XMLElement x1 = (XMLElement)subKeyValues1.item(vi);
                    XMLElement x2 = (XMLElement)subKeyValues2.item(vi);
                    String s1 = x1.getText();
                    String s2 = x2.getText();
                    result = this.compareText(s1, s2, subKey);
                }
                if (result == 0) {
                    result = numValues1 - numValues2;
                }
            }
            if (result != 0) break;
        }
        return result;
    }

    private int compareTextNodes(XMLText tn1, XMLText tn2, SchemaElement context) throws XMLDifferException {
        XMLElement textParent = (XMLElement)tn1.getParentNode();
        SchemaElement se = context.findChildForPath(textParent.getTagName());
        if (se == null) {
            SchemaDrivenXMLDiffer.assertDifferException("Unable to find SchemaElement for element <" + textParent.getTagName() + "> under element <" + context.getElementName() + ">");
        }
        return this.compareText(tn1.getNodeValue(), tn2.getNodeValue(), se);
    }

    private int compareText(String s1, String s2, SchemaElement se) {
        XSDSimpleType simpleType = (XSDSimpleType)se.getDefiningType();
        int result = simpleType.compareValues(s1, s2);
        return result;
    }

    private SchemaElement findDefiningElement(XMLElement elem, SchemaElement context) throws XMLDifferException {
        if (elem instanceof XMLDocument) {
            return null;
        }
        SchemaElement newContext = null;
        String elemName = elem.getTagName();
        if (context == null) {
            String pattern = "/xsd:schema/xsd:element[@name='" + elemName + "']";
            newContext = this.buildSchemaElementTree(elemName);
        } else {
            newContext = context.findChildForPath(elemName);
            if (newContext == null) {
                SchemaDrivenXMLDiffer.assertDifferException("Unable to find SchemaElement for " + elemName + " under SchemaElement for " + context.getElementName());
            }
        }
        return newContext;
    }

    private SchemaElement buildSchemaElementTree(String topElemName) throws XMLDifferException {
        SchemaElement topSE = null;
        XSDElement topXE = this.m_xsdSchema.getElement(null, topElemName);
        if (topXE == null) {
            SchemaDrivenXMLDiffer.assertDifferException("Unable to find XSDElement for " + topElemName);
        }
        topSE = new SchemaElement(topXE);
        this.extendSchemaElementTree(topSE);
        StringBuffer sb = new StringBuffer();
        topSE.format(sb, "");
        System.out.println(sb);
        return topSE;
    }

    private void extendSchemaElementTree(SchemaElement se) throws XMLDifferException {
        XSDElement thisElement = se.getThisElement();
        XSDNode thisElementType = thisElement.getType();
        se.setDefiningType(thisElementType);
        int minOccurs = thisElement.getMinOccurs();
        se.setIsOptional(minOccurs == 0);
        if (thisElementType instanceof XSDComplexType) {
            int maxOccurs;
            XSDNode[] childNodes = thisElement.getChildElements();
            SchemaElement newSE = null;
            int numChildren = childNodes.length;
            for (int i = 0; i < numChildren; ++i) {
                XSDElement childE = (XSDElement)childNodes[i];
                newSE = new SchemaElement(childE);
                se.addChild(newSE);
                this.extendSchemaElementTree(newSE);
            }
            if (numChildren == 1 && (maxOccurs = newSE.getThisElement().getMaxOccurs()) > 1) {
                se.setIsCollection(true);
                XSDIdentity[] identities = thisElement.getIdentities();
                for (int i = 0; i < identities.length; ++i) {
                    XSDIdentity ident = identities[i];
                    int identType = ident.getNodeType();
                    if (identType != 22) continue;
                    String selector = ident.getSelector();
                    String[] fields = ident.getFields();
                    int numKeys = 0;
                    for (int j = 0; j < fields.length && fields[j] != null; ++j) {
                        ++numKeys;
                    }
                    if (!newSE.getElementName().equals(selector)) {
                        SchemaDrivenXMLDiffer.assertDifferException("Expected selector value " + newSE.getElementName() + ", got: " + selector);
                    }
                    if (numKeys == 0) {
                        SchemaDrivenXMLDiffer.assertDifferException("No keys found for collection " + se.getElementName());
                    }
                    SchemaElement[] keys = new SchemaElement[numKeys];
                    for (int k = 0; k < numKeys; ++k) {
                        SchemaElement keySE = newSE.findChildForPath(fields[k]);
                        if (keySE != null) {
                            keySE.setKeyPath(fields[k]);
                            keys[k] = keySE;
                            continue;
                        }
                        SchemaDrivenXMLDiffer.assertDifferException("Unable to find SchemaElement for key field " + fields[k] + " of collection " + se.getElementName());
                    }
                    se.setCollectionKeys(keys);
                    break;
                }
            }
        }
    }

    class XSDPrefixResolver
    implements NSResolver {
        XSDPrefixResolver() {
        }

        public String resolveNamespacePrefix(String prefix) {
            if (prefix != null && prefix.equals(SchemaDrivenXMLDiffer.XSD_PREFIX)) {
                return SchemaDrivenXMLDiffer.XSD_NS_URI;
            }
            if (prefix != null && prefix.equals(SchemaDrivenXMLDiffer.XDF_PREFIX)) {
                return SchemaDrivenXMLDiffer.XDF_NS_URI;
            }
            return null;
        }
    }

    private class CollItemComparator
    implements Comparator<XMLElement> {
        private SchemaElement[] m_keys = null;

        CollItemComparator(SchemaElement[] keys) {
            this.m_keys = keys;
        }

        @Override
        public int compare(XMLElement o1, XMLElement o2) {
            int result = 0;
            try {
                result = SchemaDrivenXMLDiffer.this.compareCollectionItems(o1, o2, this.m_keys);
            }
            catch (XMLDifferException xde) {
                xde.printStackTrace();
            }
            return result;
        }
    }

    private class SchemaElement {
        private XSDElement m_thisElement = null;
        private String m_elementName = null;
        private XSDNode m_definingType = null;
        private Vector<SchemaElement> m_childElements = null;
        private boolean m_isCollection = false;
        private boolean m_isOrdered = false;
        private boolean m_isOptional = false;
        private SchemaElement[] m_collectionKeys = null;
        private String m_keyPath = null;

        private SchemaElement(XSDElement e) {
            this.m_thisElement = e;
            this.m_elementName = e.getName();
        }

        private XSDElement getThisElement() {
            return this.m_thisElement;
        }

        private void addChild(SchemaElement se) {
            if (this.m_childElements == null) {
                this.m_childElements = new Vector();
            }
            this.m_childElements.add(se);
        }

        private Vector<SchemaElement> getChildElements() {
            return this.m_childElements;
        }

        private SchemaElement findChildForPath(String elemPath) {
            SchemaElement seForPath = null;
            if (this.m_childElements != null) {
                String[] pathElems = elemPath.split("/");
                Vector<SchemaElement> childElems = this.m_childElements;
                block0: for (String name : pathElems) {
                    for (SchemaElement se : childElems) {
                        if (!se.getElementName().equals(name)) continue;
                        seForPath = se;
                        childElems = se.getChildElements();
                        continue block0;
                    }
                }
            }
            return seForPath;
        }

        private String getElementName() {
            return this.m_elementName;
        }

        private XSDNode getDefiningType() {
            return this.m_definingType;
        }

        private void setDefiningType(XSDNode type) {
            this.m_definingType = type;
        }

        private boolean getIsCollection() {
            return this.m_isCollection;
        }

        private void setIsCollection(boolean c) {
            this.m_isCollection = c;
        }

        private boolean getIsOrdered() {
            return this.m_isOrdered;
        }

        private void setIsOrdered(boolean isOrdered) {
            this.m_isOrdered = isOrdered;
        }

        private boolean getIsOptional() {
            return this.m_isOptional;
        }

        private void setIsOptional(boolean isOptional) {
            this.m_isOptional = isOptional;
        }

        private SchemaElement[] getCollectionKeys() {
            return this.m_collectionKeys;
        }

        private void setCollectionKeys(SchemaElement[] keys) {
            this.m_collectionKeys = keys;
        }

        private String getKeyPath() {
            return this.m_keyPath;
        }

        private void setKeyPath(String kp) {
            this.m_keyPath = kp;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.format(sb, "");
            return sb.toString();
        }

        private void format(StringBuffer sb, String indent) {
            sb.append(indent).append("<").append(this.m_elementName).append(">");
            String type = null;
            if (this.m_definingType instanceof XSDSimpleType) {
                XSDSimpleType simpleType = (XSDSimpleType)this.m_definingType;
                int basicType = simpleType.getBasicType();
                type = XSDSimpleType.sTypes[basicType];
            } else {
                type = this.m_definingType.getName();
            }
            sb.append(" type=").append(type);
            if (this.m_isCollection) {
                sb.append(" collection").append(this.m_isOrdered ? " ordered" : " unordered").append(" key(s): [ ");
                for (SchemaElement keySE : this.m_collectionKeys) {
                    sb.append(keySE.getElementName()).append(" ");
                }
                sb.append("]");
            }
            if (this.m_isOptional) {
                sb.append(" optional");
            }
            if (this.m_keyPath != null) {
                sb.append(" keyPath: " + this.m_keyPath);
            }
            sb.append("\n");
            if (this.m_childElements != null) {
                indent = indent + " ";
                for (SchemaElement se : this.m_childElements) {
                    se.format(sb, indent);
                }
            }
        }
    }
}

