/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTableConstraintsAccessor
extends XMLAccessor {
    private static String TABLE = "TABLE";
    private boolean m_isNew = false;
    public static final short DELETE_RULE_NO_ACTION = 0;
    public static final short DELETE_RULE_CASCADE = 1;
    public static final short DELETE_RULE_SET_NULL = 2;
    public static String X_CON_CK_LIST = "/sxml:" + TABLE + "/*" + "/sxml:" + "CHECK_CONSTRAINT_LIST" + "/sxml:" + "CHECK_CONSTRAINT_LIST_ITEM";
    public static String X_CON_PK_LIST = "/sxml:" + TABLE + "/*" + "/sxml:" + "PRIMARY_KEY_CONSTRAINT_LIST" + "/sxml:" + "PRIMARY_KEY_CONSTRAINT_LIST_ITEM";
    public static String X_CON_UK_LIST = "/sxml:" + TABLE + "/*" + "/sxml:" + "UNIQUE_KEY_CONSTRAINT_LIST" + "/sxml:" + "UNIQUE_KEY_CONSTRAINT_LIST_ITEM";
    public static String X_CON_FK_LIST = "/sxml:" + TABLE + "/*" + "/sxml:" + "FOREIGN_KEY_CONSTRAINT_LIST" + "/sxml:" + "FOREIGN_KEY_CONSTRAINT_LIST_ITEM";
    public static String X_CON_COL_NN_LIST = "/sxml:" + TABLE + "/*" + "/sxml:" + "COL_LIST" + "/sxml:" + "COL_LIST_ITEM" + "/sxml:" + "NOT_NULL";
    private static String X_CK_CONS_CONDITION = "sxml:CONDITION";
    private static String X_FK_CONS_REFD_SCHEMA = "sxml:REFERENCES/sxml:SCHEMA";
    private static String X_FK_CONS_REFD_NAME = "sxml:REFERENCES/sxml:NAME";
    private static String X_FK_CONS_ON_DELETE = "sxml:REFERENCES/sxml:ON_DELETE";
    private static String X_CONS_DISABLE = "sxml:DISABLE";
    private static String X_CONS_DEFERRABLE = "sxml:DEFERRABLE";
    private static String X_CONS_INITIALLY_DEFERRED = "sxml:INITIALLY_DEFERRED";
    private static String X_CONS_NOVALIDATE = "sxml:NOVALIDATE";
    private static String X_CONS_RELY = "sxml:RELY";
    private static String X_CONS_REFD_COLUMNS = "sxml:REFERENCES/sxml:COL_LIST/sxml:COL_LIST_ITEM";
    private static String X_CONSTRAINED_COLUMN_NAME = "../sxml:NAME";

    protected XMLTableConstraintsAccessor() {
    }

    protected XMLTableConstraintsAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void setXmlDoc(XMLNode consItemNode) throws XMLAccessorException {
        this.setXmlNode(consItemNode);
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        String onSchema = this.getRefdSchema(null);
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setRefdSchema((String)schemaMap.get(onSchema), changeMode);
        }
    }

    public String getConstraintType() {
        String cType = "UNKNOWN";
        String nName = this.getXmlNode().getNodeName();
        if (nName != null) {
            if (nName.equals("CHECK_CONSTRAINT_LIST_ITEM")) {
                cType = "CHECK";
            } else if (nName.equals("PRIMARY_KEY_CONSTRAINT_LIST_ITEM")) {
                cType = "PRIMARY";
            } else if (nName.equals("UNIQUE_KEY_CONSTRAINT_LIST_ITEM")) {
                cType = "UNIQUE";
            } else if (nName.equals("FOREIGN_KEY_CONSTRAINT_LIST_ITEM")) {
                cType = "FOREIGN";
            } else if (nName.equals("NOT_NULL")) {
                cType = "NOT_NULL";
            }
        }
        return cType;
    }

    public String getType() {
        return this.getConstraintType();
    }

    public String getConstraintName() {
        return this.selectTextValue(X_NAME);
    }

    @Override
    public String getName() {
        return this.getConstraintName();
    }

    public void setName(String name) {
        if (this.getName() != null) {
            this.setTextValue(X_NAME, name);
        } else {
            this.createTextNode(X_NAME, "NAME", name);
        }
    }

    public void setIsNew(boolean isNew) {
        this.m_isNew = isNew;
    }

    public boolean getIsNew() {
        return this.m_isNew;
    }

    public boolean getIsGeneratedName() {
        return !this.nodeExists(X_NAME);
    }

    public String getCheckCondition(String conType) {
        return this.selectTextValue(X_CK_CONS_CONDITION);
    }

    public String getCheckCondition() {
        return this.selectTextValue(X_CK_CONS_CONDITION);
    }

    public String getRefdSchema(String conType) {
        return this.selectTextValue(X_FK_CONS_REFD_SCHEMA);
    }

    public void setRefdSchema(String schema) {
        this.setTextValue(X_FK_CONS_REFD_SCHEMA, schema);
    }

    private void setRefdSchema(String schema, int changeMode) {
        this.setTextValue(X_FK_CONS_REFD_SCHEMA, schema, changeMode);
    }

    public String getParentTableSchema() {
        return this.selectTextValue(X_FK_CONS_REFD_SCHEMA);
    }

    public String getRefdTableName() {
        return this.selectTextValue(X_FK_CONS_REFD_NAME);
    }

    public String getParentTableName() {
        return this.selectTextValue(X_FK_CONS_REFD_NAME);
    }

    public void setParentTableName(String newName) {
        this.setTextValue(X_FK_CONS_REFD_NAME, newName);
    }

    public String getRefdConsName(String conType) {
        String sn = null;
        if (conType.equals("FOREIGN")) {
            // empty if block
        }
        return sn;
    }

    public boolean getCascadeOnDelete(String conType) {
        String od = this.selectTextValue(X_FK_CONS_ON_DELETE);
        return od != null && od.equals("CASCADE");
    }

    public short getDeleteRule() {
        int odRule = 0;
        String od = this.selectTextValue(X_FK_CONS_ON_DELETE);
        if (od != null) {
            if (od.equals("CASCADE")) {
                odRule = 1;
            } else if (od.equals("SET_NULL") || od.equals("SET NULL")) {
                odRule = 2;
            }
        }
        return (short)odRule;
    }

    public boolean getDisable() {
        return this.nodeExists(X_CONS_DISABLE);
    }

    public void setDisable(boolean disable) {
        if (disable && !this.getDisable()) {
            this.createNode(X_CONS_DISABLE, "DISABLE");
        } else if (!disable && this.getDisable()) {
            this.removeNode(X_CONS_DISABLE);
        }
    }

    public boolean getDeferrable() {
        return this.nodeExists(X_CONS_DEFERRABLE);
    }

    public boolean getDeferred() {
        return this.nodeExists(X_CONS_INITIALLY_DEFERRED);
    }

    public boolean getValidate() {
        return !this.nodeExists(X_CONS_NOVALIDATE);
    }

    public boolean getNovalidate() {
        return this.nodeExists(X_CONS_NOVALIDATE);
    }

    public void setNovalidate(boolean noValidate) {
        if (noValidate && !this.getNovalidate()) {
            this.createNode(X_CONS_NOVALIDATE, "NOVALIDATE");
        } else if (!noValidate && this.getNovalidate()) {
            this.removeNode(X_CONS_NOVALIDATE);
        }
    }

    public boolean getEnforceConstraint() {
        return !this.nodeExists(X_CONS_RELY);
    }

    public boolean getRely() {
        return this.nodeExists(X_CONS_RELY);
    }

    public boolean getGeneratedName() {
        return this.getIsGeneratedName();
    }

    public long getRefConstraintId(String conType) {
        long sn = 0L;
        if (conType.equals("FOREIGN")) {
            // empty if block
        }
        return sn;
    }

    public boolean getColumnLevelConstraint() {
        return this.getIsColumnLevelConstraint();
    }

    public boolean getIsColumnLevelConstraint() {
        return this.getIsNotNullConstraint();
    }

    public boolean getIsNotNullConstraint() {
        return this.getConstraintType() == "NOT_NULL";
    }

    public String getConstrainedColumn() {
        String onCol = null;
        if (this.getIsColumnLevelConstraint()) {
            onCol = this.selectTextValue(X_CONSTRAINED_COLUMN_NAME);
        }
        return onCol;
    }

    public NodeList getConstraintColumns() {
        return this.selectNodes(X_COLUMN_LIST);
    }

    public Vector getConsColumnsVector() {
        return this.getColumnNamesVector(this.getConstraintColumns());
    }

    public NodeList getConstraintReferencedColumns() {
        return this.selectNodes(X_CONS_REFD_COLUMNS);
    }

    public Vector getParentColumnsVector() {
        return this.getColumnNamesVector(this.getConstraintReferencedColumns());
    }

    public static String getColumnName(Node col) {
        return XMLTableConstraintsAccessor.selectTextValue((XMLNode)col, X_NAME);
    }

    public static String getColumnID(Node col) {
        return XMLTableConstraintsAccessor.selectTextValue((XMLNode)col, "sxml:COL_NUM");
    }

    String getConstraintBody() {
        XMLDocument constraintDoc = new XMLDocument();
        XMLNode importable = (XMLNode)constraintDoc.importNode((Node)this.getXmlNode(), true);
        constraintDoc.appendChild((Node)importable);
        String ddl = this.generateDDL(4, 1, constraintDoc);
        return ddl;
    }

    public void remove() {
        XMLNode parentNode = (XMLNode)this.getXmlNode().getParentNode();
        parentNode.removeChild((Node)this.getXmlNode());
        String nName = this.getXmlNode().getNodeName();
        if (!this.getIsColumnLevelConstraint() && parentNode.getChildNodes().getLength() == 2) {
            parentNode.getParentNode().removeChild((Node)parentNode);
        }
    }

    void markAsRemoved() {
        XMLTableConstraintsAccessor.markAsRemoved(this.getXmlNode());
    }

    @Override
    protected String getTypePathElement() {
        return "CONSTRAINTS";
    }

    @Override
    protected int getObjType() {
        return 102;
    }

    @Override
    public String toString() {
        String cType = this.getConstraintType();
        String constrs = "   Name: " + this.getConstraintName() + "\n" + "    Type: " + cType + "\n";
        if (cType.equals("CHECK")) {
            constrs = constrs + "    Condition: " + this.getCheckCondition("CHECK") + "\n";
        } else if (cType.equals("NOT_NULL")) {
            constrs = constrs + "    Not Null column: " + this.getConstrainedColumn() + "\n";
        } else {
            int i;
            boolean first;
            constrs = constrs + "    Columns: ";
            NodeList cols = this.getConstraintColumns();
            if (cols != null) {
                first = true;
                for (i = 0; i < cols.getLength(); ++i) {
                    if (!first) {
                        constrs = constrs + ", ";
                    }
                    constrs = constrs + XMLTableConstraintsAccessor.getColumnName(cols.item(i));
                    first = false;
                }
            }
            constrs = constrs + "\n";
            if (cType.equals("FOREIGN")) {
                constrs = constrs + "    On table: " + this.getRefdSchema("FOREIGN") + "." + this.getRefdTableName() + " (";
                cols = this.getConstraintReferencedColumns();
                if (cols != null) {
                    first = true;
                    for (i = 0; i < cols.getLength(); ++i) {
                        if (!first) {
                            constrs = constrs + ", ";
                        }
                        constrs = constrs + XMLTableConstraintsAccessor.getColumnName(cols.item(i));
                        first = false;
                    }
                }
                constrs = constrs + ")\n";
                if (this.nodeExists(X_FK_CONS_ON_DELETE)) {
                    constrs = constrs + "    On delete: " + this.selectTextValue(X_FK_CONS_ON_DELETE) + "\n";
                }
            }
        }
        constrs = constrs + "    Body: " + this.getConstraintBody() + "\n";
        return constrs;
    }
}

