/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.xml.parser.v2.XMLNode;

public class XMLSegmentAccessor
extends XMLSchemaObjAccessor {
    private static String INDEX = "INDEX";
    private static String TABLE = "TABLE";
    private static String MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    private static String MATERIALIZED_VIEW_LOG = "MATERIALIZED_VIEW_LOG";
    private static String PHYSICAL_PROPERTIES = "PHYSICAL_PROPERTIES";
    private static String TABLE_PROPERTIES = "TABLE_PROPERTIES";
    private static String SEGMENT_ATTRIBUTES = "SEGMENT_ATTRIBUTES";
    private static String INDEX_ATTRIBUTES = "INDEX_ATTRIBUTES";
    private static String PARTITION_LIST_ITEM = "PARTITION_LIST_ITEM";
    private static String SUBPARTITION_LIST_ITEM = "SUBPARTITION_LIST_ITEM";
    private boolean m_defPhysProps;
    private boolean m_forOverflow;
    private static String X_STORAGE_BASE = "sxml:STORAGE";
    private static String X_TABLESPACE = "sxml:TABLESPACE";
    private static String X_PCTFREE = "sxml:PCTFREE";
    private static String X_PCTUSED = "sxml:PCTUSED";
    private static String X_INITRANS = "sxml:INITRANS";
    private static String X_MAXTRANS = "sxml:MAXTRANS";
    private static String X_INITEXT = X_STORAGE_BASE + "/sxml:" + "INITIAL";
    private static String X_NEXT = X_STORAGE_BASE + "/sxml:" + "NEXT";
    private static String X_MINEXT = X_STORAGE_BASE + "/sxml:" + "MINEXTENTS";
    private static String X_MAXEXT = X_STORAGE_BASE + "/sxml:" + "MAXEXTENTS";
    private static String X_PCTINC = X_STORAGE_BASE + "/sxml:" + "PCTINCREASE";
    private static String X_FREELISTS = X_STORAGE_BASE + "/sxml:" + "FREELISTS";
    private static String X_GROUPS = X_STORAGE_BASE + "/sxml:" + "FREELIST_GROUPS";
    private static String X_BUFFER_POOL = X_STORAGE_BASE + "/sxml:" + "BUFFER_POOL";
    private static String X_LOGGING = "sxml:LOGGING";
    private static String X_COMPRESS = "../sxml:COMPRESS";
    private static String X_PCTTHRESHOLD = "../sxml:PCTTHRESHOLD";
    private static String X_KEYCOMPRESS = "../sxml:KEYCOMPRESS";
    private static String X_TABLE_ORG_NODE = "(/sxml:" + TABLE + "/*" + "/sxml:" + PHYSICAL_PROPERTIES + "/sxml:" + "HEAP_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + " | " + "/sxml:" + TABLE + "/*" + "/sxml:" + PHYSICAL_PROPERTIES + "/sxml:" + "INDEX_ORGANIZED_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + ")";
    private static String X_TABLE_PART_ORG_NODE = "(/sxml:" + TABLE + "/*" + "/sxml:" + TABLE_PROPERTIES + "/*" + "/sxml:" + "DEFAULT_PHYSICAL_PROPERTIES" + "/sxml:" + "HEAP_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + " | " + "/sxml:" + TABLE + "/*" + "/sxml:" + TABLE_PROPERTIES + "/*" + "/sxml:" + "DEFAULT_PHYSICAL_PROPERTIES" + "/sxml:" + "INDEX_ORGANIZED_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + ")";
    private static String X_MV_ORG_NODE = "(/sxml:" + MATERIALIZED_VIEW + "/sxml:" + PHYSICAL_PROPERTIES + "/sxml:" + "HEAP_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + " | " + "/sxml:" + MATERIALIZED_VIEW + "/sxml:" + PHYSICAL_PROPERTIES + "/sxml:" + "INDEX_ORGANIZED_TABLE" + "/sxml:" + SEGMENT_ATTRIBUTES + ")";
    private static String X_INDEX_ATTRIBUTES = "/sxml:" + INDEX + "/*" + "/sxml:" + INDEX_ATTRIBUTES;
    private static String X_PART_SEGATTS_NODE = "(sxml:" + SEGMENT_ATTRIBUTES + " | " + "sxml:" + PHYSICAL_PROPERTIES + "/*" + "/sxml:" + SEGMENT_ATTRIBUTES + ")";
    private static String X_PART_OVER_SEGATTS_NODE = "sxml:" + PHYSICAL_PROPERTIES + "/sxml:" + "INDEX_ORGANIZED_TABLE" + "/sxml:" + "OVERFLOW" + "/sxml:" + SEGMENT_ATTRIBUTES;

    protected XMLSegmentAccessor() {
    }

    protected XMLSegmentAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    XMLSegmentAccessor(XMLNode xmlNode, XMLAccessorClient client, boolean forOverflow) throws XMLAccessorException {
        super(client);
        this.m_forOverflow = forOverflow;
        this.initialize(xmlNode);
    }

    @Override
    protected String getTypePathElement() {
        return "SEGMENT";
    }

    @Override
    public void setXmlDoc(XMLNode xmlDoc) throws XMLAccessorException {
        if (XMLSegmentAccessor.nodeExists(this.getXmlRoot(), "sxml:" + TABLE)) {
            XMLNode startNode = XMLSegmentAccessor.getNode(this.getXmlRoot(), X_TABLE_ORG_NODE);
            if (startNode != null) {
                this.setXmlNode(startNode);
                this.m_defPhysProps = false;
            } else {
                startNode = XMLSegmentAccessor.getNode(this.getXmlRoot(), X_TABLE_PART_ORG_NODE);
                if (startNode != null) {
                    this.setXmlNode(startNode);
                    this.m_defPhysProps = true;
                }
            }
        } else if (XMLSegmentAccessor.nodeExists(this.getXmlRoot(), "sxml:" + MATERIALIZED_VIEW)) {
            XMLNode startNode = XMLSegmentAccessor.getNode(this.getXmlRoot(), X_MV_ORG_NODE);
            if (startNode != null) {
                this.setXmlNode(startNode);
                this.m_defPhysProps = false;
            } else {
                System.out.println("Couldn't find place to attach segment accessor in MV");
            }
        } else if (XMLSegmentAccessor.nodeExists(this.getXmlRoot(), "sxml:" + MATERIALIZED_VIEW_LOG)) {
            this.setXmlNode(XMLSegmentAccessor.getNode(this.getXmlRoot(), "/sxml:" + MATERIALIZED_VIEW_LOG + "/sxml:" + SEGMENT_ATTRIBUTES));
            this.m_defPhysProps = false;
        } else if (XMLSegmentAccessor.nodeExists(this.getXmlRoot(), "sxml:" + INDEX)) {
            XMLNode attsNode = XMLSegmentAccessor.getNode(this.getXmlRoot(), X_INDEX_ATTRIBUTES);
            if (attsNode != null) {
                this.setXmlNode(attsNode);
                this.m_defPhysProps = false;
            }
        } else if (this.getXmlRoot().getNodeName().equals(PARTITION_LIST_ITEM)) {
            String path = this.m_forOverflow ? X_PART_OVER_SEGATTS_NODE : X_PART_SEGATTS_NODE;
            XMLNode segattsNode = XMLSegmentAccessor.getNode(xmlDoc, path);
            this.setXmlNode(segattsNode);
            this.m_defPhysProps = false;
        } else if (this.getXmlRoot().getNodeName().equals(SUBPARTITION_LIST_ITEM)) {
            this.setXmlNode(xmlDoc);
            this.m_defPhysProps = false;
        }
    }

    public String getTblspcName() {
        return this.selectTextValue(X_TABLESPACE);
    }

    public void setTblspcName(String name) {
        this.setTextValue(X_TABLESPACE, name);
    }

    @Override
    public void setTablespace(String tablespace) {
        this.setTblspcName(tablespace);
    }

    @Override
    public String getTablespace() {
        return this.getTblspcName();
    }

    public String getPctFree() {
        return this.selectTextValue(X_PCTFREE);
    }

    public void setPctFree(String percentFree) {
        this.setTextValue(X_PCTFREE, percentFree);
    }

    public String getPctUsed() {
        return this.selectTextValue(X_PCTUSED);
    }

    public void setPctUsed(String percentUsed) {
        this.setTextValue(X_PCTUSED, percentUsed);
    }

    public String getInitTrans() {
        return this.selectTextValue(X_INITRANS);
    }

    public void setIniTrans(String initTrans) {
        this.setTextValue(X_INITRANS, initTrans);
    }

    public String getMaxTrans() {
        return this.selectTextValue(X_MAXTRANS);
    }

    public void setMaxTrans(String maxTrans) {
        this.setTextValue(X_MAXTRANS, maxTrans);
    }

    public String getInitExt() {
        return this.selectTextValue(X_INITEXT);
    }

    public void setInitExt(String initExtent) {
        this.setTextValue(X_INITEXT, initExtent);
    }

    public String getNextExt() {
        return this.selectTextValue(X_NEXT);
    }

    public void setNextExt(String nextExtent) {
        this.setTextValue(X_NEXT, nextExtent);
    }

    public String getMinExt() {
        return this.selectTextValue(X_MINEXT);
    }

    public void setMinExt(String minExtent) {
        this.setTextValue(X_MINEXT, minExtent);
    }

    public String getMaxExt() {
        return this.selectTextValue(X_MAXEXT);
    }

    public void setMaxExt(String maxExtent) {
        this.setTextValue(X_MAXEXT, maxExtent);
    }

    public String getPctInc() {
        return this.selectTextValue(X_PCTINC);
    }

    public void setPctInc(String pctIncrease) {
        this.setTextValue(X_PCTINC, pctIncrease);
    }

    public String getLists() {
        return this.selectTextValue(X_FREELISTS);
    }

    public void setLists(String freelists) {
        this.setTextValue(X_FREELISTS, freelists);
    }

    public String getGroups() {
        return this.selectTextValue(X_GROUPS);
    }

    public void setGroups(String freeListGroups) {
        this.setTextValue(X_GROUPS, freeListGroups);
    }

    public String getBufferPool() {
        return this.selectTextValue(X_BUFFER_POOL);
    }

    public int getLogging() {
        int logging = -1;
        String sn = this.selectTextValue(X_LOGGING);
        logging = sn != null && sn.equals("Y") ? 1 : 0;
        return logging;
    }

    public void setLogging(String logging) {
        this.setTextValue(X_LOGGING, logging);
    }

    public void setCompressionEnabled(boolean enabled) {
        this.setTextValue(X_KEYCOMPRESS, enabled ? "Y" : "N");
    }

    public void setPrefixLength(int prefixLength) {
        this.setTextValue(X_KEYCOMPRESS, Integer.toString(prefixLength));
    }

    public String getCompress() {
        String sn = this.selectTextValue(X_COMPRESS);
        if (sn != null && !sn.equals("N")) {
            return "1";
        }
        return "0";
    }

    public String getIOTPctThreshold() {
        return this.selectTextValue(X_PCTTHRESHOLD);
    }

    public void setIOTPctThreshold(short pctThreshold) {
        this.setTextValue(X_PCTTHRESHOLD, Short.toString(pctThreshold));
    }

    public String getIOTCompress() {
        String sn = XMLSegmentAccessor.selectTextValue(this.getXmlNode(), X_KEYCOMPRESS);
        if (sn != null) {
            return sn;
        }
        return "0";
    }

    @Override
    public String toString() {
        String attrs = this.getAttrs();
        if (this.m_defPhysProps) {
            return "  Default physical properties:\n" + attrs;
        }
        return "  Segment attributes:\n" + attrs;
    }

    protected String getAttrs() {
        return this.getAttrs("");
    }

    protected String getAttrs(String indent) {
        boolean dp = this.m_defPhysProps;
        StringBuffer attrs = new StringBuffer();
        attrs.append(indent).append("   Tablespace: ").append(this.getTblspcName()).append("\n").append(indent).append("   PctFree: ").append(this.getPctFree()).append("\n").append(indent).append("   PctUsed: ").append(this.getPctUsed()).append("\n").append(indent).append("   IniTrans: ").append(this.getInitTrans()).append("\n");
        if (!dp) {
            attrs.append(indent).append("   MaxTrans: ").append(this.getMaxTrans()).append("\n");
        }
        attrs.append(indent).append("   Storage:\n");
        if (!dp) {
            attrs.append(indent).append("    Initial: ").append(this.getInitExt()).append("\n").append(indent).append("    Next: ").append(this.getNextExt()).append("\n").append(indent).append("    MinExtents: ").append(this.getMinExt()).append("\n").append(indent).append("    MaxExtents: ").append(this.getMaxExt()).append("\n").append(indent).append("    PctIncrease: ").append(this.getPctInc()).append("\n").append(indent).append("    FreeLists: ").append(this.getLists()).append("\n").append(indent).append("    FreeListGroups: ").append(this.getGroups()).append("\n");
        }
        attrs.append(indent).append("    BufferPool: ").append(this.getBufferPool()).append("\n");
        if (!dp) {
            attrs.append(indent).append("   Logging: ").append(this.getLogging()).append("\n").append(indent).append("   Compress: ").append(this.getCompress()).append("\n");
        }
        return attrs.toString();
    }
}

