/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.HashMap;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.xml.parser.v2.XMLNode;

public class XMLMViewLogAccessor
extends XMLSchemaObjAccessor {
    private XMLSegmentAccessor m_segment = null;
    private static final String X_MASTER_NAME = "sxml:ON_TABLE/sxml:NAME";
    private static final String X_MASTER_SCHEMA = "sxml:ON_TABLE/sxml:SCHEMA";
    private static final String X_PRIMARY_KEY = "sxml:RECORDS/sxml:PRIMARY_KEY";
    private static final String X_ROWID = "sxml:RECORDS/sxml:ROWID";
    private static final String X_SEQUENCE = "sxml:RECORDS/sxml:SEQUENCE";
    private static final String X_PARALLEL = "sxml:PARALLEL";
    private static final String X_PARALLEL_DEGREE = "sxml:PARALLEL_DEGREE";
    private static final String X_INCLUDE_NEW_VALUES = "sxml:INCLUDING_NEW_VALUES";
    private static final String X_FC_LIST = "sxml:RECORDS/sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:NAME";

    protected XMLMViewLogAccessor() {
    }

    protected XMLMViewLogAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.initializeSegments();
    }

    private void initializeSegments() throws XMLAccessorException {
        XMLAccessor accessor = XMLMViewLogAccessor.getXMLAccessorForType(101, this.getXmlRoot(), this.getAccessorClient());
        this.m_segment = (XMLSegmentAccessor)accessor;
    }

    @Override
    protected String getTypePathElement() {
        return "MATERIALIZED_VIEW_LOG";
    }

    @Override
    protected boolean isDependentType() {
        return true;
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        super.applySchemaMap(schemaMap, changeMode);
        String onSchema = this.getOnTableSchema();
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setOnTableSchema((String)schemaMap.get(onSchema), changeMode);
        }
    }

    @Override
    public String getSchema() {
        return this.getOnTableSchema();
    }

    @Override
    public String getName() {
        return XMLMViewLogAccessor.getMViewLogNameFromMstrTblName(this.getOnTableName());
    }

    public static String getMViewLogNameFromMstrTblName(String mtName) {
        String mvlName = "MLOG$_" + mtName;
        if (mvlName.length() > 30) {
            mvlName = mvlName.substring(0, 30);
        }
        return mvlName;
    }

    public String getOnTableSchema() {
        return this.selectTextValue(X_MASTER_SCHEMA);
    }

    public void setOnTableSchema(String schema) {
        this.setTextValue(X_MASTER_SCHEMA, schema);
    }

    private void setOnTableSchema(String schema, int changeMode) {
        this.setTextValue(X_MASTER_SCHEMA, schema, changeMode);
    }

    public String getOnTableName() {
        return this.selectTextValue(X_MASTER_NAME);
    }

    public boolean getUsePrimaryKey() {
        return this.nodeExists(X_PRIMARY_KEY);
    }

    public String getDegreeStr() {
        String degree = null;
        if (this.nodeExists(X_PARALLEL)) {
            degree = this.selectTextValue(X_PARALLEL);
        } else if (this.nodeExists(X_PARALLEL_DEGREE)) {
            degree = this.selectTextValue("sxml:PARALLEL_DEGREE/sxml:DEGREE");
        }
        return degree;
    }

    public boolean getUseRowID() {
        return this.nodeExists(X_ROWID);
    }

    public boolean getUseNewValue() {
        return this.nodeExists(X_INCLUDE_NEW_VALUES);
    }

    public boolean getUseSequenceValue() {
        return this.nodeExists(X_SEQUENCE);
    }

    public String[] getFilterColumns() {
        return this.selectTextValues(X_FC_LIST);
    }

    @Override
    public String getDropDDL() {
        String dropDdl = "DROP MATERIALIZED VIEW LOG ON \"" + this.getOnTableSchema() + "\".\"" + this.getOnTableName() + "\";";
        return dropDdl;
    }

    @Override
    protected String getParallelPath() {
        return X_PARALLEL;
    }

    @Override
    protected String getParallelDegreePath() {
        return X_PARALLEL_DEGREE;
    }

    @Override
    protected String getParallelDegreeDegreePath() {
        return "sxml:PARALLEL_DEGREE/sxml:DEGREE";
    }

    @Override
    public String toString() {
        String segatts = "";
        if (this.m_segment != null) {
            segatts = this.m_segment.toString();
        }
        return super.toString() + "  On Table: " + this.getOnTableSchema() + "." + this.getOnTableName() + "\n" + "  Primary Key: " + XMLMViewLogAccessor.YorN(this.getUsePrimaryKey()) + "\n" + "  Degree: " + this.nin(this.getDegreeStr()) + "\n" + "  RowID: " + XMLMViewLogAccessor.YorN(this.getUseRowID()) + "\n" + "  Use New Value: " + XMLMViewLogAccessor.YorN(this.getUseNewValue()) + "\n" + "  Use Sequence Value: " + XMLMViewLogAccessor.YorN(this.getUseSequenceValue()) + "\n" + "  Filter columns: " + this.getFilterColumns() + "\n" + segatts;
    }
}

