/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccess;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.xml.parser.v2.XMLDocument;

public class CPDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String hps;
        String cString;
        if (args.length < 1) {
            System.err.println("No argument(s) supplied");
            CPDemo.usage();
            System.exit(0);
        }
        if ((cString = CPDemo.getURL(hps = args[0])) == null) {
            System.err.println("No URL generated, args[0]: " + args[0]);
            CPDemo.usage();
            System.exit(0);
        }
        String user = null;
        String pwd = null;
        if (args.length >= 3 && args[1] != null && args[2] != null) {
            user = args[1].toUpperCase();
            pwd = args[2];
        } else {
            user = CPDemo.getUsername(hps).toUpperCase();
            pwd = CPDemo.getPassword(hps);
        }
        if (user == null) {
            user = "SYSMAN";
        }
        if (pwd == null) {
            pwd = "sysman";
        }
        boolean regtestMode = false;
        String testNum = null;
        String testSchema = "CPAPI_TEST";
        String cpName = "CP1";
        if (args.length >= 4 && args[3] != null && args[3].length() > 0) {
            regtestMode = true;
            testNum = args[3];
            testSchema = "CM_CPTEST_" + testNum;
            cpName = "CMCPChangePlan" + testNum;
        }
        ChangePlanAccess cpAccess = new ChangePlanAccess();
        try {
            cpAccess.login(user, pwd, cString);
            System.out.println("Logged in as " + user);
            boolean connValid = cpAccess.isValidConnection();
            System.out.println(" The connection is " + (connValid ? "" : "NOT ") + "valid.");
            boolean wasRemoved = true;
            try {
                cpAccess.removeChangePlan(cpName, user);
            }
            catch (ChangePlanAccessException cpe) {
                if (cpe.getReason() == 4) {
                    wasRemoved = false;
                }
                throw cpe;
            }
            if (wasRemoved) {
                System.out.println("Change plan " + cpName + " owned by " + user + " was removed.");
            } else {
                System.out.println("Change plan " + cpName + " owned by " + user + " was not " + "removed because it doesn't exist.");
            }
            ChangePlanInfo cpInfo = new ChangePlanInfo(cpName, user);
            cpInfo.setPlanDescription("This is a change plan created by CPDemo");
            cpAccess.createChangePlan(cpInfo);
            System.out.println("Change plan " + cpName + " owned by " + user + " was created.");
            ChangePlan cp = cpAccess.getOneChangePlan(cpName, user);
            System.out.println("Retrieved ChangePlan object just created:");
            System.out.println(cp.toString());
            String preScript = "create table " + testSchema + ".cpapi_temp (c1 number);\n" + "insert into " + testSchema + ".cpapi_temp (c1) select c1 from " + testSchema + ".cpapi_test2;\n" + "commit;";
            String postScript = "insert into " + testSchema + ".cpapi_test1 (c1) select c1*2 from " + testSchema + ".cpapi_temp;\n" + "drop table " + testSchema + ".cpapi_temp;\n" + "commit;";
            cp.setPreScript(preScript);
            cp.setPostScript(postScript);
            String retPre = cp.getPreScript();
            String retPost = cp.getPostScript();
            if (preScript.equals(retPre) && postScript.equals(retPost)) {
                System.out.println("Pre- and post-script tests succeeded.");
            } else {
                System.out.println("Pre- and post-script tests failed:");
                System.out.println(" retPre: " + retPre);
                System.out.println(" retPost: " + retPost);
                System.err.println("Pre- and post-script tests failed.");
            }
            OracleDataSource ods = new OracleDataSource();
            String tcString = cString;
            String tcUser = "SYSTEM";
            String tcPwd = "MANAGER";
            if (args.length >= 5 && args[4] != null && args[4].length() > 0) {
                String tcHPS = args[4];
                tcString = CPDemo.getURL(tcHPS);
                tcUser = CPDemo.getUsername(tcHPS);
                tcPwd = CPDemo.getPassword(tcHPS);
            }
            ods.setURL(tcString);
            ods.setUser(tcUser);
            ods.setPassword(tcPwd);
            OracleConnection conn = (OracleConnection)ods.getConnection();
            CMConnection cmConn = new CMConnection(conn);
            Statement dmlStmt = cmConn.createStatement();
            String secureTestSchema = null;
            PreparedStatement q = null;
            ResultSet rs = null;
            try {
                q = cmConn.prepareStatement("select dbms_assert.simple_sql_name(?) from dual");
                q.setString(1, testSchema);
                rs = q.executeQuery();
                if (rs.next()) {
                    secureTestSchema = rs.getString(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (q != null) {
                    q.close();
                }
            }
            if (!regtestMode) {
                CPDemo.createTestSchema(dmlStmt, secureTestSchema);
                dmlStmt.execute("create table " + secureTestSchema + ".cpapi_test1 (c1 number)");
                dmlStmt.execute("comment on table " + secureTestSchema + ".cpapi_test1 is 'Comment on table cpapi_test1'");
                dmlStmt.execute("comment on column " + secureTestSchema + ".cpapi_test1.c1 is 'Comment on column cpapi_test1.c1'");
                dmlStmt.execute("create table " + secureTestSchema + ".cpapi_test2 (c1 number)");
                dmlStmt.execute("create table " + secureTestSchema + ".cpapi_test3 (c1 number)");
                dmlStmt.execute("create table " + secureTestSchema + ".cpapi_test4 (c1 number)");
                dmlStmt.execute("create or replace function " + secureTestSchema + ".f1 ( p_mult in number ) " + "return number as \n" + "  m_count number;\n" + "  begin\n" + "    select count(*) into m_count from cpapi_test4;\n" + "    return p_mult * m_count;\n" + "  end;\n");
                dmlStmt.execute("create table " + secureTestSchema + ".cpapi_mvltest( " + " c1 number primary key, " + " c2 number)");
                dmlStmt.execute("create materialized view log on " + secureTestSchema + ".cpapi_mvltest");
            }
            XMLAccessorSettings xacImpl = new XMLAccessorSettings();
            xacImpl.setXslRoot(System.getProperty("WEB_INF_ROOT"));
            XMLAccessor xa = null;
            XMLDocument tDoc1 = null;
            XMLDocument tDoc2 = null;
            ChangeItem ci = null;
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_TEST1", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(1, ChangeItemInfo.TABLE, "CPAPI_TEST1", secureTestSchema, "This is an Add change item for " + secureTestSchema + ".CPAPI_TEST1", tDoc1, null, xacImpl);
            String ciDDL = ci.getDDL(xacImpl);
            System.out.println("DDL for Create change item:");
            System.out.println(ciDDL);
            cp.addChangeItem(ci);
            xa = XMLAccessor.getXMLAccessorForType(8, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "F1", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(4, ChangeItemInfo.FUNCTION, "F1", secureTestSchema, "FUNCTION Change Item", tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            ciDDL = ci.getDDL(xacImpl);
            System.out.println("\nDDL for Function Monitor-type change item:");
            System.out.println(ciDDL);
            dmlStmt.execute("create or replace function " + secureTestSchema + ".f1 ( p_add in number ) " + "return number as \n" + "  m_count number;\n" + "  begin\n" + "    select count(*) into m_count from cpapi_test4;\n" + "    return p_add + m_count;\n" + "  end;\n");
            xa = XMLAccessor.getXMLAccessorForType(8, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "F1", true);
            tDoc2 = xa.getDocument();
            ci.convertChangeItem(2, tDoc2, xacImpl);
            cp.updateChangeItem(ci);
            ciDDL = ci.getDDL(xacImpl);
            System.out.println("\nDDL for modified Function change item:");
            System.out.println(ciDDL);
            ci = cp.getOneChangeItem(ci);
            if (ci != null) {
                dmlStmt.execute("create or replace function " + secureTestSchema + ".f1 ( p_sub in number ) " + "return number as \n" + "  m_count number;\n" + "  begin\n" + "    select count(*) into m_count from cpapi_test4;\n" + "    return  m_count - p_sub;\n" + "  end;\n");
                xa = XMLAccessor.getXMLAccessorForType(8, xacImpl);
                xa.initFromDatabase(cmConn, secureTestSchema, "F1", true);
                tDoc2 = xa.getDocument();
                ci.updateDefinition(tDoc2, xacImpl);
                cp.updateChangeItem(ci);
                ciDDL = ci.getDDL(xacImpl);
                System.out.println("\nDDL for twice- modified Function change item:");
                System.out.println(ciDDL);
            } else {
                System.out.println("Failed to retrieve change item for function F1");
            }
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_TEST2", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(4, ChangeItemInfo.TABLE, "CPAPI_TEST2", secureTestSchema, "Monitoring table " + secureTestSchema + ".CPAPI_TEST2", tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            dmlStmt.execute("alter table " + secureTestSchema + ".cpapi_test2 add (newcol varchar2(20))");
            dmlStmt.execute("alter table " + secureTestSchema + ".cpapi_test2 nologging");
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_TEST2", true);
            tDoc2 = xa.getDocument();
            ci.convertChangeItem(2, tDoc2, xacImpl);
            ci.setDescription("This is a Modify change item");
            ci.setClientSourceDatabase("BogusClientSourceDatabase");
            ci.setEntMgrSourceDatabase("BogusEnterpriseMgrSourceDatabase");
            ci.setGlobalSourceDatabase("BogusGlobalSourceDatabase");
            cp.updateChangeItem(ci);
            System.out.println("Added Modify change item for " + secureTestSchema + ".CPAPI_TEST2 to change plan " + cpName);
            try {
                ci.getDefinition().print((OutputStream)System.out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ciDDL = ci.getDDL(xacImpl);
            System.out.println("DDL for Modify change item:");
            System.out.println(ciDDL);
            ChangeItem modCi = ci;
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_TEST3", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(4, ChangeItemInfo.TABLE, "CPAPI_TEST3", secureTestSchema, null, tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            ci.convertChangeItem(3, null, xacImpl);
            cp.updateChangeItem(ci);
            ciDDL = ci.getDDL(xacImpl);
            System.out.println("DDL for Drop change item:");
            System.out.println(ciDDL);
            if (modCi != null) {
                ChangeItem createdCi = cp.getOneChangeItem(modCi);
                if (createdCi != null) {
                    System.out.println("Retrieved change item just created");
                    System.out.println(createdCi.toString());
                } else {
                    System.out.println("Failed to retrieve Change Item just created");
                    System.err.println("Failed to retrieve Change Item just created");
                }
                createdCi.convertChangeItem(4, null, xacImpl);
                System.out.println("\nModify change item converted back to Monitor");
                System.out.println(createdCi.toString());
            }
            xa = XMLAccessor.getXMLAccessorForType(0, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_TEST4", true);
            tDoc1 = xa.getDocument();
            ci = new ChangeItem(4, ChangeItemInfo.TABLE, "CPAPI_TEST4", secureTestSchema, "Monitoring table " + secureTestSchema + ".CPAPI_TEST4", tDoc1, null, xacImpl);
            cp.addChangeItem(ci);
            xa = XMLAccessor.getXMLAccessorForType(12, xacImpl);
            xa.initFromDatabase(cmConn, secureTestSchema, "CPAPI_MVLTEST", true);
            ci = new ChangeItem(1, ChangeItemInfo.MATERIALIZED_VIEW_LOG, "CPAPI_MVLTEST", secureTestSchema, null, xa.getDocument(), null, xacImpl);
            cp.addChangeItem(ci);
            cpAccess.logout();
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException se) {
            System.err.println("Caught SQLException " + se.getErrorCode() + ": " + se.toString());
            se.printStackTrace();
            System.exit(0);
        }
        catch (ChangePlanAccessException cpe) {
            System.err.println("Caught ChangePlanAccessException, reason: " + cpe.getReason());
            if (cpe.getCause() != null) {
                cpe.getCause().printStackTrace(System.out);
            }
            cpe.printStackTrace(System.out);
            System.exit(0);
        }
        catch (XMLAccessorException xae) {
            System.err.println("Caught XMLAccessorException:");
            xae.printStackTrace(System.out);
            System.exit(0);
        }
        if (regtestMode) {
            System.err.println("Test tvmdmbbw" + testNum + " change plan creation succeeded.");
        }
    }

    private static void usage() {
        System.out.println("Usage: CPDemo repos-host:port:sid [username password]");
    }

    private static void createTestSchema(Statement stmt, String schema) throws SQLException {
        block2: {
            try {
                stmt.execute("drop user " + schema + " cascade");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 1918) break block2;
                throw se;
            }
        }
        stmt.execute("create user " + schema + " identified by " + schema);
        stmt.execute("grant connect, resource, unlimited tablespace to " + schema);
    }

    private static String getURL(String hps) {
        String url = null;
        if (hps != null) {
            int colon1 = hps.indexOf(":");
            int colon2 = hps.indexOf(":", colon1 + 1);
            int colon3 = hps.indexOf(":", colon2 + 1);
            if (colon1 > 0 && colon2 > colon1) {
                String host = hps.substring(0, colon1);
                String port = hps.substring(colon1 + 1, colon2);
                String sid = colon3 > colon2 ? hps.substring(colon2 + 1, colon3) : hps.substring(colon2 + 1);
                url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
            }
        }
        return url;
    }

    private static String getUsername(String hps) {
        String username = null;
        int slashPos = hps.lastIndexOf("/");
        if (slashPos != -1) {
            int colPos = hps.lastIndexOf(":", slashPos);
            username = hps.substring(colPos + 1, slashPos);
        }
        return username;
    }

    private static String getPassword(String hps) {
        String pwd = null;
        int slashPos = hps.lastIndexOf("/");
        if (slashPos != -1) {
            pwd = hps.substring(slashPos + 1);
        }
        return pwd;
    }
}

