/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

public enum HttpHeader implements CharSequence
{
    ACCEPT_LANGUAGE("Accept-Language"),
    ALLOW("Allow"),
    AUTHORIZATION("Authorization"),
    CONTENT_DISPOSITION("Content-Disposition"),
    CONTENT_LENGTH("Content-Length"),
    CONTENT_LOCATION("Content-Location"),
    CONTENT_TYPE("Content-Type"),
    COOKIE("Cookie"),
    ETAG("ETag"),
    IF_MATCH("If-Match"),
    IF_NONE_MATCH("If-None-Match"),
    LAST_MODIFIED("Last-Modified"),
    LOCATION("Location"),
    REFERRER("Referer"),
    SERVER("Server"),
    SET_COOKIE("Set-Cookie"),
    WWW_AUTHENTICATE("WWW-Authenticate");

    private final String text;

    private HttpHeader(String text) {
        this.text = text;
    }

    @Override
    public char charAt(int index) {
        return this.text().charAt(index);
    }

    @Override
    public int length() {
        return this.text().length();
    }

    public boolean matches(CharSequence name) {
        return this.text().equalsIgnoreCase(name.toString());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.text().subSequence(start, end);
    }

    public String text() {
        return this.text;
    }

    @Override
    public String toString() {
        return this.text();
    }
}

