/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.rt.validation.ConstraintDescriptor;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.ConstraintViolationImpl;
import oracle.dbtools.rt.validation.PathImpl;

class ViolationsBuilder<T> {
    private final PathImpl path = PathImpl.path();
    private final T rootBean;
    private final Set<ConstraintViolation<T>> violations = new LinkedHashSet<ConstraintViolation<T>>();

    ViolationsBuilder(T rootBean) {
        this.rootBean = rootBean;
    }

    void enter(String name, boolean indexed) {
        this.path.node(name, indexed ? Integer.valueOf(0) : null);
    }

    void exit() {
        this.path.exit();
    }

    void next() {
        this.path.next();
    }

    void violation(Object invalidValue, ConstraintDescriptor<?> constraintDescriptor) {
        this.violations.add(new ConstraintViolationImpl<T>(this.rootBean, this.path.copy(), invalidValue, constraintDescriptor));
    }

    Set<ConstraintViolation<T>> violations() {
        return this.violations;
    }
}

