/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.rt.validation.Path;

class PathImpl
implements Path {
    private final List<Path.Node> nodes = new ArrayList<Path.Node>();

    private PathImpl() {
    }

    @Override
    public Iterator<Path.Node> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int pos = 0;
        int size = this.nodes.size();
        for (Path.Node n : this.nodes) {
            String text = n.toString();
            if (!text.isEmpty()) {
                b.append(text);
                if (pos < size - 1) {
                    b.append('.');
                }
            }
            ++pos;
        }
        return b.toString();
    }

    PathImpl copy() {
        PathImpl path = new PathImpl();
        path.nodes.addAll(this.nodes);
        return path;
    }

    void exit() {
        this.nodes.remove(this.nodes.size() - 1);
    }

    void next() {
        Path.Node n = this.nodes.get(this.nodes.size() - 1);
        this.exit();
        this.node(n.getName(), n.getIndex() + 1);
    }

    void node(String name, Integer index) {
        this.nodes.add(new NodeImpl(name, index));
    }

    static PathImpl path() {
        PathImpl path = new PathImpl();
        path.node(null, null);
        return path;
    }

    private static class NodeImpl
    implements Path.Node {
        private final Integer index;
        private final String name;

        NodeImpl(String name, Integer index) {
            this.name = name;
            this.index = index;
        }

        @Override
        public Integer getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isInIterable() {
            return this.index != null;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.name != null) {
                b.append(this.name);
                if (this.index != null) {
                    b.append('[');
                    b.append(this.index);
                    b.append(']');
                }
            }
            return b.toString();
        }
    }
}

