/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.tenants;

import java.security.Principal;
import java.util.Iterator;
import oracle.dbtools.common.ecid.ECIDPrincipals;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

public abstract class Tenants {
    private static final CompoundPrincipal ANONYMOUS = CompoundPrincipal.compound((Principal[])new Principal[]{AnonymousPrincipal.ANONYMOUS});

    private Tenants() {
    }

    @Deprecated
    public static CompoundPrincipal anonymousTenant(String tenantIdentifier) {
        return Tenants.tenant(ECIDPrincipals.ecidPrincipal((CompoundPrincipal)ANONYMOUS), tenantIdentifier);
    }

    public static CompoundPrincipal tenant(CompoundPrincipal existing, String tenantIdentifier) {
        Iterable tenantProviders = ServiceLocator.acquireAll(TenantsProvider.class, (String[])new String[0]);
        if (NullOrEmpty.nullOrEmpty((Iterable)tenantProviders) || null == existing || NullOrEmpty.nullOrEmpty((CharSequence)tenantIdentifier)) {
            return existing;
        }
        TenantPrincipal tenant = Tenants.tenant(existing, tenantIdentifier, (Iterable<TenantsProvider>)tenantProviders);
        CompoundPrincipal mutated = existing.replace(TenantPrincipal.class, (Principal)tenant);
        return mutated;
    }

    public static RequestEntity tenant(RequestEntity request, String tenantIdentifier) {
        Iterable tenantProviders = ServiceLocator.acquireAll(TenantsProvider.class, (String[])new String[0]);
        return Tenants.tenant(request, tenantIdentifier, (Iterable<TenantsProvider>)tenantProviders);
    }

    private static RequestEntity tenant(RequestEntity request, String tenantIdentifier, Iterable<TenantsProvider> tenantProviders) {
        CompoundPrincipal principal = request.principal();
        TenantPrincipal tenant = Tenants.tenant(principal, tenantIdentifier, tenantProviders);
        return Requests.replacePrincipal(request, tenant, TenantPrincipal.class);
    }

    static TenantPrincipal tenant(CompoundPrincipal principal, String tenantIdentifier, Iterable<TenantsProvider> tenantProviders) {
        TenantsProvider provider;
        if (tenantIdentifier == null) {
            return TenantPrincipal.noTenant();
        }
        TenantPrincipal tenant = null;
        Iterator<TenantsProvider> i$ = tenantProviders.iterator();
        while (i$.hasNext() && (tenant = (provider = i$.next()).tenant(principal, tenantIdentifier)) == null) {
        }
        if (tenant == null) {
            tenant = TenantPrincipal.noTenant();
        }
        return tenant;
    }
}

