/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;

class SequencedReader
implements X3PReader {
    private X3PReader current;
    private final Iterator<X3PReader> readers;

    SequencedReader(Iterator<X3PReader> readers) {
        this.readers = readers;
        this.advance();
    }

    public void close() throws IOException {
        Closeables.close((Object)this.current);
        Closeables.close(this.readers);
    }

    public X3PHandler getHandler() {
        return this.current.getHandler();
    }

    public boolean next() throws IOException {
        if (this.current == null) {
            return false;
        }
        boolean hasNext = this.current.next();
        if (!hasNext) {
            this.advance();
        }
        return this.current != null;
    }

    public void setHandler(X3PHandler handler) {
        if (this.current != null) {
            this.current.setHandler(handler);
        }
    }

    private void advance() {
        X3PReader r = null;
        while (this.readers.hasNext() && r == null) {
            r = this.readers.next();
        }
        if (r != null && this.current != null) {
            r.setHandler(this.current.getHandler());
        }
        this.current = r;
    }
}

