/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.errors.SQLExceptions;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.dispatch.DispatchableResourceType;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplateRequest;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesJDBCPrincipal;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service
public final class ResourceTemplatesDispatcher {
    @Reference(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="header/etag")})
    private ResourceGenerator etag;
    public static final String ETAG_GENERATOR = "header/etag";

    public ResourceDispatcher.Score canDispatch(HasResourceTemplates resourceTemplates, RequestEntity request) {
        CompoundPrincipal principal = request.principal();
        ResourceTemplateMatch match = resourceTemplates.resourceTemplate(principal, request.path());
        if (match == null) {
            return ResourceDispatcher.NO_MATCH;
        }
        ResourceTemplate template = match.template();
        Requests.log(request, template.uriTemplate() + " matches: " + request.path() + " score: " + template.uriTemplate().priority());
        return new ResourceDispatcher.Score(DispatchableResourceType.USER_DEFINED_RESOURCE, template.uriTemplate().priority(), match.securityConfig(), (Object)match, match.module().originsAllowed(), match.corsEnabled());
    }

    public HttpResource dispatch(HasResourceTemplates resourceTemplates, ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        ResourceTemplateMatch match = (ResourceTemplateMatch)score.handle();
        ResourceHandler handler = match.handler(request.method());
        if (handler == null) {
            Requests.log(request, "No handler found for method: " + request.method() + " for path: " + request.path());
            throw WebException.notFound();
        }
        this.validate(request, handler);
        ResourceTemplate template = match.template();
        ResourceHandler etag = template.etag();
        String resourceType = handler.contentType();
        if (resourceType == null) {
            resourceType = "json/query";
        }
        ResourceGenerator generator = this.chooseGenerator(resourceType);
        Requests.log(request, "Using generator: " + generator.getClass().getName());
        String parsingSchema = null;
        ResourceModule module = match.module();
        if (module != null && !this.ignoreParsingSchema(module)) {
            parsingSchema = module.parsingSchema();
        }
        int pageSize = module.itemsPerPage();
        Requests.log(request, "Performing JDBC request as: " + parsingSchema);
        RequestEntity rtRequest = ResourceTemplatesJDBCPrincipal.request(request, parsingSchema, module.name(), template.uriTemplate().toString());
        return new HttpResourceGenerator(template, handler, etag, pageSize, rtRequest, generator);
    }

    private ResourceGenerator chooseGenerator(String resourceType) {
        ResourceGenerator generator = (ResourceGenerator)ServiceLocator.acquire(ResourceGenerator.class, (String[])new String[]{"oracle.dbtools.rt.web.ResourceGenerator", resourceType});
        if (generator == null) {
            throw WebException.notFound();
        }
        return generator;
    }

    private String currentETag(ResourceRequest etag) {
        if (etag == null) {
            return null;
        }
        if (NullOrEmpty.nullOrEmpty((CharSequence)etag.content())) {
            return "";
        }
        return this.etag(etag);
    }

    private String etag(ResourceRequest request) {
        String string;
        Entity entity = null;
        try {
            entity = this.etag.generate(request);
            string = entity.headers().header(HttpHeader.ETAG).value();
        }
        catch (IOException e) {
            try {
                throw UnrecoverableException.unrecoverable((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.close(entity);
                throw throwable;
            }
        }
        Closeables.close((Object)entity);
        return string;
    }

    private boolean ignoreParsingSchema(ResourceModule module) {
        return "!USER_SCHEMA".equals(module.parsingSchema());
    }

    private boolean isRead(ResourceRequest request) {
        return HttpMethod.GET.equals(request.request().method()) || HttpMethod.HEAD.equals(request.request().method());
    }

    private void validate(RequestEntity request, ResourceHandler handler) {
        SecurityConfig securityConfig = new SecurityConfig(handler.securityConstraint(), AuthenticationRealm.RESOURCE_TEMPLATES, LogonRealm.NONE);
        request.verifySecurityConstraint(securityConfig);
        if (!Requests.isRead(request)) {
            Requests.acceptable(request, ContentType.contentTypes(handler.acceptableTypes()));
        }
    }

    public static WebException checkForUnboundParameters(String path) {
        boolean hasUnboundParameters;
        URITemplate mightHaveUnboundParameters = URITemplates.uriTemplate(URLEncoding.decode((String)path));
        boolean bl = hasUnboundParameters = !mightHaveUnboundParameters.parameters().isEmpty();
        if (hasUnboundParameters) {
            return WebException.badRequest(Reason.reason("uri", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ResourceTemplatesDispatcher.1", "Request path contains unbound parameters: {0}", new Object[]{Iterables.join(mightHaveUnboundParameters.parameters(), (String)", ")})));
        }
        return null;
    }

    private static RuntimeException checkForTemplateEvaluationError(URITemplate uriTemplate, RequestEntity request, JDBCException e) {
        String path = request.path();
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof SQLException) {
            WebException mightHaveUnboundParameters = ResourceTemplatesDispatcher.checkForUnboundParameters(path);
            if (mightHaveUnboundParameters == null) {
                SQLException se = (SQLException)cause;
                Requests.log(request, "Error during evaluation of resource template: " + cause.getMessage());
                return WebException.internalError(e, Reason.reason("resource.template.evaluation", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ResourceTemplatesDispatcher.0", "Error during evaluation of resource template: {0} {1}, SQL Error Code: {2}, SQL Error Message: {3}", new Object[]{request.method(), uriTemplate, SQLExceptions.getErrorCode((SQLException)se), se.getMessage()})));
            }
            Requests.log(request, mightHaveUnboundParameters.toString());
            return mightHaveUnboundParameters;
        }
        return e;
    }

    private final class HttpResourceGenerator
    implements HttpResource {
        private final ResourceRequest etag;
        private final ResourceGenerator generator;
        private final ResourceRequest request;
        private final URITemplate uriTemplate;
        private transient String version;

        private HttpResourceGenerator(ResourceTemplate template, ResourceHandler handler, ResourceHandler etag, int itemsPerPage, RequestEntity request, ResourceGenerator generator) {
            this.uriTemplate = template.uriTemplate();
            this.etag = ResourceTemplateRequest.adapt(template, etag, itemsPerPage, request);
            this.request = ResourceTemplateRequest.adapt(template, handler, itemsPerPage, request);
            this.generator = generator;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            try {
                return this.generator.generate(this.request);
            }
            catch (JDBCException e) {
                throw ResourceTemplatesDispatcher.checkForTemplateEvaluationError(this.uriTemplate, this.request.request(), e);
            }
        }

        @Override
        public String version() {
            if (this.version == null) {
                try {
                    if (ResourceTemplatesDispatcher.this.isRead(this.request)) {
                        this.version = ResourceTemplatesDispatcher.this.currentETag(this.etag);
                    }
                }
                catch (JDBCException e) {
                    throw ResourceTemplatesDispatcher.checkForTemplateEvaluationError(this.uriTemplate, this.request.request(), e);
                }
            }
            return this.version;
        }
    }
}

