/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ProtectedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public class JDBCResourceTemplateMatchLoader {
    private final JDBCCallProvider jdbc;
    private static final String CAN_DISPATCH = "select m.id module_id, m.name module_name, m.parsing_schema module_parsing_schema, m.uri_prefix module_uri_prefix, m.privilege_id, m.items_per_page, m.origins_allowed module_origins_allowed, m.status module_status, t.id template_id, t.uri_template template_uri_template, t.priority template_priority, t.etag_type template_etag_type, t.etag_query template_etag_query, t.security_group_id from wwv_flow_rt$modules m, wwv_flow_rt$templates t where m.id = t.module_id and t.security_group_id in (10, :tenant_id) and (m.uri_prefix is null or instr(:path,nvl(m.uri_prefix,''),1) = 1)";
    private static final Statement CAN_DISPATCH_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.query().append((CharSequence)"select m.id module_id, m.name module_name, m.parsing_schema module_parsing_schema, m.uri_prefix module_uri_prefix, m.privilege_id, m.items_per_page, m.origins_allowed module_origins_allowed, m.status module_status, t.id template_id, t.uri_template template_uri_template, t.priority template_priority, t.etag_type template_etag_type, t.etag_query template_etag_query, t.security_group_id from wwv_flow_rt$modules m, wwv_flow_rt$templates t where m.id = t.module_id and t.security_group_id in (10, :tenant_id) and (m.uri_prefix is null or instr(:path,nvl(m.uri_prefix,''),1) = 1)")).parameter("path").build();
    private static final EnabledResourceModule ENABLED_MODULES = new EnabledResourceModule();

    public JDBCResourceTemplateMatchLoader(JDBCCallProvider jdbc) {
        this.jdbc = jdbc;
    }

    public Iterator<ProtectedResourceTemplateMatch> candidates(CompoundPrincipal principal, String path) {
        Iterator<ResultRow> candidates = null;
        try {
            candidates = this.matchingUriPrefix(principal, path);
            Iterator candidateTemplates = Iterators.transform(candidates, (Transform)new AsResourceTemplateMatch(principal));
            return candidateTemplates;
        }
        catch (ConnectionPoolException e) {
            return Iterators.empty();
        }
    }

    private Iterator<ResultRow> matchingUriPrefix(CompoundPrincipal principal, String path) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        JDBCTransaction txn = null;
        JDBCQuery call = null;
        Iterator rows = null;
        try {
            if (TenantPrincipal.hasTenant(tenant)) {
                txn = this.jdbc.transaction((Principal)apexListener);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                JDBCIdentifiers.bind(parameters, principal);
                parameters.put("path", path);
                call = this.jdbc.query((Transaction)txn, CAN_DISPATCH_STMT, false);
                call.bind(parameters);
                rows = call.execute();
                return Iterators.select((Iterator)Iterators.alsoClose((Iterator)rows, (Object[])new Object[]{call, txn}), (Selector)ENABLED_MODULES);
            }
            return Iterators.empty();
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{rows, call, txn});
            throw JDBCException.wrap((SQLException)e);
        }
    }

    private static final class EnabledResourceModule
    implements Selector<ResultRow> {
        private EnabledResourceModule() {
        }

        public Boolean apply(ResultRow row) {
            String parsingSchema = (String)row.get("module_parsing_schema", String.class);
            TenantIdentifier moduleId = JDBCIdentifiers.valueOf(row, "security_group_id", "module_id");
            String status = (String)row.get("module_status", String.class);
            return this.isVisible(moduleId, status, parsingSchema);
        }

        private boolean isVisible(TenantIdentifier moduleId, String status, String parsingSchema) {
            boolean published = "PUBLISHED".equals(status);
            boolean internal = TenantIdentifiers.isInternal(moduleId);
            if (published) {
                if (internal) {
                    return "!USER_SCHEMA".equals(parsingSchema) || "APEX_PUBLIC_USER".equals(parsingSchema);
                }
                return true;
            }
            return false;
        }
    }

    private final class AsResourceTemplateMatch
    implements Transform<ResultRow, ProtectedResourceTemplateMatch> {
        private final CompoundPrincipal principal;

        AsResourceTemplateMatch(CompoundPrincipal principal) {
            this.principal = principal;
        }

        public JDBCResourceTemplateMatch apply(ResultRow row) {
            String name = (String)row.get("module_name", String.class);
            String prefix = (String)row.get("module_uri_prefix", String.class);
            String parsingSchema = (String)row.get("module_parsing_schema", String.class);
            String[] originsAllowed = Text.commaDelimited((String)((String)row.get("module_origins_allowed", String.class)));
            Integer itemsPerPage = (Integer)row.get("items_per_page", Integer.class);
            String pattern = (String)row.get("template_uri_template", String.class);
            Integer priority = (Integer)row.get("template_priority", Integer.class);
            String etagType = (String)row.get("template_etag_type", String.class);
            String etagQuery = (String)row.get("template_etag_query", String.class);
            if ("HASH".equals(etagType)) {
                etagQuery = "";
            }
            if (prefix != null && prefix.trim().length() > 0) {
                pattern = prefix + pattern;
            }
            int p = 0;
            if (priority != null) {
                p = priority;
            }
            TenantIdentifier moduleId = JDBCIdentifiers.valueOf(row, "security_group_id", "module_id");
            TenantIdentifier privilegeId = JDBCIdentifiers.valueOf(row, "security_group_id", "privilege_id");
            TenantIdentifier templateId = JDBCIdentifiers.valueOf(row, "security_group_id", "template_id");
            ResourceModule module = new ResourceModule();
            module.id(moduleId);
            module.itemsPerPage(itemsPerPage);
            module.name(name);
            module.uriPrefix(prefix);
            module.orignsAllowed(originsAllowed);
            module.parsingSchema(parsingSchema);
            module.published(true);
            ResourceTemplate template = new ResourceTemplate();
            template.etagQuery(etagQuery);
            template.id(templateId);
            template.parentId(moduleId);
            template.pattern(pattern);
            template.priority(p);
            return new JDBCResourceTemplateMatch(JDBCResourceTemplateMatchLoader.this.jdbc, this.principal, module, privilegeId, template);
        }
    }
}

