/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;

class JDBCResourceParameters {
    private final JDBCCallProvider jdbc;
    private static final String CREATE_PARAMETER = "insert into wwv_flow_rt$parameters (handler_id,name,bind_variable_name,source_type,access_method,param_type,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:name,:bind_variable_name,:source_type,:access_method,:param_type,:tenant_id,:created_by,:created_on,:created_by,:created_on)";
    private static final Statement CREATE_PARAMETER_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$parameters (handler_id,name,bind_variable_name,source_type,access_method,param_type,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:name,:bind_variable_name,:source_type,:access_method,:param_type,:tenant_id,:created_by,:created_on,:created_by,:created_on)")).parameter("name").parameter("bind_variable_name").parameter("source_type").parameter("access_method").parameter("param_type").parameter("created_by").parameter("created_on", Timestamp.class).build();
    private static final String DELETE_PARAMETERS = "delete from wwv_flow_rt$parameters where security_group_id = :tenant_id and handler_id = :id";
    private static final Statement DELETE_PARAMETERS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$parameters where security_group_id = :tenant_id and handler_id = :id")).build();
    private static final String GET_PARAMETERS = "select p.name, p.bind_variable_name, p.source_type, p.access_method, p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id order by p.name";
    private static final Statement GET_PARAMETERS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select p.name, p.bind_variable_name, p.source_type, p.access_method, p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id order by p.name")).build();

    JDBCResourceParameters(JDBCCallProvider jdbc) {
        this.jdbc = jdbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceHandler parameters(Transaction txn, CompoundPrincipal principal, ResourceHandler existing) {
        Iterator<ResultRow> matches = null;
        try {
            ResourceHandler.ResourceHandlerBuilder b = ResourceHandler.builder(existing);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, existing.id());
            matches = this.query(txn, GET_PARAMETERS_STMT, parameters);
            while (matches.hasNext()) {
                ResultRow row = matches.next();
                ColumnIterator columns = new ColumnIterator(row);
                String originalName = (String)columns.next(String.class);
                String bindName = (String)columns.next(String.class);
                ResourceParameter.Kind kind = ResourceParameter.Kind.value((String)columns.next(String.class));
                ParameterAccess accessMethod = ParameterAccess.value((String)((String)columns.next(String.class)));
                Class<?> primitiveType = JDBCResourceParameters.type((String)columns.next(String.class));
                b.parameter(kind, bindName, originalName, primitiveType, accessMethod);
            }
            Object t = b.build();
            return t;
        }
        finally {
            Closeables.close(matches);
        }
    }

    void replaceParameters(Transaction txn, CompoundPrincipal principal, ResourceHandler handler) {
        try {
            this.deleteParameters(txn, principal, handler);
            this.insertParameters(txn, principal, handler);
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    private void creator(Map<String, Object> parameters, CompoundPrincipal principal) {
        if (principal != null && principal.getName() != null) {
            String user = principal.getName().toUpperCase();
            parameters.put("created_by", user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteParameters(Transaction txn, CompoundPrincipal principal, ResourceHandler handler) throws SQLException {
        JDBCCall deleteParameters = null;
        try {
            deleteParameters = this.jdbc.call(txn, DELETE_PARAMETERS_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, handler.id());
            deleteParameters.bind(parameters);
            deleteParameters.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(deleteParameters);
            throw throwable;
        }
        Closeables.close((Object)deleteParameters);
    }

    void insertParameters(Transaction txn, CompoundPrincipal principal, ResourceHandler handler) {
        JDBCCall insertParameter = null;
        try {
            Timestamp created = new Timestamp(handler.metadata().created());
            Timestamp updated = new Timestamp(handler.metadata().updated());
            Object[] parameters = handler.parameters();
            if (!NullOrEmpty.nullOrEmpty((Object[])parameters)) {
                insertParameter = this.jdbc.insert(txn, CREATE_PARAMETER_STMT, new String[0]);
                for (Object parameter : parameters) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    this.creator(params, principal);
                    JDBCIdentifiers.bind(params, principal, handler.id());
                    params.put("bind_variable_name", ((ResourceParameter)parameter).bindName());
                    params.put("name", ((ResourceParameter)parameter).originalName());
                    params.put("access_method", ((ResourceParameter)parameter).access().name());
                    params.put("source_type", this.sourceType(((ResourceParameter)parameter).kind()));
                    params.put("param_type", this.paramType(((ResourceParameter)parameter).primitiveType()));
                    params.put("created_on", created);
                    params.put("updated_on", updated);
                    insertParameter.bind(params);
                    insertParameter.batch();
                }
                insertParameter.execute();
            }
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
        finally {
            Closeables.close(insertParameter);
        }
    }

    private String paramType(Class<?> primitiveType) {
        if (null == primitiveType || String.class == primitiveType) {
            return "STRING";
        }
        if (Long.class == primitiveType || Long.TYPE == primitiveType) {
            return "LONG";
        }
        if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
            return "INT";
        }
        if (Double.class == primitiveType || Double.TYPE == primitiveType) {
            return "DOUBLE";
        }
        if (Boolean.class == primitiveType || Boolean.TYPE == primitiveType) {
            return "BOOLEAN";
        }
        if (Timestamp.class == primitiveType) {
            return "TIMESTAMP";
        }
        return null;
    }

    private Iterator<ResultRow> query(Transaction txn, Statement stmt, Map<String, Object> parameters) {
        JDBCQuery call = null;
        Iterator results = null;
        try {
            call = this.jdbc.query(txn, stmt, false);
            call.bind(parameters);
            results = call.execute();
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{results, call});
            throw JDBCException.wrap((SQLException)e);
        }
        return results;
    }

    private String sourceType(ResourceParameter.Kind kind) {
        return kind.toString();
    }

    private static Class<?> type(String paramType) {
        if ("STRING".equals(paramType)) {
            return String.class;
        }
        if ("INT".equals(paramType)) {
            return Integer.class;
        }
        if ("DOUBLE".equals(paramType)) {
            return Double.class;
        }
        if ("BOOLEAN".equals(paramType)) {
            return Boolean.class;
        }
        if ("LONG".equals(paramType)) {
            return Long.class;
        }
        if ("TIMESTAMP".equals(paramType)) {
            return Timestamp.class;
        }
        return String.class;
    }
}

