/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.security.Principal;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCMetricsPrincipal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.pools.PoolType;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public abstract class ApexListenerJDBCPrincipal {
    public static final String APEX_LISTENER_POOL_SUFFIX = "_al";

    private ApexListenerJDBCPrincipal() {
    }

    public static CompoundPrincipal apexListener(CompoundPrincipal principal) {
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        if (principal == null) {
            return null;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.defaultPoolPrincipal();
        } else if (existing.getName().endsWith(APEX_LISTENER_POOL_SUFFIX)) {
            return principal;
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        JDBCPrincipal apexListener = ApexListenerJDBCPrincipal.apexListenerJDBCPrincipal(existing);
        ECIDPrincipal ecidPrincipal = (ECIDPrincipal)principal.principal(ECIDPrincipal.class);
        JDBCMetricsPrincipal metrics = JDBCMetricsPrincipal.metrics((CompoundPrincipal)principal, (String)"APEX Listener", (String)"RESTful Services");
        return CompoundPrincipal.compound((Principal[])new Principal[]{apexListener, ecidPrincipal, metrics});
    }

    private static JDBCPrincipal apexListenerJDBCPrincipal(JDBCPrincipal existing) {
        JDBCPrincipal apexListener = existing.modify().poolType(PoolType.APEX_LISTENER).build();
        return apexListener;
    }

    public static CompoundPrincipal apexListener(RequestEntity request) {
        return ApexListenerJDBCPrincipal.apexListener(request.principal());
    }

    public static boolean hasApexListener(CompoundPrincipal principal) {
        if (principal == null) {
            return false;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            return false;
        }
        return ApexListenerJDBCPrincipal.apexListenerJDBCPrincipal(existing).isValid();
    }
}

