/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.RoleMappers;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.cache.CachedPrivilege;
import oracle.dbtools.rt.resource.templates.cache.CachedPrivilegeLoader;
import oracle.dbtools.rt.resource.templates.cache.CachedResourceModule;
import oracle.dbtools.rt.resource.templates.cache.CachedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.cache.EvictionListener;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplateMatchLoader;
import oracle.dbtools.rt.resource.templates.v2.ProtectedResourceTemplateMatch;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

class MetadataCacheImpl
implements MetadataCache {
    private final Timestamp created;
    private final JDBCCallProvider jdbc;
    private final JDBCResourceTemplateMatchLoader loader;
    private final Cache<TenantIdentifier, CachedResourceModule> modules;
    private final CompoundPrincipal principal;
    private final LoadingCache<TenantIdentifier, CachedPrivilege> privileges;
    private static final Log LOG = Log.get(MetadataCacheImpl.class);

    MetadataCacheImpl(JDBCCallProvider jdbc, MetadataCacheConfigurations confs, CompoundPrincipal principal, Timestamp created) {
        this.jdbc = jdbc;
        this.principal = principal;
        this.created = created;
        this.loader = new JDBCResourceTemplateMatchLoader(jdbc);
        RoleMappers roleMappers = (RoleMappers)ServiceLocator.acquire(RoleMappers.class);
        CacheBuilder builder = confs.privileges().cacheBuilder();
        this.privileges = builder.removalListener(new EvictionListener<CachedPrivilege>(CachedPrivilege.class, LOG)).build((CacheLoader)new CachedPrivilegeLoader(jdbc, principal, roleMappers));
        builder = confs.resourceModules().cacheBuilder();
        builder.removalListener(new EvictionListener<CachedResourceModule>(CachedResourceModule.class, LOG));
        this.modules = builder.build();
    }

    @Override
    public AuthorizationPolicy.Access authorize(CompoundPrincipal principal, TenantIdentifier scopeId) {
        CachedPrivilege privilege = (CachedPrivilege)this.privileges.getUnchecked((Object)scopeId);
        if (privilege == null) {
            return AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        }
        return privilege.authorize(principal);
    }

    @Override
    public Timestamp created() {
        return this.created;
    }

    @Override
    public void invalidateModule(TenantIdentifier moduleId) {
        this.modules.invalidate((Object)moduleId);
        this.modules.cleanUp();
        LOG.finest("Invalidated module: " + moduleId);
    }

    @Override
    public void invalidateModules(Iterable<String> modules) {
        this.modules.invalidate(modules);
        this.modules.cleanUp();
        LOG.finest("Invalidated module: " + Iterables.join(modules, (String)", "));
    }

    @Override
    public void invalidatePrivilege(TenantIdentifier privilegeId) {
        this.privileges.invalidate((Object)privilegeId);
        this.privileges.cleanUp();
        LOG.finest("Invalidated privilege: " + privilegeId);
    }

    @Override
    public CachedResourceTemplateMatch resourceTemplate(CompoundPrincipal principal, String path) {
        return this.choose(path);
    }

    @Override
    public TenantIdentifier scopeForPath(String path) {
        CachedResourceTemplateMatch match = this.choose(path);
        if (null == match) {
            return null;
        }
        return match.privilegeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedResourceTemplateMatch choose(String path) {
        Collection<CachedResourceModule> modules = this.modules.asMap().values();
        Set<CachedResourceTemplateMatch> matches = this.matches(modules, path);
        if (matches.isEmpty()) {
            LOG.finest("no cached metadata found for: " + Text.escapeHtml((CharSequence)path));
            LinkedHashMap<TenantIdentifier, CachedResourceModule.Builder> cached = new LinkedHashMap<TenantIdentifier, CachedResourceModule.Builder>();
            Iterator<ProtectedResourceTemplateMatch> results = null;
            try {
                results = this.loader.candidates(this.principal, path);
                while (results.hasNext()) {
                    ProtectedResourceTemplateMatch candidate = results.next();
                    TenantIdentifier moduleId = candidate.module().id();
                    CachedResourceModule.Builder module = (CachedResourceModule.Builder)cached.get(moduleId);
                    if (module == null) {
                        module = new CachedResourceModule.Builder(this.jdbc, this.principal);
                        cached.put(moduleId, module);
                    }
                    module.add(candidate);
                }
            }
            finally {
                Closeables.close(results);
            }
            for (final Map.Entry entry : cached.entrySet()) {
                try {
                    this.modules.get(entry.getKey(), (Callable)new Callable<CachedResourceModule>(){

                        @Override
                        public CachedResourceModule call() throws Exception {
                            CachedResourceModule cachedModule = ((CachedResourceModule.Builder)entry.getValue()).build();
                            LOG.finest("Caching metadata for: " + cachedModule);
                            return cachedModule;
                        }
                    });
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw WebException.internalError(cause, new Reason[0]);
                }
            }
            if (cached.size() > 0) {
                matches = this.matches(modules, path);
            }
        } else {
            LOG.finest("cached metadata hit for: " + Text.escapeHtml((CharSequence)path));
        }
        return (CachedResourceTemplateMatch)Iterables.first(matches);
    }

    private Set<CachedResourceTemplateMatch> matches(Collection<CachedResourceModule> modules, String path) {
        CachedResourceModule module;
        Set<CachedResourceTemplateMatch> matches = new TreeSet<CachedResourceTemplateMatch>();
        Iterator<CachedResourceModule> i$ = modules.iterator();
        while (i$.hasNext() && (matches = (module = i$.next()).matches(path)).isEmpty()) {
        }
        return matches;
    }
}

