/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import java.security.Principal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

class MetadataCacheIdentifier {
    private final String poolIdentifier;
    private final CompoundPrincipal principal;
    private final Number tenantId;

    public MetadataCacheIdentifier(CompoundPrincipal principal) {
        this.principal = principal;
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        this.tenantId = TenantPrincipal.id(tenant);
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        String poolIdentifier = null;
        if (existing == null) {
            throw new IllegalArgumentException();
        }
        this.poolIdentifier = poolIdentifier = existing.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataCacheIdentifier other = (MetadataCacheIdentifier)obj;
        if (this.poolIdentifier == null ? other.poolIdentifier != null : !this.poolIdentifier.equals(other.poolIdentifier)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    public String toString() {
        return "ResourceModuleCacheIdentifier [poolIdentifier=" + this.poolIdentifier + ", principal=" + this.principal + ", tenantId=" + this.tenantId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.poolIdentifier == null ? 0 : this.poolIdentifier.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        return result;
    }

    CompoundPrincipal principal() {
        return this.principal;
    }
}

