/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.paging;

import oracle.dbtools.common.util.Template;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.ResourceRequestFilterBase;

class AutoPaginatedResource
extends ResourceRequestFilterBase {
    private static final String AUTO_PAGINATE_PREFIX = AutoPaginatedResource.encode("select * from (\nselect q_.* , row_number() over (order by 1) {rn} from (\n");
    private static final String AUTO_PAGINATE_SUFFIX = AutoPaginatedResource.encode(") q_\n) \nwhere {rn} between :row_offset and :row_count");

    AutoPaginatedResource(ResourceRequest target) {
        super(target);
    }

    @Override
    public String content() {
        StringBuilder b = new StringBuilder();
        b.append(AUTO_PAGINATE_PREFIX);
        b.append(this.target.content());
        b.append(AUTO_PAGINATE_SUFFIX);
        return b.toString();
    }

    private static final String encode(String sqlWithImplicitRowNumber) {
        Template t = new Template(sqlWithImplicitRowNumber);
        return t.encode(new String[]{"rn", "RN___"});
    }
}

