/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.scope;

import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopeReader;
import oracle.dbtools.rt.oauth.scope.Scopes;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityItemRequestHandler;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ScopeRequestHandler
extends TenantEntityItemRequestHandler<Scope> {
    @Reference
    private Scopes scopes;

    public ScopeRequestHandler() {
        super(OAuthProfile.SCOPE_URI_TEMPLATES, TenantEntityAccess.TENANT, OAuthProfile.OAUTH_SCOPE_JSON);
    }

    @Override
    protected Scope existing(CompoundPrincipal principal, TenantIdentifier id) {
        return this.scopes.entity(null, principal, id);
    }

    @Override
    protected Entity process(CompoundPrincipal principal, Scope existing) {
        return Entities.entity(existing.content(), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, OAuthProfile.OAUTH_SCOPE_JSON}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(CompoundPrincipal principal, Scope existing) {
        Transaction txn = null;
        try {
            txn = this.scopes.newTransaction(principal);
            this.scopes.delete(txn, principal, existing.id());
        }
        catch (Throwable throwable) {
            Closeables.close(txn);
            throw throwable;
        }
        Closeables.close((Object)txn);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ScopeReader();
    }
}

