/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.builtin.jdbc;

import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.Scopes;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.uri.PathMatcher;
import oracle.dbtools.rt.uri.PathMatchers;

@Service
public class SQLDeveloperScopePaths
implements OAuthScopeProvider {
    @Reference
    private Scopes scopes;
    private static final PathMatcher SQL_DEVELOPER_PATHS = PathMatchers.compose(JavaPath.values());
    private static final String SQL_DEVELOPER_SCOPE = "oracle.dbtools.sqldev";

    @Override
    public TenantIdentifier scopeForPath(CompoundPrincipal principal, String path) {
        if (SQL_DEVELOPER_PATHS.matches(path)) {
            return this.sqlDeveloperScope(principal);
        }
        return null;
    }

    private TenantIdentifier sqlDeveloperScope(CompoundPrincipal principal) {
        Scope scope = this.scopes.byScopeName(null, principal, SQL_DEVELOPER_SCOPE);
        if (scope == null) {
            return null;
        }
        return scope.id();
    }

    private static enum JavaPath implements PathMatcher
    {
        RESOURCE_MODULE_COLLECTION(ResourceTemplatesProfile.URI_TEMPLATES),
        SCOPES_COLLECTION(OAuthProfile.SCOPE_URI_TEMPLATES),
        ROLES_COLLECTION(OAuthProfile.ROLE_URI_TEMPLATES),
        MODULE_SCOPES_COLLECTION(OAuthProfile.MODULE_SCOPE_URI_TEMPLATES);

        private final PathMatcher pathMatcher;

        private JavaPath(PathMatcher pathMatcher) {
            this.pathMatcher = pathMatcher;
        }

        @Override
        public boolean matches(String path) {
            return this.pathMatcher.matches(path);
        }
    }
}

