/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.PrivilegeIdCallback;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;

public abstract class ScopeAuthorizationPolicies {
    private ScopeAuthorizationPolicies() {
    }

    public static boolean authorizeScope(CompoundPrincipal principal, TenantIdentifier scopeId) {
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        for (ScopeAuthorizationPolicy policy : ServiceLocator.acquireAll(ScopeAuthorizationPolicy.class, (String[])new String[0])) {
            AuthorizationPolicy.Access result = policy.authorize((Principal)principal, scopeId);
            if (AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN == result) continue;
            access = result;
            break;
        }
        return AuthorizationPolicy.Access.NONE != access && AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN != access;
    }

    public static TenantIdentifier scope(CallbackHandler callbackHandler) {
        TenantIdentifier scopeId;
        block1: {
            OAuthScopeProvider scopeProvider;
            HeaderCallback p = new HeaderCallback((CharSequence)"X-APEX-PATH");
            CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
            PrivilegeIdCallback pi = new PrivilegeIdCallback();
            ScopeAuthorizationPolicies.callback(callbackHandler, new Callback[]{p, cp, pi});
            String path = p.getValue();
            CompoundPrincipal principal = cp.getPrincipal();
            scopeId = pi.getPrivilegeId();
            if (scopeId != null) break block1;
            Iterator i$ = ServiceLocator.acquireAll(OAuthScopeProvider.class, (String[])new String[0]).iterator();
            while (i$.hasNext() && (scopeId = (scopeProvider = (OAuthScopeProvider)i$.next()).scopeForPath(principal, path)) == null) {
            }
        }
        return scopeId;
    }

    private static void callback(CallbackHandler callbackHandler, Callback ... callbacks) {
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw ScopeAuthorizationPolicies.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw ScopeAuthorizationPolicies.wrap(e);
        }
    }

    private static RuntimeException wrap(Exception e) {
        return new RuntimeException(e);
    }
}

