/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.json.JSONFormatter;
import oracle.dbtools.json.JSONRenderer;

public class JSONStringRenderer
implements JSONRenderer,
Closeable {
    private final StringBuilder text;
    private final JSONFormatter w;

    public JSONStringRenderer(int capacity) {
        this.text = new StringBuilder(capacity);
        this.w = new JSONFormatter((Appendable)this.text);
    }

    @Override
    public void close() throws IOException {
        this.w.close();
    }

    public void end() {
        this.w.end();
    }

    public void endArray() {
        this.w.endArray();
    }

    public void flush(boolean endOfStream) {
        this.w.flush(endOfStream);
    }

    public void name(QName name) {
        this.w.name(name);
    }

    public void property(QName name, CharSequence value) {
        this.w.property(name, value);
    }

    public void reset() {
        StringBuilders.reset((StringBuilder)this.text);
    }

    public int size() {
        return this.text.length();
    }

    public void start() {
        this.w.start();
    }

    public void startArray() {
        this.w.startArray();
    }

    public void text(CharSequence text) {
        this.w.text(text);
    }

    public String toString() {
        return this.text.toString();
    }

    public void value(Boolean value) {
        this.w.value(value);
    }

    public void value(CharSequence value) {
        this.w.value(value);
    }

    public void value(Number value) {
        this.w.value(value);
    }

    public void value(Reader value) {
        this.w.value(value);
    }
}

