/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.jdbc.entity.JDBCTenantPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(priority=1)
public class JDBCTenantsProvider
extends UsesQuery
implements TenantsProvider {
    @Reference
    private JDBCCallProvider jdbc;
    private LoadingCache<JDBCTenantIdentifier, JDBCTenantPrincipal> tenants;
    private static final Statement TENANT = StatementBuilder.query((String)"select c.provisioning_company_id from wwv_flow_companies c where c.short_name = :name", (String[])new String[]{"name"});
    private static final Log LOG = Log.get(JDBCTenantsProvider.class);

    @Override
    public TenantPrincipal tenant(CompoundPrincipal principal, String tenantName) {
        JDBCTenantPrincipal tenant = null;
        try {
            tenant = (JDBCTenantPrincipal)this.tenants.get((Object)new JDBCTenantIdentifier(principal, tenantName));
        }
        catch (ExecutionException e) {
            LOG.fine(e.getCause());
        }
        return tenant;
    }

    protected void activate(ServiceProperties props) {
        long reloadTime = 3600L;
        GlobalConfiguration conf = GlobalConfiguration.globalConfiguration();
        String reloadTimes = conf.get("multitenant.reload", "3600");
        try {
            reloadTime = Long.parseLong(reloadTimes);
        }
        catch (NumberFormatException e) {
            reloadTime = 3600L;
        }
        this.tenants = CacheBuilder.newBuilder().expireAfterWrite(reloadTime, TimeUnit.SECONDS).build((CacheLoader)new CachedJDBCTenantLoader());
    }

    private final class CachedJDBCTenantLoader
    extends CacheLoader<JDBCTenantIdentifier, JDBCTenantPrincipal> {
        private CachedJDBCTenantLoader() {
        }

        public JDBCTenantPrincipal load(JDBCTenantIdentifier key) throws Exception {
            Iterator matches;
            JDBCTransaction txn;
            block5: {
                CompoundPrincipal principal = key.principal;
                String tenantName = key.name;
                CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
                Map parameters = Maps.toMap((String[])new String[]{"name", tenantName.toUpperCase()});
                txn = null;
                matches = null;
                txn = JDBCTenantsProvider.this.jdbc.transaction((Principal)apexListener);
                matches = JDBCTenantsProvider.this.query.query((Transaction)txn, TENANT, parameters, false);
                if (!matches.hasNext()) break block5;
                ResultRow row = (ResultRow)matches.next();
                Number id = (Number)row.get(1, Number.class);
                JDBCTenantPrincipal jDBCTenantPrincipal = new JDBCTenantPrincipal(tenantName, id);
                Closeables.close((Object[])new Object[]{matches, txn});
                return jDBCTenantPrincipal;
            }
            try {
                try {
                    throw new IllegalArgumentException();
                }
                catch (SQLException e) {
                    throw JDBCException.wrap((SQLException)e);
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{matches, txn});
                throw throwable;
            }
        }
    }

    private static final class JDBCTenantIdentifier {
        final String name;
        final transient CompoundPrincipal principal;

        JDBCTenantIdentifier(CompoundPrincipal principal, String name) {
            this.principal = principal;
            this.name = name.toUpperCase();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JDBCTenantIdentifier other = (JDBCTenantIdentifier)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }
    }
}

