/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.ApexWorkspaceTenantPrincipal;
import oracle.dbtools.rt.jdbc.entity.JDBCTenantPrincipal;
import oracle.dbtools.rt.jdbc.entity.TenantDispatcherBase;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class JDBCTenantDispatcher
extends TenantDispatcherBase {
    @Reference
    private QueryProvider query;
    @Reference
    private JDBCCallProvider jdbc;
    private static final Statement CAN_DISPATCH = StatementBuilder.query((String)"select c.provisioning_company_id, p.workspace_identifier from wwv_flow_companies c, pool_config p where ('BASE_PATH' = p.type and :base_path = p.uri) and (p.workspace_identifier = c.short_name)", (String[])new String[]{"base_path"});

    @Override
    protected TenantPrincipal tenant(RequestEntity request, String tenantPathPrefix) {
        JDBCTenantPrincipal tenant;
        block7: {
            block9: {
                Iterator results;
                JDBCTransaction txn;
                block6: {
                    CompoundPrincipal principal;
                    block8: {
                        tenant = null;
                        principal = request.principal();
                        if (principal == null) break block7;
                        JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
                        if (jdbcPrincipal != null) break block8;
                        Requests.log(request, "No JDBC Principal established, cannot dispatch");
                        break block7;
                    }
                    TenantPrincipal tenantPrincipal = (TenantPrincipal)principal.principal(TenantPrincipal.class);
                    boolean hasTenant = TenantPrincipal.hasTenant(tenantPrincipal);
                    boolean isInjectedTenant = ApexWorkspaceTenantPrincipal.class.equals(tenantPrincipal.getClass());
                    if (!hasTenant || !isInjectedTenant) break block7;
                    if (!ApexListenerJDBCPrincipal.hasApexListener(principal)) break block9;
                    CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("base_path", tenantPathPrefix);
                    txn = null;
                    results = null;
                    try {
                        txn = this.jdbc.transaction((Principal)apexListener);
                        results = this.query.query((Transaction)txn, CAN_DISPATCH, parameters, false);
                        if (results.hasNext()) {
                            ColumnIterator columns = new ColumnIterator((ResultRow)results.next());
                            Number id = (Number)columns.next(Number.class);
                            String name = (String)columns.next(String.class);
                            JDBCTenantPrincipal matched = new JDBCTenantPrincipal(name, id);
                            if (matched.equals(tenantPrincipal)) {
                                Requests.log(request, "Matching tenant found for: " + tenantPathPrefix + ", dispatching...");
                                tenant = matched;
                            }
                            break block6;
                        }
                        Requests.log(request, "No matching tenant found for: " + tenantPathPrefix + ", cannot dispatch");
                    }
                    catch (SQLException e) {
                        try {
                            throw JDBCException.wrap((SQLException)e);
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new Object[]{results, txn});
                            throw throwable;
                        }
                    }
                }
                Closeables.close((Object[])new Object[]{results, txn});
                break block7;
            }
            Requests.log(request, "APEX_LISTENER pool does not exist, cannot dispatch");
        }
        return tenant;
    }
}

