/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatements;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatementsImpl;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.jdbc.entity.JDBCNestedEntityStatements;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class JDBCEntityProviderBase<T extends TenantEntity>
implements EntityStorage<T> {
    private final JDBCEntityStatements stmts;
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private QueryProvider queryProvider;
    private final JDBCEntityMetaData.JDBCEntityReader<T> reader;
    private final JDBCEntityMetaData.JDBCEntityWriter<T> writer;

    protected JDBCEntityProviderBase(JDBCEntityMetaData<T> metadata) {
        this(new JDBCEntityStatementsImpl<T>(metadata), metadata.reader(), metadata.writer());
    }

    protected JDBCEntityProviderBase(JDBCEntityStatements stmts, JDBCEntityMetaData.JDBCEntityReader<T> reader, JDBCEntityMetaData.JDBCEntityWriter<T> writer) {
        this.stmts = stmts;
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCCall delete = null;
        try {
            JDBCEntityProviderBase.verifyTenant(principal, id, true);
            this.deleted(txn, principal, id);
            delete = this.jdbc().call(txn, this.stmts.delete());
            HashMap<String, Object> params = new HashMap<String, Object>();
            JDBCIdentifiers.bind(params, principal, id);
            this.creator(params, principal);
            delete.bind(params);
            delete.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(delete);
                throw throwable;
            }
        }
        Closeables.close((Object)delete);
    }

    @Override
    public Iterable<T> entities(Transaction txn, CompoundPrincipal principal) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.creator(parameters, principal);
        return this.entities(txn, principal, this.stmts.entities(), parameters);
    }

    @Override
    public T entity(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        try {
            JDBCEntityProviderBase.verifyTenant(principal, entityId, false);
            return this.entity(principal, this.stmts.entityById(), JDBCIdentifiers.entityId(entityId), "id");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public T insert(Transaction txn, CompoundPrincipal principal, T instance) {
        T t;
        JDBCCall insert = null;
        try {
            String creator = Text.upper((String)principal.getName());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            insert = this.jdbc().insert(txn, this.stmts.insert(), new String[]{"ID"});
            Map params = (Map)this.writer.apply(instance);
            JDBCIdentifiers.bind(params, principal);
            if (creator != null) {
                params.put("created_by", creator);
                params.put("updated_by", creator);
            }
            params.put("created_on", now);
            params.put("updated_on", now);
            insert.bind(params);
            BindableCallResults keys = insert.execute();
            instance.id(JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys));
            t = this.inserted(txn, principal, instance);
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(insert);
                throw throwable;
            }
        }
        Closeables.close((Object)insert);
        return t;
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        return this._newTransaction(apexListener);
    }

    @Override
    public T update(Transaction txn, CompoundPrincipal principal, T instance) {
        T t;
        JDBCCall update = null;
        try {
            JDBCEntityProviderBase.verifyTenant(principal, instance.id(), true);
            String updator = Text.upper((String)principal.getName());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            update = this.jdbc().call(txn, this.stmts.update());
            Map params = (Map)this.writer.apply(instance);
            JDBCIdentifiers.bind(params, principal, instance.id());
            if (updator != null) {
                params.put("created_by", updator);
                params.put("updated_by", updator);
            }
            params.put("updated_on", now);
            update.bind(params);
            update.execute();
            this.deleteChildren(txn, principal, instance);
            t = this.updated(txn, principal, instance);
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(update);
                throw throwable;
            }
        }
        Closeables.close((Object)update);
        return t;
    }

    protected void creator(Map<String, Object> parameters, CompoundPrincipal principal) {
        if (principal != null && principal.getName() != null) {
            String user = principal.getName().toUpperCase();
            parameters.put("created_by", user);
        }
    }

    protected void deleteChildren(Transaction txn, CompoundPrincipal principal, T instance) {
        Statement stmt;
        if (this.stmts instanceof JDBCNestedEntityStatements && (stmt = ((JDBCNestedEntityStatements)this.stmts).deleteChildren()) != null) {
            TenantIdentifier id = instance.id();
            JDBCCall delete = null;
            try {
                JDBCEntityProviderBase.verifyTenant(principal, id, true);
                delete = this.jdbc().call(txn, stmt);
                HashMap<String, Object> params = new HashMap<String, Object>();
                JDBCIdentifiers.bind(params, principal, id, "parent_id");
                this.creator(params, principal);
                delete.bind(params);
                delete.execute();
            }
            catch (SQLException e) {
                try {
                    throw WebException.internalError(e, new Reason[0]);
                }
                catch (Throwable throwable) {
                    Closeables.close(delete);
                    throw throwable;
                }
            }
            Closeables.close((Object)delete);
        }
    }

    protected void deleted(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<T> entities(Transaction txn, CompoundPrincipal principal, Statement stmt, Map<String, Object> parameters) {
        ArrayList results = new ArrayList();
        try {
            JDBCIdentifiers.bind(parameters, principal);
            Iterator<ResultRow> matches = null;
            try {
                matches = this.query(txn, stmt, parameters);
                Iterators.add(results, (Iterator)Iterators.transform(matches, this.reader));
            }
            finally {
                Closeables.close(matches);
            }
        }
        catch (ConnectionPoolException e) {
            return null;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T entity(CompoundPrincipal principal, Statement stmt, Map<String, Object> expected) {
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        TenantEntity existing = null;
        Transaction txn = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(expected);
        JDBCIdentifiers.bind(parameters, principal);
        this.creator(parameters, principal);
        Iterator<ResultRow> matches = null;
        try {
            txn = this.newTransaction(apexListener);
            matches = this.queryOneRow(txn, stmt, parameters);
            existing = (TenantEntity)Iterators.nextOrNull((Iterator)Iterators.transform(matches, this.reader));
            if (existing != null) {
                existing = this.retrieved(txn, principal, existing);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{matches, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return (T)existing;
    }

    protected T entity(CompoundPrincipal principal, Statement stmt, Object expected, String column) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(column, expected);
        return this.entity(principal, stmt, parameters);
    }

    protected T inserted(Transaction txn, CompoundPrincipal principal, T instance) {
        return instance;
    }

    protected JDBCCallProvider jdbc() {
        return this.jdbc;
    }

    protected JDBCEntityStatements stmts() {
        return this.stmts;
    }

    protected Iterator<ResultRow> query(Transaction txn, Statement stmt, Map<String, Object> parameters) {
        return this.queryProvider.query(txn, stmt, parameters, false);
    }

    protected Iterator<ResultRow> queryOneRow(Transaction txn, Statement stmt, Map<String, Object> parameters) {
        JDBCQuery call = null;
        Iterator results = null;
        try {
            call = this.jdbc.query(txn, stmt, false);
            call.setFetchSize(1);
            call.bind(parameters);
            results = call.execute();
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{results, call});
            throw JDBCException.wrap((SQLException)e);
        }
        return results;
    }

    protected QueryProvider queryProvider() {
        return this.queryProvider;
    }

    protected T retrieved(Transaction txn, CompoundPrincipal principal, T existing) {
        return existing;
    }

    protected T updated(Transaction txn, CompoundPrincipal principal, T instance) {
        return instance;
    }

    private Transaction _newTransaction(CompoundPrincipal apexListener) {
        try {
            return this.jdbc().transaction((Principal)apexListener);
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    protected static void verifyTenant(CompoundPrincipal principal, TenantIdentifier id, boolean write) {
        JDBCIdentifiers.verify(principal, id, write);
    }
}

