/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public final class NoTenantPrincipal
extends TenantPrincipal {
    private static final Number NO_TENANT_ID = NumericIdentifiers.identifier((Number)-1);
    private static final String NO_TENANT_NAME = "__no_tenant__";
    private static final long serialVersionUID = -6404185622765562810L;
    private static final TenantPrincipal THE_NO_TENANT = new NoTenantPrincipal();

    private NoTenantPrincipal() {
        super(NO_TENANT_NAME, NO_TENANT_ID);
    }

    @Override
    public String string(TenantIdentifier id) {
        Number entityId = id.entityId();
        return NumericIdentifiers.string((Number)entityId);
    }

    @Override
    public TenantIdentifier valueOf(String text) {
        Number entityId = NumericIdentifiers.valueOf((String)text);
        return TenantIdentifier.id(this.id(), entityId);
    }

    public static boolean hasTenant(TenantPrincipal tenant) {
        return THE_NO_TENANT != tenant;
    }

    public static TenantPrincipal instance() {
        return THE_NO_TENANT;
    }
}

