/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import java.security.Principal;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.home.EntityStores;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public abstract class EntityTreeStorageBase<T extends TenantEntity> {
    private EntityStores stores;

    protected EntityTreeStorageBase() {
    }

    public TenantIdentifier create(CompoundPrincipal principal, Tree<T> entities) {
        Transaction txn = this.newTransaction(principal, entities);
        try {
            long created = System.currentTimeMillis();
            T stored = this.insert(txn, principal, created, entities);
            TenantIdentifier parentId = stored.id();
            this.insertChildren(txn, principal, created, parentId, entities);
            TenantIdentifier tenantIdentifier = parentId;
            return tenantIdentifier;
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    public void update(CompoundPrincipal principal, TenantIdentifier id, Tree<T> entities) {
        Transaction txn = this.newTransaction(principal, entities);
        try {
            long updated = System.currentTimeMillis();
            T stored = this.update(txn, principal, id, updated, entities);
            TenantIdentifier parentId = stored.id();
            this.insertChildren(txn, principal, updated, parentId, entities);
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    protected void activate(ServiceProperties props) {
        this.stores = new EntityStores();
    }

    protected T entity(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId, Class<? extends T> type) {
        if (entityId == null) {
            return null;
        }
        return (T)((TenantEntity)type.cast(this.stores.entity(txn, principal, type, entityId)));
    }

    protected Transaction newTransaction(CompoundPrincipal principal, Tree<? extends T> entities) {
        TenantEntity instance = (TenantEntity)entities.node();
        return this.stores.newTransaction(principal, instance);
    }

    protected String user(Principal principal) {
        String user = null;
        if (principal != null) {
            user = principal.getName();
        }
        return user;
    }

    private WebException alreadyExists() {
        return WebException.badRequest(Reason.reason("duplicateEntity", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "EntityTreeStorageBase.0", "Entity already exists", new Object[0])));
    }

    private T insert(Transaction txn, CompoundPrincipal principal, long created, Tree<T> entities) {
        String user = this.user((Principal)principal);
        TenantEntity instance = (TenantEntity)entities.node();
        Class<TenantEntity> type = this.typeOf(instance);
        instance.metadata().createdBy(user, created);
        TenantEntity stored = type.cast(this.stores.insert(txn, principal, instance));
        return (T)stored;
    }

    private void insertChildren(Transaction txn, CompoundPrincipal principal, long modified, TenantIdentifier parentId, Tree<T> entities) {
        for (Tree child : entities) {
            TenantEntity childEntity = (TenantEntity)child.node();
            childEntity.parentId(parentId);
            T stored = this.insert(txn, principal, modified, child);
            TenantIdentifier id = stored.id();
            long created = stored.metadata().created();
            this.insertChildren(txn, principal, created, id, child);
        }
    }

    private Class<T> typeOf(T instance) {
        return instance.getClass();
    }

    private T update(Transaction txn, CompoundPrincipal principal, TenantIdentifier id, long updated, Tree<T> entities) {
        String user = this.user((Principal)principal);
        TenantEntity instance = (TenantEntity)entities.node();
        Class<TenantEntity> type = this.typeOf(instance);
        instance.id(id);
        instance.metadata().updatedBy(user, updated);
        TenantEntity stored = type.cast(this.stores.update(txn, principal, instance));
        return (T)stored;
    }
}

