/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authorization.PrivilegeIdCallback;
import oracle.dbtools.rt.authorization.PrivilegeSecurityConfig;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;

public class PrivilegeIdCallbackHandler
implements CallbackHandler {
    private final TenantIdentifier privilegeId;
    private final CallbackHandler target;

    public PrivilegeIdCallbackHandler(CallbackHandler target, SecurityConfig conf) {
        this.target = target;
        TenantIdentifier id = null;
        if (conf instanceof PrivilegeSecurityConfig) {
            id = ((PrivilegeSecurityConfig)conf).id();
        }
        this.privilegeId = id;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof PrivilegeIdCallback)) continue;
            ((PrivilegeIdCallback)callback).setPrivilegeId(this.privilegeId);
        }
        this.target.handle(callbacks);
    }
}

