/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonAuthenticatorBase;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.session.ServletSessionCallback;
import oracle.dbtools.rt.session.SessionState;

@Service
@Authenticates(value=AuthenticationRealm.LOGON)
public class SessionAuthenticator
extends LogonAuthenticatorBase
implements RealmAuthenticator {
    @Override
    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        AuthenticationResult result = super.authenticate(callbackHandler);
        if (result.isValid()) {
            ServletSessionCallback s = new ServletSessionCallback("_com.oracle.al");
            Callback[] callbacks = new Callback[]{s};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                throw this.wrap(e);
            }
            catch (UnsupportedCallbackException e) {
                throw this.wrap(e);
            }
            SessionState preLogonSession = (SessionState)s.getAttribute();
            if (preLogonSession != null) {
                String startPath = preLogonSession.startPath();
                LogonRealm realm = preLogonSession.logonRealm();
                return this.session(startPath, realm, result);
            }
        }
        return result;
    }

    private AuthenticationResult session(String startPath, LogonRealm realm, AuthenticationResult result) {
        CompoundPrincipal principal = CompoundPrincipal.compound((Iterable)result);
        if (principal == null) {
            return null;
        }
        SessionState session = SessionState.authenticatedSession(startPath, realm, principal);
        AuthenticationResult withSessionState = result.modify().context((Object)session).build();
        return withSessionState;
    }
}

